/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.beans;

import ai.org.jfree.beans.AbstractChart;
import ai.org.jfree.beans.editors.RotationEditor;
import ai.org.jfree.beans.events.SectionClickEvent;
import ai.org.jfree.beans.events.SectionClickListener;
import ai.org.jfree.chart.JFreeChart;
import ai.org.jfree.chart.entity.ChartEntity;
import ai.org.jfree.chart.entity.PieSectionEntity;
import ai.org.jfree.chart.labels.PieSectionLabelGenerator;
import ai.org.jfree.chart.labels.StandardPieSectionLabelGenerator;
import ai.org.jfree.chart.labels.StandardPieToolTipGenerator;
import ai.org.jfree.chart.plot.PiePlot;
import ai.org.jfree.data.general.DefaultPieDataset;
import ai.org.jfree.data.general.PieDataset;
import ai.org.jfree.util.Rotation;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.event.MouseEvent;
import java.beans.PropertyEditorManager;
import java.util.EventListener;
import javax.swing.event.EventListenerList;

public class JPieChart
extends AbstractChart {
    private String labelFormat = "{0}";
    private EventListenerList sectionClickListeners = new EventListenerList();

    protected JFreeChart createDefaultChart() {
        DefaultPieDataset defaultPieDataset = new DefaultPieDataset();
        defaultPieDataset.setValue((Comparable)((Object)"A"), 5.0);
        defaultPieDataset.setValue((Comparable)((Object)"B"), 7.0);
        defaultPieDataset.setValue((Comparable)((Object)"C"), 6.0);
        PiePlot piePlot = new PiePlot(defaultPieDataset);
        JFreeChart jFreeChart = new JFreeChart(piePlot);
        jFreeChart.setTitle("JPieChart - Title");
        piePlot.setToolTipGenerator(new StandardPieToolTipGenerator());
        return jFreeChart;
    }

    public Rotation getDirection() {
        Rotation rotation = null;
        PiePlot piePlot = (PiePlot)this.chart.getPlot();
        if (piePlot != null) {
            rotation = piePlot.getDirection();
        }
        return rotation;
    }

    public void setDirection(Rotation rotation) {
        PiePlot piePlot = (PiePlot)this.chart.getPlot();
        if (piePlot != null) {
            Rotation rotation2 = piePlot.getDirection();
            piePlot.setDirection(rotation);
            this.firePropertyChange("direction", rotation2, rotation);
        }
    }

    public PieDataset getDataset() {
        PieDataset pieDataset = null;
        PiePlot piePlot = (PiePlot)this.chart.getPlot();
        if (piePlot != null) {
            pieDataset = piePlot.getDataset();
        }
        return pieDataset;
    }

    public void setDataset(PieDataset pieDataset) {
        PiePlot piePlot = (PiePlot)this.chart.getPlot();
        if (piePlot != null) {
            PieDataset pieDataset2 = piePlot.getDataset();
            piePlot.setDataset(pieDataset);
            this.firePropertyChange("dataset", pieDataset2, pieDataset);
        }
    }

    public boolean isCircular() {
        PiePlot piePlot = (PiePlot)this.chart.getPlot();
        return piePlot.isCircular();
    }

    public void setCircular(boolean bl) {
        PiePlot piePlot = (PiePlot)this.chart.getPlot();
        boolean bl2 = piePlot.isCircular();
        piePlot.setCircular(bl);
        this.firePropertyChange("circular", bl2, bl);
    }

    public double getPieStartingAngle() {
        PiePlot piePlot = (PiePlot)this.chart.getPlot();
        return piePlot.getStartAngle();
    }

    public void setPieStartingAngle(double d) {
        PiePlot piePlot = (PiePlot)this.chart.getPlot();
        double d2 = piePlot.getStartAngle();
        piePlot.setStartAngle(d);
        this.firePropertyChange("pieStartingAngle", d2, d);
    }

    public String getLabelFormat() {
        String string = null;
        PiePlot piePlot = (PiePlot)this.chart.getPlot();
        PieSectionLabelGenerator pieSectionLabelGenerator = piePlot.getLabelGenerator();
        if (pieSectionLabelGenerator instanceof StandardPieSectionLabelGenerator) {
            StandardPieSectionLabelGenerator standardPieSectionLabelGenerator = (StandardPieSectionLabelGenerator)pieSectionLabelGenerator;
            string = standardPieSectionLabelGenerator.getLabelFormat();
        }
        return string;
    }

    public void setLabelFormat(String string) {
        PiePlot piePlot = (PiePlot)this.chart.getPlot();
        String string2 = this.labelFormat;
        this.labelFormat = string;
        piePlot.setLabelGenerator(new StandardPieSectionLabelGenerator(string));
        this.firePropertyChange("labelFormat", string2, string);
    }

    public Font getLabelFont() {
        Font font = null;
        PiePlot piePlot = (PiePlot)this.chart.getPlot();
        if (piePlot != null) {
            return piePlot.getLabelFont();
        }
        return font;
    }

    public void setLabelFont(Font font) {
        PiePlot piePlot = (PiePlot)this.chart.getPlot();
        if (piePlot != null) {
            Font font2 = piePlot.getLabelFont();
            piePlot.setLabelFont(font);
            this.firePropertyChange("labelFont", font2, font);
        }
    }

    public Paint getLabelPaint() {
        Paint paint = null;
        PiePlot piePlot = (PiePlot)this.chart.getPlot();
        if (piePlot != null) {
            return piePlot.getLabelPaint();
        }
        return paint;
    }

    public void setLabelPaint(Paint paint) {
        PiePlot piePlot = (PiePlot)this.chart.getPlot();
        if (piePlot != null) {
            Paint paint2 = piePlot.getLabelPaint();
            piePlot.setLabelPaint(paint);
            this.firePropertyChange("labelPaint", paint2, paint);
        }
    }

    public String getSectionToolTipFormat() {
        PiePlot piePlot = (PiePlot)this.chart.getPlot();
        if (piePlot == null) {
            return "";
        }
        StandardPieToolTipGenerator standardPieToolTipGenerator = (StandardPieToolTipGenerator)piePlot.getToolTipGenerator();
        if (standardPieToolTipGenerator == null) {
            return "";
        }
        return standardPieToolTipGenerator.getLabelFormat();
    }

    public void setSectionToolTipFormat(String string) {
        PiePlot piePlot = (PiePlot)this.chart.getPlot();
        if (piePlot == null) {
            return;
        }
        if (string.equals("")) {
            piePlot.setToolTipGenerator(null);
        } else {
            piePlot.setToolTipGenerator(new StandardPieToolTipGenerator(string));
        }
        this.firePropertyChange("sectionToolTipFormat", "", string);
    }

    public void addSectionClickListener(SectionClickListener sectionClickListener) {
        if (sectionClickListener == null) {
            throw new IllegalArgumentException("Null 'listener' argument.");
        }
        this.sectionClickListeners.add(SectionClickListener.class, sectionClickListener);
    }

    public void removeSectionClickListener(SectionClickListener sectionClickListener) {
        if (sectionClickListener == null) {
            throw new IllegalArgumentException("Null 'listener' argument.");
        }
        this.sectionClickListeners.remove(SectionClickListener.class, sectionClickListener);
    }

    public void fireSectionClickEvent(SectionClickEvent sectionClickEvent) {
        EventListener[] eventListenerArray = this.sectionClickListeners.getListeners(SectionClickListener.class);
        for (int i = eventListenerArray.length - 1; i >= 0; --i) {
            ((SectionClickListener)eventListenerArray[i]).onSectionClick(sectionClickEvent);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        Object object;
        EventListener[] eventListenerArray = this.sectionClickListeners.getListeners(SectionClickListener.class);
        if (eventListenerArray.length == 0) {
            super.mouseClicked(mouseEvent);
            return;
        }
        Insets insets = this.getInsets();
        int n = mouseEvent.getX() - insets.left;
        int n2 = mouseEvent.getY() - insets.top;
        ChartEntity chartEntity = null;
        if (this.info != null && (object = this.info.getEntityCollection()) != null) {
            chartEntity = object.getEntity(n, n2);
        }
        if (chartEntity instanceof PieSectionEntity) {
            object = (PieSectionEntity)chartEntity;
            SectionClickEvent sectionClickEvent = new SectionClickEvent(this, ((PieSectionEntity)object).getSectionKey());
            this.fireSectionClickEvent(sectionClickEvent);
        } else {
            super.mouseClicked(mouseEvent);
        }
    }

    static {
        PropertyEditorManager.registerEditor(Rotation.class, RotationEditor.class);
    }
}

