/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.beans;

import ai.org.jfree.beans.AbstractChart;
import ai.org.jfree.beans.AxisScale;
import ai.org.jfree.beans.editors.AxisScaleEditor;
import ai.org.jfree.beans.events.XYItemClickEvent;
import ai.org.jfree.beans.events.XYItemClickListener;
import ai.org.jfree.chart.axis.AxisLocation;
import ai.org.jfree.chart.axis.NumberAxis;
import ai.org.jfree.chart.axis.ValueAxis;
import ai.org.jfree.chart.entity.ChartEntity;
import ai.org.jfree.chart.entity.XYItemEntity;
import ai.org.jfree.chart.labels.StandardXYToolTipGenerator;
import ai.org.jfree.chart.plot.PlotOrientation;
import ai.org.jfree.chart.plot.XYPlot;
import ai.org.jfree.chart.renderer.xy.XYItemRenderer;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.event.MouseEvent;
import java.beans.PropertyEditorManager;
import java.text.NumberFormat;
import java.util.EventListener;

public abstract class AbstractXYChart
extends AbstractChart {
    private AxisScale yAxisScale = AxisScale.FLOAT;

    public PlotOrientation getOrientation() {
        PlotOrientation plotOrientation = null;
        XYPlot xYPlot = (XYPlot)this.chart.getPlot();
        if (xYPlot != null) {
            plotOrientation = xYPlot.getOrientation();
        }
        return plotOrientation;
    }

    public void setOrientation(PlotOrientation plotOrientation) {
        XYPlot xYPlot = (XYPlot)this.chart.getPlot();
        if (xYPlot != null) {
            PlotOrientation plotOrientation2 = xYPlot.getOrientation();
            xYPlot.setOrientation(plotOrientation);
            this.firePropertyChange("orientation", plotOrientation2, plotOrientation);
        }
    }

    public String getXAxisLabel() {
        String string = null;
        XYPlot xYPlot = (XYPlot)this.chart.getPlot();
        if (xYPlot != null) {
            string = xYPlot.getDomainAxis().getLabel();
        }
        return string;
    }

    public void setXAxisLabel(String string) {
        XYPlot xYPlot = (XYPlot)this.chart.getPlot();
        if (xYPlot != null) {
            ValueAxis valueAxis = xYPlot.getDomainAxis();
            String string2 = valueAxis.getLabel();
            valueAxis.setLabel(string);
            this.firePropertyChange("xAxisLabel", string2, string);
        }
    }

    public Font getXAxisLabelFont() {
        Font font = null;
        XYPlot xYPlot = (XYPlot)this.chart.getPlot();
        if (xYPlot != null) {
            font = xYPlot.getDomainAxis().getLabelFont();
        }
        return font;
    }

    public void setXAxisLabelFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("Null 'font' argument.");
        }
        XYPlot xYPlot = (XYPlot)this.chart.getPlot();
        if (xYPlot != null) {
            ValueAxis valueAxis = xYPlot.getDomainAxis();
            Font font2 = valueAxis.getLabelFont();
            valueAxis.setLabelFont(font);
            this.firePropertyChange("xAxisLabelFont", font2, font);
        }
    }

    public Paint getXAxisLabelPaint() {
        Paint paint = null;
        XYPlot xYPlot = (XYPlot)this.chart.getPlot();
        if (xYPlot != null) {
            paint = xYPlot.getDomainAxis().getLabelPaint();
        }
        return paint;
    }

    public void setXAxisLabelPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        XYPlot xYPlot = (XYPlot)this.chart.getPlot();
        if (xYPlot != null) {
            ValueAxis valueAxis = xYPlot.getDomainAxis();
            Paint paint2 = valueAxis.getLabelPaint();
            valueAxis.setLabelPaint(paint);
            this.firePropertyChange("xAxisLabelPaint", paint2, paint);
        }
    }

    public boolean isXAxisInverted() {
        XYPlot xYPlot = (XYPlot)this.chart.getPlot();
        if (xYPlot != null) {
            return xYPlot.getDomainAxis().isInverted();
        }
        return false;
    }

    public void setXAxisInverted(boolean bl) {
        XYPlot xYPlot = (XYPlot)this.chart.getPlot();
        if (xYPlot != null) {
            ValueAxis valueAxis = xYPlot.getDomainAxis();
            boolean bl2 = valueAxis.isInverted();
            valueAxis.setInverted(bl);
            this.firePropertyChange("xAxisInverted", bl2, bl);
        }
    }

    public double getXAxisLowerMargin() {
        XYPlot xYPlot = (XYPlot)this.chart.getPlot();
        if (xYPlot != null) {
            return xYPlot.getDomainAxis().getLowerMargin();
        }
        return -1.0;
    }

    public void setXAxisLowerMargin(double d) {
        XYPlot xYPlot = (XYPlot)this.chart.getPlot();
        if (xYPlot != null) {
            ValueAxis valueAxis = xYPlot.getDomainAxis();
            double d2 = valueAxis.getLowerMargin();
            valueAxis.setLowerMargin(d);
            this.firePropertyChange("xAxisLowerMargin", d2, d);
        }
    }

    public double getXAxisUpperMargin() {
        XYPlot xYPlot = (XYPlot)this.chart.getPlot();
        if (xYPlot != null) {
            return xYPlot.getDomainAxis().getUpperMargin();
        }
        return -1.0;
    }

    public void setXAxisUpperMargin(double d) {
        XYPlot xYPlot = (XYPlot)this.chart.getPlot();
        if (xYPlot != null) {
            ValueAxis valueAxis = xYPlot.getDomainAxis();
            double d2 = valueAxis.getUpperMargin();
            valueAxis.setUpperMargin(d);
            this.firePropertyChange("xAxisUpperMargin", d2, d);
        }
    }

    public boolean isXAxisGridlinesVisible() {
        XYPlot xYPlot = (XYPlot)this.chart.getPlot();
        if (xYPlot != null) {
            return xYPlot.isDomainGridlinesVisible();
        }
        return false;
    }

    public void setXAxisGridlinesVisible(boolean bl) {
        XYPlot xYPlot = (XYPlot)this.chart.getPlot();
        if (xYPlot != null) {
            boolean bl2 = xYPlot.isDomainGridlinesVisible();
            xYPlot.setDomainGridlinesVisible(bl);
            this.firePropertyChange("xAxisGridlinesVisible", bl2, bl);
        }
    }

    public Font getXAxisTickLabelFont() {
        Font font = null;
        XYPlot xYPlot = (XYPlot)this.chart.getPlot();
        if (xYPlot != null) {
            font = xYPlot.getDomainAxis().getTickLabelFont();
        }
        return font;
    }

    public void setXAxisTickLabelFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("Null 'font' argument.");
        }
        XYPlot xYPlot = (XYPlot)this.chart.getPlot();
        if (xYPlot != null) {
            ValueAxis valueAxis = xYPlot.getDomainAxis();
            Font font2 = valueAxis.getTickLabelFont();
            valueAxis.setTickLabelFont(font);
            this.firePropertyChange("xAxisTickLabelFont", font2, font);
        }
    }

    public Paint getXAxisTickLabelPaint() {
        Paint paint = null;
        XYPlot xYPlot = (XYPlot)this.chart.getPlot();
        if (xYPlot != null) {
            paint = xYPlot.getDomainAxis().getTickLabelPaint();
        }
        return paint;
    }

    public void setXAxisTickLabelPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        XYPlot xYPlot = (XYPlot)this.chart.getPlot();
        if (xYPlot != null) {
            ValueAxis valueAxis = xYPlot.getDomainAxis();
            Paint paint2 = valueAxis.getTickLabelPaint();
            valueAxis.setTickLabelPaint(paint);
            this.firePropertyChange("xAxisTickLabelPaint", paint2, paint);
        }
    }

    public String getYAxisLabel() {
        String string = null;
        XYPlot xYPlot = (XYPlot)this.chart.getPlot();
        if (xYPlot != null) {
            string = xYPlot.getRangeAxis().getLabel();
        }
        return string;
    }

    public void setYAxisLabel(String string) {
        XYPlot xYPlot = (XYPlot)this.chart.getPlot();
        if (xYPlot != null) {
            ValueAxis valueAxis = xYPlot.getRangeAxis();
            String string2 = valueAxis.getLabel();
            valueAxis.setLabel(string);
            this.firePropertyChange("yAxisLabel", string2, string);
        }
    }

    public Font getYAxisLabelFont() {
        Font font = null;
        XYPlot xYPlot = (XYPlot)this.chart.getPlot();
        if (xYPlot != null) {
            font = xYPlot.getRangeAxis().getLabelFont();
        }
        return font;
    }

    public void setYAxisLabelFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("Null 'font' argument.");
        }
        XYPlot xYPlot = (XYPlot)this.chart.getPlot();
        if (xYPlot != null) {
            ValueAxis valueAxis = xYPlot.getRangeAxis();
            Font font2 = valueAxis.getLabelFont();
            valueAxis.setLabelFont(font);
            this.firePropertyChange("yAxisLabelFont", font2, font);
        }
    }

    public Paint getYAxisLabelPaint() {
        Paint paint = null;
        XYPlot xYPlot = (XYPlot)this.chart.getPlot();
        if (xYPlot != null) {
            paint = xYPlot.getRangeAxis().getLabelPaint();
        }
        return paint;
    }

    public void setYAxisLabelPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        XYPlot xYPlot = (XYPlot)this.chart.getPlot();
        if (xYPlot != null) {
            ValueAxis valueAxis = xYPlot.getRangeAxis();
            Paint paint2 = valueAxis.getLabelPaint();
            valueAxis.setLabelPaint(paint);
            this.firePropertyChange("yAxisLabelPaint", paint2, paint);
        }
    }

    public AxisScale getYAxisScale() {
        return this.yAxisScale;
    }

    public void setYAxisScale(AxisScale axisScale) {
        XYPlot xYPlot = (XYPlot)this.chart.getPlot();
        if (xYPlot != null) {
            AxisScale axisScale2 = this.yAxisScale;
            ValueAxis valueAxis = xYPlot.getRangeAxis();
            if (AxisScale.INTEGER.equals(axisScale)) {
                valueAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
            } else if (AxisScale.FLOAT.equals(axisScale)) {
                valueAxis.setStandardTickUnits(NumberAxis.createStandardTickUnits());
            }
            this.firePropertyChange("yAxisScale", axisScale2, axisScale);
        }
    }

    public boolean isYAxisInverted() {
        XYPlot xYPlot = (XYPlot)this.chart.getPlot();
        if (xYPlot != null) {
            return xYPlot.getRangeAxis().isInverted();
        }
        return false;
    }

    public void setYAxisInverted(boolean bl) {
        XYPlot xYPlot = (XYPlot)this.chart.getPlot();
        if (xYPlot != null) {
            ValueAxis valueAxis = xYPlot.getRangeAxis();
            boolean bl2 = valueAxis.isInverted();
            valueAxis.setInverted(bl);
            this.firePropertyChange("yAxisInverted", bl2, bl);
        }
    }

    public boolean getYAxisAutoRangeIncludesZero() {
        XYPlot xYPlot = (XYPlot)this.chart.getPlot();
        if (xYPlot == null) {
            return false;
        }
        NumberAxis numberAxis = (NumberAxis)xYPlot.getRangeAxis();
        return numberAxis.getAutoRangeIncludesZero();
    }

    public void setYAxisAutoRangeIncludesZero(boolean bl) {
        XYPlot xYPlot = (XYPlot)this.chart.getPlot();
        if (xYPlot == null) {
            return;
        }
        NumberAxis numberAxis = (NumberAxis)xYPlot.getRangeAxis();
        boolean bl2 = numberAxis.getAutoRangeIncludesZero();
        numberAxis.setAutoRangeIncludesZero(bl);
        this.firePropertyChange("yAxisAutoRangeIncludesZero", bl2, bl);
    }

    public double getYAxisLowerMargin() {
        XYPlot xYPlot = (XYPlot)this.chart.getPlot();
        if (xYPlot != null) {
            return xYPlot.getRangeAxis().getLowerMargin();
        }
        return -1.0;
    }

    public void setYAxisLowerMargin(double d) {
        XYPlot xYPlot = (XYPlot)this.chart.getPlot();
        if (xYPlot != null) {
            ValueAxis valueAxis = xYPlot.getRangeAxis();
            double d2 = valueAxis.getLowerMargin();
            valueAxis.setLowerMargin(d);
            this.firePropertyChange("yAxisLowerMargin", d2, d);
        }
    }

    public double getYAxisUpperMargin() {
        XYPlot xYPlot = (XYPlot)this.chart.getPlot();
        if (xYPlot != null) {
            return xYPlot.getRangeAxis().getUpperMargin();
        }
        return -1.0;
    }

    public void setYAxisUpperMargin(double d) {
        XYPlot xYPlot = (XYPlot)this.chart.getPlot();
        if (xYPlot != null) {
            ValueAxis valueAxis = xYPlot.getRangeAxis();
            double d2 = valueAxis.getUpperMargin();
            valueAxis.setUpperMargin(d);
            this.firePropertyChange("yAxisUpperMargin", d2, d);
        }
    }

    public boolean isYAxisGridlinesVisible() {
        XYPlot xYPlot = (XYPlot)this.chart.getPlot();
        if (xYPlot != null) {
            return xYPlot.isRangeGridlinesVisible();
        }
        return false;
    }

    public void setYAxisGridlinesVisible(boolean bl) {
        XYPlot xYPlot = (XYPlot)this.chart.getPlot();
        if (xYPlot != null) {
            boolean bl2 = xYPlot.isRangeGridlinesVisible();
            xYPlot.setRangeGridlinesVisible(bl);
            this.firePropertyChange("yAxisGridlinesVisible", bl2, bl);
        }
    }

    public Paint getXAxisGridlinePaint() {
        XYPlot xYPlot = (XYPlot)this.chart.getPlot();
        if (xYPlot != null) {
            return xYPlot.getDomainGridlinePaint();
        }
        return null;
    }

    public void setXAxisGridlinePaint(Paint paint) {
        XYPlot xYPlot = (XYPlot)this.chart.getPlot();
        if (xYPlot != null) {
            Paint paint2 = xYPlot.getDomainGridlinePaint();
            xYPlot.setDomainGridlinePaint(paint);
            this.firePropertyChange("xAxisGridlinePaint", paint2, paint);
        }
    }

    public Paint getYAxisGridlinePaint() {
        XYPlot xYPlot = (XYPlot)this.chart.getPlot();
        if (xYPlot != null) {
            return xYPlot.getRangeGridlinePaint();
        }
        return null;
    }

    public void setYAxisGridlinePaint(Paint paint) {
        XYPlot xYPlot = (XYPlot)this.chart.getPlot();
        if (xYPlot != null) {
            Paint paint2 = xYPlot.getRangeGridlinePaint();
            xYPlot.setRangeGridlinePaint(paint);
            this.firePropertyChange("yAxisGridlinePaint", paint2, paint);
        }
    }

    public Font getYAxisTickLabelFont() {
        Font font = null;
        XYPlot xYPlot = (XYPlot)this.chart.getPlot();
        if (xYPlot != null) {
            font = xYPlot.getRangeAxis().getTickLabelFont();
        }
        return font;
    }

    public void setYAxisTickLabelFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("Null 'font' argument.");
        }
        XYPlot xYPlot = (XYPlot)this.chart.getPlot();
        if (xYPlot != null) {
            ValueAxis valueAxis = xYPlot.getRangeAxis();
            Font font2 = valueAxis.getTickLabelFont();
            valueAxis.setTickLabelFont(font);
            this.firePropertyChange("yAxisTickLabelFont", font2, font);
        }
    }

    public Paint getYAxisTickLabelPaint() {
        Paint paint = null;
        XYPlot xYPlot = (XYPlot)this.chart.getPlot();
        if (xYPlot != null) {
            paint = xYPlot.getRangeAxis().getTickLabelPaint();
        }
        return paint;
    }

    public void setYAxisTickLabelPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        XYPlot xYPlot = (XYPlot)this.chart.getPlot();
        if (xYPlot != null) {
            ValueAxis valueAxis = xYPlot.getRangeAxis();
            Paint paint2 = valueAxis.getTickLabelPaint();
            valueAxis.setTickLabelPaint(paint);
            this.firePropertyChange("yAxisTickLabelPaint", paint2, paint);
        }
    }

    public AxisLocation getXAxisLocation() {
        XYPlot xYPlot = (XYPlot)this.chart.getPlot();
        if (xYPlot != null) {
            return xYPlot.getDomainAxisLocation();
        }
        return null;
    }

    public void setXAxisLocation(AxisLocation axisLocation) {
        if (axisLocation == null) {
            throw new IllegalArgumentException("Null 'location' argument.");
        }
        XYPlot xYPlot = (XYPlot)this.chart.getPlot();
        if (xYPlot != null) {
            AxisLocation axisLocation2 = xYPlot.getDomainAxisLocation();
            xYPlot.setDomainAxisLocation(axisLocation);
            this.firePropertyChange("xAxisLocation", axisLocation2, axisLocation);
        }
    }

    public AxisLocation getYAxisLocation() {
        XYPlot xYPlot = (XYPlot)this.chart.getPlot();
        if (xYPlot != null) {
            return xYPlot.getRangeAxisLocation();
        }
        return null;
    }

    public void setYAxisLocation(AxisLocation axisLocation) {
        if (axisLocation == null) {
            throw new IllegalArgumentException("Null 'location' argument.");
        }
        XYPlot xYPlot = (XYPlot)this.chart.getPlot();
        if (xYPlot != null) {
            AxisLocation axisLocation2 = xYPlot.getRangeAxisLocation();
            xYPlot.setRangeAxisLocation(axisLocation);
            this.firePropertyChange("yAxisLocation", axisLocation2, axisLocation);
        }
    }

    public String getToolTipFormat() {
        XYPlot xYPlot = (XYPlot)this.chart.getPlot();
        if (xYPlot == null) {
            return "";
        }
        XYItemRenderer xYItemRenderer = xYPlot.getRenderer();
        if (xYItemRenderer == null) {
            return "";
        }
        StandardXYToolTipGenerator standardXYToolTipGenerator = (StandardXYToolTipGenerator)xYItemRenderer.getBaseToolTipGenerator();
        if (standardXYToolTipGenerator == null) {
            return "";
        }
        return standardXYToolTipGenerator.getFormatString();
    }

    public void setToolTipFormat(String string) {
        XYPlot xYPlot = (XYPlot)this.chart.getPlot();
        if (xYPlot == null) {
            return;
        }
        XYItemRenderer xYItemRenderer = xYPlot.getRenderer();
        if (xYItemRenderer == null) {
            return;
        }
        if (string.equals("")) {
            xYItemRenderer.setBaseToolTipGenerator(null);
        } else {
            xYItemRenderer.setBaseToolTipGenerator(new StandardXYToolTipGenerator(string, NumberFormat.getInstance(), NumberFormat.getInstance()));
        }
        this.firePropertyChange("toolTipFormat", null, string);
    }

    public boolean isXAxisPositiveArrowVisible() {
        XYPlot xYPlot = (XYPlot)this.chart.getPlot();
        if (xYPlot != null) {
            return xYPlot.getDomainAxis().isPositiveArrowVisible();
        }
        return false;
    }

    public void setXAxisPositiveArrowVisible(boolean bl) {
        XYPlot xYPlot = (XYPlot)this.chart.getPlot();
        if (xYPlot != null) {
            ValueAxis valueAxis = xYPlot.getDomainAxis();
            boolean bl2 = valueAxis.isPositiveArrowVisible();
            valueAxis.setPositiveArrowVisible(bl);
            this.firePropertyChange("xAxisPositiveArrowVisible", bl2, bl);
        }
    }

    public boolean isXAxisNegativeArrowVisible() {
        XYPlot xYPlot = (XYPlot)this.chart.getPlot();
        if (xYPlot != null) {
            return xYPlot.getDomainAxis().isNegativeArrowVisible();
        }
        return false;
    }

    public void setXAxisNegativeArrowVisible(boolean bl) {
        XYPlot xYPlot = (XYPlot)this.chart.getPlot();
        if (xYPlot != null) {
            ValueAxis valueAxis = xYPlot.getDomainAxis();
            boolean bl2 = valueAxis.isNegativeArrowVisible();
            valueAxis.setNegativeArrowVisible(bl);
            this.firePropertyChange("xAxisNegativeArrowVisible", bl2, bl);
        }
    }

    public boolean isYAxisPositiveArrowVisible() {
        XYPlot xYPlot = (XYPlot)this.chart.getPlot();
        if (xYPlot != null) {
            return xYPlot.getRangeAxis().isPositiveArrowVisible();
        }
        return false;
    }

    public void setYAxisPositiveArrowVisible(boolean bl) {
        XYPlot xYPlot = (XYPlot)this.chart.getPlot();
        if (xYPlot != null) {
            ValueAxis valueAxis = xYPlot.getRangeAxis();
            boolean bl2 = valueAxis.isPositiveArrowVisible();
            valueAxis.setPositiveArrowVisible(bl);
            this.firePropertyChange("yAxisPositiveArrowVisible", bl2, bl);
        }
    }

    public boolean isYAxisNegativeArrowVisible() {
        XYPlot xYPlot = (XYPlot)this.chart.getPlot();
        if (xYPlot != null) {
            return xYPlot.getRangeAxis().isNegativeArrowVisible();
        }
        return false;
    }

    public void setYAxisNegativeArrowVisible(boolean bl) {
        XYPlot xYPlot = (XYPlot)this.chart.getPlot();
        if (xYPlot != null) {
            ValueAxis valueAxis = xYPlot.getRangeAxis();
            boolean bl2 = valueAxis.isNegativeArrowVisible();
            valueAxis.setNegativeArrowVisible(bl);
            this.firePropertyChange("yAxisNegativeArrowVisible", bl2, bl);
        }
    }

    public void addXYItemClickListener(XYItemClickListener xYItemClickListener) {
        if (xYItemClickListener == null) {
            throw new IllegalArgumentException("Null 'listener' argument.");
        }
        this.listeners.add(XYItemClickListener.class, xYItemClickListener);
    }

    public void removeXYItemClickListener(XYItemClickListener xYItemClickListener) {
        if (xYItemClickListener == null) {
            throw new IllegalArgumentException("Null 'listener' argument.");
        }
        this.listeners.remove(XYItemClickListener.class, xYItemClickListener);
    }

    public void fireXYItemClickEvent(XYItemClickEvent xYItemClickEvent) {
        EventListener[] eventListenerArray = this.listeners.getListeners(XYItemClickListener.class);
        for (int i = eventListenerArray.length - 1; i >= 0; --i) {
            ((XYItemClickListener)eventListenerArray[i]).onXYItemClick(xYItemClickEvent);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        Object object;
        EventListener[] eventListenerArray = this.listeners.getListeners(XYItemClickListener.class);
        if (eventListenerArray.length == 0) {
            super.mouseClicked(mouseEvent);
        }
        Insets insets = this.getInsets();
        int n = mouseEvent.getX() - insets.left;
        int n2 = mouseEvent.getY() - insets.top;
        ChartEntity chartEntity = null;
        if (this.info != null && (object = this.info.getEntityCollection()) != null) {
            chartEntity = object.getEntity(n, n2);
        }
        if (chartEntity instanceof XYItemEntity) {
            object = (XYItemEntity)chartEntity;
            XYItemClickEvent xYItemClickEvent = new XYItemClickEvent(this, ((XYItemEntity)object).getDataset(), ((XYItemEntity)object).getSeriesIndex(), ((XYItemEntity)object).getItem());
            this.fireXYItemClickEvent(xYItemClickEvent);
        } else {
            super.mouseClicked(mouseEvent);
        }
    }

    static {
        PropertyEditorManager.registerEditor(AxisScale.class, AxisScaleEditor.class);
    }
}

