/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.beans;

import ai.org.jfree.beans.LegendPosition;
import ai.org.jfree.beans.editors.AxisLocationEditor;
import ai.org.jfree.beans.editors.LegendPositionEditor;
import ai.org.jfree.beans.editors.PaintEditor;
import ai.org.jfree.beans.editors.PlotOrientationEditor;
import ai.org.jfree.beans.editors.RectangleEdgeEditor;
import ai.org.jfree.beans.editors.StrokeEditor;
import ai.org.jfree.beans.events.LegendClickEvent;
import ai.org.jfree.beans.events.LegendClickListener;
import ai.org.jfree.chart.ChartRenderingInfo;
import ai.org.jfree.chart.ChartUtilities;
import ai.org.jfree.chart.JFreeChart;
import ai.org.jfree.chart.axis.AxisLocation;
import ai.org.jfree.chart.entity.ChartEntity;
import ai.org.jfree.chart.entity.EntityCollection;
import ai.org.jfree.chart.entity.LegendItemEntity;
import ai.org.jfree.chart.event.ChartChangeEvent;
import ai.org.jfree.chart.event.ChartChangeListener;
import ai.org.jfree.chart.plot.Plot;
import ai.org.jfree.chart.plot.PlotOrientation;
import ai.org.jfree.chart.plot.PlotRenderingInfo;
import ai.org.jfree.chart.plot.Zoomable;
import ai.org.jfree.chart.title.LegendTitle;
import ai.org.jfree.chart.title.TextTitle;
import ai.org.jfree.ui.ExtensionFileFilter;
import ai.org.jfree.ui.HorizontalAlignment;
import ai.org.jfree.ui.RectangleEdge;
import ai.org.jfree.ui.RectangleInsets;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.beans.PropertyEditorManager;
import java.io.File;
import java.io.IOException;
import java.util.EventListener;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.ToolTipManager;
import javax.swing.event.EventListenerList;

public abstract class AbstractChart
extends JComponent
implements ChartChangeListener,
ActionListener,
MouseListener,
MouseMotionListener {
    protected JFreeChart chart;
    protected LegendTitle legend;
    protected LegendPosition legendPosition;
    protected TextTitle subtitle;
    protected TextTitle sourceSubtitle;
    protected ChartRenderingInfo info = new ChartRenderingInfo();
    protected EventListenerList listeners;
    protected Image chartBuffer;
    protected int chartBufferHeight;
    protected int chartBufferWidth;
    private boolean refreshBuffer;
    protected double scaleX;
    protected double scaleY;
    private Point2D anchor;
    private transient Rectangle2D zoomRectangle = null;
    private Point zoomPoint = null;
    private int zoomTriggerDistance;
    private boolean fillZoomRectangle = false;
    private static final int MIN_DRAW_WIDTH = 200;
    private static final int MIN_DRAW_HEIGHT = 150;

    public AbstractChart() {
        this.chart = this.createDefaultChart();
        this.chart.addChangeListener(this);
        this.chart.getTitle().setFont(new Font("Dialog", 1, 14));
        this.chart.setBackgroundPaint(Color.white);
        this.legend = this.chart.getLegend();
        this.legend.setItemFont(new Font("Dialog", 0, 10));
        this.legendPosition = LegendPosition.BOTTOM;
        this.subtitle = new TextTitle("Chart Subtitle", new Font("Dialog", 2, 10));
        this.chart.addSubtitle(0, this.subtitle);
        this.sourceSubtitle = new TextTitle("http://www.jfree.org/jfreechart", new Font("Dialog", 0, 8));
        this.sourceSubtitle.setPosition(RectangleEdge.BOTTOM);
        this.sourceSubtitle.setHorizontalAlignment(HorizontalAlignment.RIGHT);
        this.chart.addSubtitle(0, this.sourceSubtitle);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setToolTipsEnabled(true);
        this.setPreferredSize(new Dimension(360, 230));
        this.listeners = new EventListenerList();
    }

    protected abstract JFreeChart createDefaultChart();

    public boolean getAntiAlias() {
        return this.chart.getAntiAlias();
    }

    public void setAntiAlias(boolean bl) {
        boolean bl2 = this.chart.getAntiAlias();
        this.chart.setAntiAlias(bl);
        this.firePropertyChange("antiAlias", bl2, bl);
    }

    public boolean isChartBorderVisible() {
        return this.chart.isBorderVisible();
    }

    public void setChartBorderVisible(boolean bl) {
        boolean bl2 = this.chart.isBorderVisible();
        this.chart.setBorderVisible(bl);
        this.firePropertyChange("chartBorderVisible", bl2, bl);
    }

    public Stroke getChartBorderStroke() {
        return this.chart.getBorderStroke();
    }

    public void setChartBorderStroke(Stroke stroke) {
        Stroke stroke2 = this.chart.getBorderStroke();
        this.chart.setBorderStroke(stroke);
        this.firePropertyChange("chartBorderStroke", stroke2, stroke);
    }

    public Paint getChartBorderPaint() {
        return this.chart.getBorderPaint();
    }

    public void setChartBorderPaint(Paint paint) {
        Paint paint2 = this.getChartBorderPaint();
        this.chart.setBorderPaint(paint);
        this.firePropertyChange("chartBorderPaint", paint2, paint);
    }

    public Paint getChartBackgroundPaint() {
        return this.chart.getBackgroundPaint();
    }

    public void setChartBackgroundPaint(Paint paint) {
        Paint paint2 = this.chart.getBackgroundPaint();
        this.chart.setBackgroundPaint(paint);
        this.firePropertyChange("chartBackgroundPaint", paint2, paint);
    }

    public Image getChartBackgroundImage() {
        return this.chart.getBackgroundImage();
    }

    public void setChartBackgroundImage(Image image) {
        Image image2 = this.chart.getBackgroundImage();
        this.chart.setBackgroundImage(image);
        this.firePropertyChange("chartBackgroundImage", image2, image);
    }

    public float getChartBackgroundImageAlpha() {
        return this.chart.getBackgroundImageAlpha();
    }

    public void setChartBackgroundImageAlpha(float f) {
        float f2 = this.chart.getBackgroundImageAlpha();
        this.chart.setBackgroundImageAlpha(f);
        this.firePropertyChange("chartBackgroundImageAlpha", f2, f);
    }

    public RectangleInsets getChartPadding() {
        return this.chart.getPadding();
    }

    public void setChartPadding(RectangleInsets rectangleInsets) {
        this.chart.setPadding(rectangleInsets);
    }

    public String getTitle() {
        String string = null;
        TextTitle textTitle = this.chart.getTitle();
        if (textTitle != null) {
            string = textTitle.getText();
        }
        return string;
    }

    public void setTitle(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Null 'title' argument.");
        }
        TextTitle textTitle = this.chart.getTitle();
        if (textTitle != null) {
            String string2 = this.getTitle();
            textTitle.setText(string);
            this.firePropertyChange("title", string2, string);
        }
    }

    public Font getTitleFont() {
        Font font = null;
        TextTitle textTitle = this.chart.getTitle();
        if (textTitle != null) {
            font = textTitle.getFont();
        }
        return font;
    }

    public void setTitleFont(Font font) {
        TextTitle textTitle = this.chart.getTitle();
        if (textTitle != null) {
            Font font2 = textTitle.getFont();
            textTitle.setFont(font);
            this.firePropertyChange("titleFont", font2, font);
        }
    }

    public Paint getTitlePaint() {
        Paint paint = null;
        TextTitle textTitle = this.chart.getTitle();
        if (textTitle != null) {
            paint = textTitle.getPaint();
        }
        return paint;
    }

    public void setTitlePaint(Paint paint) {
        TextTitle textTitle = this.chart.getTitle();
        if (textTitle != null) {
            Paint paint2 = textTitle.getPaint();
            textTitle.setPaint(paint);
            this.firePropertyChange("titlePaint", paint2, paint);
        }
    }

    public String getSubtitle() {
        return this.subtitle.getText();
    }

    public void setSubtitle(String string) {
        String string2 = this.subtitle.getText();
        this.subtitle.setText(string);
        this.firePropertyChange("subtitle", string2, string);
    }

    public Font getSubtitleFont() {
        return this.subtitle.getFont();
    }

    public void setSubtitleFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("Null 'font' argument.");
        }
        Font font2 = this.subtitle.getFont();
        this.subtitle.setFont(font);
        this.firePropertyChange("subtitleFont", font2, font);
    }

    public Paint getSubtitlePaint() {
        return this.subtitle.getPaint();
    }

    public void setSubtitlePaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument");
        }
        Paint paint2 = this.subtitle.getPaint();
        this.subtitle.setPaint(paint);
        this.firePropertyChange("subtitlePaint", paint2, paint);
    }

    public String getSource() {
        return this.sourceSubtitle.getText();
    }

    public void setSource(String string) {
        String string2 = this.sourceSubtitle.getText();
        this.sourceSubtitle.setText(string);
        this.firePropertyChange("source", string2, string);
    }

    public Font getSourceFont() {
        return this.sourceSubtitle.getFont();
    }

    public void setSourceFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("Null 'font' argument.");
        }
        Font font2 = this.sourceSubtitle.getFont();
        this.sourceSubtitle.setFont(font);
        this.firePropertyChange("sourceFont", font2, font);
    }

    public Paint getSourcePaint() {
        return this.sourceSubtitle.getPaint();
    }

    public void setSourcePaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument");
        }
        Paint paint2 = this.sourceSubtitle.getPaint();
        this.sourceSubtitle.setPaint(paint);
        this.firePropertyChange("sourcePaint", paint2, paint);
    }

    public boolean isPlotOutlineVisible() {
        Plot plot = this.chart.getPlot();
        if (plot != null) {
            return plot.isOutlineVisible();
        }
        return false;
    }

    public void setPlotOutlineVisible(boolean bl) {
        Plot plot = this.chart.getPlot();
        if (plot != null) {
            boolean bl2 = plot.isOutlineVisible();
            plot.setOutlineVisible(bl);
            this.firePropertyChange("plotOutlineVisible", bl2, bl);
        }
    }

    public float getPlotBackgroundAlpha() {
        float f = 1.0f;
        Plot plot = this.chart.getPlot();
        if (plot != null) {
            f = plot.getBackgroundAlpha();
        }
        return f;
    }

    public void setPlotBackgroundAlpha(float f) {
        Plot plot = this.chart.getPlot();
        if (plot != null) {
            float f2 = plot.getBackgroundAlpha();
            plot.setBackgroundAlpha(f);
            this.firePropertyChange("plotBackgroundAlpha", f2, f);
        }
    }

    public Paint getPlotBackgroundPaint() {
        Paint paint = null;
        Plot plot = this.chart.getPlot();
        if (plot != null) {
            paint = plot.getBackgroundPaint();
        }
        return paint;
    }

    public void setPlotBackgroundPaint(Paint paint) {
        Plot plot = this.chart.getPlot();
        if (plot != null) {
            Paint paint2 = plot.getBackgroundPaint();
            plot.setBackgroundPaint(paint);
            this.firePropertyChange("plotBackgroundPaint", paint2, paint);
        }
    }

    public LegendPosition getLegendPosition() {
        return this.legendPosition;
    }

    public void setLegendPosition(LegendPosition legendPosition) {
        if (legendPosition == null) {
            throw new IllegalArgumentException("Null 'position' argument.");
        }
        LegendPosition legendPosition2 = this.legendPosition;
        if (legendPosition.equals(LegendPosition.NONE)) {
            if (!legendPosition2.equals(LegendPosition.NONE)) {
                this.chart.removeSubtitle(this.legend);
            }
        } else {
            if (legendPosition2.equals(LegendPosition.NONE)) {
                this.chart.addSubtitle(1, this.legend);
            }
            if (legendPosition.equals(LegendPosition.TOP)) {
                this.legend.setPosition(RectangleEdge.TOP);
            } else if (legendPosition.equals(LegendPosition.BOTTOM)) {
                this.legend.setPosition(RectangleEdge.BOTTOM);
            } else if (legendPosition.equals(LegendPosition.LEFT)) {
                this.legend.setPosition(RectangleEdge.LEFT);
            } else if (legendPosition.equals(LegendPosition.RIGHT)) {
                this.legend.setPosition(RectangleEdge.RIGHT);
            }
        }
        this.legendPosition = legendPosition;
        this.firePropertyChange("legendPosition", legendPosition2, legendPosition);
    }

    public Font getLegendItemFont() {
        return this.legend.getItemFont();
    }

    public void setLegendItemFont(Font font) {
        Font font2 = this.legend.getItemFont();
        this.legend.setItemFont(font);
        this.firePropertyChange("legendItemFont", font2, font);
    }

    public Paint getLegendItemPaint() {
        return this.legend.getItemPaint();
    }

    public void setLegendItemPaint(Paint paint) {
        Paint paint2 = this.legend.getItemPaint();
        this.legend.setItemPaint(paint);
        this.firePropertyChange("legendItemPaint", paint2, paint);
    }

    protected void paintComponent(Graphics graphics) {
        Object object;
        super.paintComponent(graphics);
        if (this.chart == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        Dimension dimension = this.getSize();
        Insets insets = this.getInsets();
        Rectangle2D.Double double_ = new Rectangle2D.Double(insets.left, insets.top, dimension.getWidth() - (double)insets.left - (double)insets.right, dimension.getHeight() - (double)insets.top - (double)insets.bottom);
        boolean bl = false;
        double d = ((RectangularShape)double_).getWidth();
        double d2 = ((RectangularShape)double_).getHeight();
        this.scaleX = 1.0;
        this.scaleY = 1.0;
        if (d < 200.0) {
            this.scaleX = d / 200.0;
            d = 200.0;
            bl = true;
        }
        if (d2 < 150.0) {
            this.scaleY = d2 / 150.0;
            d2 = 150.0;
            bl = true;
        }
        Rectangle2D.Double double_2 = new Rectangle2D.Double(0.0, 0.0, d, d2);
        if (this.chartBuffer == null || (double)this.chartBufferWidth != ((RectangularShape)double_).getWidth() || (double)this.chartBufferHeight != ((RectangularShape)double_).getHeight()) {
            this.chartBufferWidth = (int)((RectangularShape)double_).getWidth();
            this.chartBufferHeight = (int)((RectangularShape)double_).getHeight();
            object = graphics2D.getDeviceConfiguration();
            this.chartBuffer = ((GraphicsConfiguration)object).createCompatibleImage(this.chartBufferWidth, this.chartBufferHeight, 3);
            this.refreshBuffer = true;
        }
        if (this.refreshBuffer) {
            object = new Rectangle2D.Double(0.0, 0.0, this.chartBufferWidth, this.chartBufferHeight);
            Graphics2D graphics2D2 = (Graphics2D)this.chartBuffer.getGraphics();
            if (bl) {
                AffineTransform affineTransform = graphics2D2.getTransform();
                AffineTransform affineTransform2 = AffineTransform.getScaleInstance(this.scaleX, this.scaleY);
                graphics2D2.transform(affineTransform2);
                this.chart.draw(graphics2D2, double_2, this.anchor, this.info);
                graphics2D2.setTransform(affineTransform);
            } else {
                this.chart.draw(graphics2D2, (Rectangle2D)object, this.anchor, this.info);
            }
            this.refreshBuffer = false;
        }
        graphics2D.drawImage(this.chartBuffer, insets.left, insets.top, this);
        graphics2D.dispose();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        Object object;
        EventListener[] eventListenerArray = this.listeners.getListeners(LegendClickListener.class);
        if (eventListenerArray.length == 0) {
            return;
        }
        Insets insets = this.getInsets();
        int n = mouseEvent.getX() - insets.left;
        int n2 = mouseEvent.getY() - insets.top;
        ChartEntity chartEntity = null;
        if (this.info != null && (object = this.info.getEntityCollection()) != null) {
            chartEntity = object.getEntity(n, n2);
        }
        if (chartEntity instanceof LegendItemEntity) {
            object = (LegendItemEntity)chartEntity;
            LegendClickEvent legendClickEvent = new LegendClickEvent(this, ((LegendItemEntity)object).getDataset(), ((LegendItemEntity)object).getSeriesKey());
            this.fireLegendClickEvent(legendClickEvent);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        Object object;
        if (this.zoomRectangle == null) {
            object = this.getScreenDataArea();
            this.zoomPoint = object != null ? this.getPointInRectangle(mouseEvent.getX(), mouseEvent.getY(), (Rectangle2D)object) : null;
        }
        if (mouseEvent.isPopupTrigger()) {
            object = this.createPopup();
            ((JPopupMenu)object).show(this, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.zoomRectangle != null) {
            boolean bl;
            boolean bl2 = false;
            boolean bl3 = false;
            Plot plot = this.chart.getPlot();
            if (plot instanceof Zoomable) {
                Zoomable zoomable = (Zoomable)((Object)plot);
                PlotOrientation plotOrientation = zoomable.getOrientation();
                if (plotOrientation == PlotOrientation.HORIZONTAL) {
                    bl2 = zoomable.isRangeZoomable();
                    bl3 = zoomable.isDomainZoomable();
                } else {
                    bl2 = zoomable.isDomainZoomable();
                    bl3 = zoomable.isRangeZoomable();
                }
            }
            boolean bl4 = bl2 && Math.abs((double)mouseEvent.getX() - this.zoomPoint.getX()) >= (double)this.zoomTriggerDistance;
            boolean bl5 = bl = bl3 && Math.abs((double)mouseEvent.getY() - this.zoomPoint.getY()) >= (double)this.zoomTriggerDistance;
            if (bl4 || bl) {
                if (bl2 && (double)mouseEvent.getX() < this.zoomPoint.getX() || bl3 && (double)mouseEvent.getY() < this.zoomPoint.getY()) {
                    this.restoreAutoBounds();
                } else {
                    double d;
                    double d2;
                    double d3;
                    double d4;
                    Rectangle2D rectangle2D = this.getScreenDataArea();
                    if (!bl3) {
                        d4 = this.zoomPoint.getX();
                        d3 = rectangle2D.getMinY();
                        d2 = Math.min(this.zoomRectangle.getWidth(), rectangle2D.getMaxX() - this.zoomPoint.getX());
                        d = rectangle2D.getHeight();
                    } else if (!bl2) {
                        d4 = rectangle2D.getMinX();
                        d3 = this.zoomPoint.getY();
                        d2 = rectangle2D.getWidth();
                        d = Math.min(this.zoomRectangle.getHeight(), rectangle2D.getMaxY() - this.zoomPoint.getY());
                    } else {
                        d4 = this.zoomPoint.getX();
                        d3 = this.zoomPoint.getY();
                        d2 = Math.min(this.zoomRectangle.getWidth(), rectangle2D.getMaxX() - this.zoomPoint.getX());
                        d = Math.min(this.zoomRectangle.getHeight(), rectangle2D.getMaxY() - this.zoomPoint.getY());
                    }
                    Rectangle2D.Double double_ = new Rectangle2D.Double(d4, d3, d2, d);
                    this.zoom(double_);
                }
                this.zoomPoint = null;
                this.zoomRectangle = null;
            } else {
                Graphics2D graphics2D = (Graphics2D)this.getGraphics();
                this.drawZoomRectangle(graphics2D);
                graphics2D.dispose();
                this.zoomPoint = null;
                this.zoomRectangle = null;
            }
        } else if (mouseEvent.isPopupTrigger()) {
            JPopupMenu jPopupMenu = this.createPopup();
            jPopupMenu.show(this, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        Object object;
        if (this.zoomPoint == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)this.getGraphics();
        this.drawZoomRectangle(graphics2D);
        boolean bl = false;
        boolean bl2 = false;
        Plot plot = this.chart.getPlot();
        if (plot instanceof Zoomable) {
            object = (Zoomable)((Object)plot);
            PlotOrientation plotOrientation = object.getOrientation();
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                bl = object.isRangeZoomable();
                bl2 = object.isDomainZoomable();
            } else {
                bl = object.isDomainZoomable();
                bl2 = object.isRangeZoomable();
            }
        }
        object = this.getScreenDataArea();
        if (bl && bl2) {
            double d = Math.min((double)mouseEvent.getX(), ((RectangularShape)object).getMaxX());
            double d2 = Math.min((double)mouseEvent.getY(), ((RectangularShape)object).getMaxY());
            this.zoomRectangle = new Rectangle2D.Double(this.zoomPoint.getX(), this.zoomPoint.getY(), d - this.zoomPoint.getX(), d2 - this.zoomPoint.getY());
        } else if (bl) {
            double d = Math.min((double)mouseEvent.getX(), ((RectangularShape)object).getMaxX());
            this.zoomRectangle = new Rectangle2D.Double(this.zoomPoint.getX(), ((RectangularShape)object).getMinY(), d - this.zoomPoint.getX(), ((RectangularShape)object).getHeight());
        } else if (bl2) {
            double d = Math.min((double)mouseEvent.getY(), ((RectangularShape)object).getMaxY());
            this.zoomRectangle = new Rectangle2D.Double(((RectangularShape)object).getMinX(), this.zoomPoint.getY(), ((RectangularShape)object).getWidth(), d - this.zoomPoint.getY());
        }
        this.drawZoomRectangle(graphics2D);
        graphics2D.dispose();
    }

    protected JPopupMenu createPopup() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("Save As...");
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("SAVE_AS");
        jPopupMenu.add(jMenuItem);
        return jPopupMenu;
    }

    public Rectangle2D getScreenDataArea() {
        Rectangle2D rectangle2D = this.info.getPlotInfo().getDataArea();
        Insets insets = this.getInsets();
        double d = rectangle2D.getX() * this.scaleX + (double)insets.left;
        double d2 = rectangle2D.getY() * this.scaleY + (double)insets.top;
        double d3 = rectangle2D.getWidth() * this.scaleX;
        double d4 = rectangle2D.getHeight() * this.scaleY;
        return new Rectangle2D.Double(d, d2, d3, d4);
    }

    private Point getPointInRectangle(int n, int n2, Rectangle2D rectangle2D) {
        n = (int)Math.max(Math.ceil(rectangle2D.getMinX()), Math.min((double)n, Math.floor(rectangle2D.getMaxX())));
        n2 = (int)Math.max(Math.ceil(rectangle2D.getMinY()), Math.min((double)n2, Math.floor(rectangle2D.getMaxY())));
        return new Point(n, n2);
    }

    public void restoreAutoBounds() {
        this.restoreAutoDomainBounds();
        this.restoreAutoRangeBounds();
    }

    public void restoreAutoDomainBounds() {
        Plot plot = this.chart.getPlot();
        if (plot instanceof Zoomable) {
            Zoomable zoomable = (Zoomable)((Object)plot);
            Point point = this.zoomPoint != null ? this.zoomPoint : new Point();
            zoomable.zoomDomainAxes(0.0, this.info.getPlotInfo(), point);
        }
    }

    public void restoreAutoRangeBounds() {
        Plot plot = this.chart.getPlot();
        if (plot instanceof Zoomable) {
            Zoomable zoomable = (Zoomable)((Object)plot);
            Point point = this.zoomPoint != null ? this.zoomPoint : new Point();
            zoomable.zoomRangeAxes(0.0, this.info.getPlotInfo(), point);
        }
    }

    public Point translateJava2DToScreen(Point2D point2D) {
        Insets insets = this.getInsets();
        int n = (int)(point2D.getX() * this.scaleX + (double)insets.left);
        int n2 = (int)(point2D.getY() * this.scaleY + (double)insets.top);
        return new Point(n, n2);
    }

    public Point2D translateScreenToJava2D(Point point) {
        Insets insets = this.getInsets();
        double d = (point.getX() - (double)insets.left) / this.scaleX;
        double d2 = (point.getY() - (double)insets.top) / this.scaleY;
        return new Point2D.Double(d, d2);
    }

    public void zoom(Rectangle2D rectangle2D) {
        Point2D point2D = this.translateScreenToJava2D(new Point((int)Math.ceil(rectangle2D.getX()), (int)Math.ceil(rectangle2D.getY())));
        PlotRenderingInfo plotRenderingInfo = this.info.getPlotInfo();
        Rectangle2D rectangle2D2 = this.getScreenDataArea();
        if (rectangle2D.getHeight() > 0.0 && rectangle2D.getWidth() > 0.0) {
            double d = (rectangle2D.getMinX() - rectangle2D2.getMinX()) / rectangle2D2.getWidth();
            double d2 = (rectangle2D.getMaxX() - rectangle2D2.getMinX()) / rectangle2D2.getWidth();
            double d3 = (rectangle2D2.getMaxY() - rectangle2D.getMaxY()) / rectangle2D2.getHeight();
            double d4 = (rectangle2D2.getMaxY() - rectangle2D.getMinY()) / rectangle2D2.getHeight();
            Plot plot = this.chart.getPlot();
            if (plot instanceof Zoomable) {
                Zoomable zoomable = (Zoomable)((Object)plot);
                if (zoomable.getOrientation() == PlotOrientation.HORIZONTAL) {
                    zoomable.zoomDomainAxes(d3, d4, plotRenderingInfo, point2D);
                    zoomable.zoomRangeAxes(d, d2, plotRenderingInfo, point2D);
                } else {
                    zoomable.zoomDomainAxes(d, d2, plotRenderingInfo, point2D);
                    zoomable.zoomRangeAxes(d3, d4, plotRenderingInfo, point2D);
                }
            }
        }
    }

    protected void setToolTipsEnabled(boolean bl) {
        if (bl) {
            ToolTipManager.sharedInstance().registerComponent(this);
        } else {
            ToolTipManager.sharedInstance().unregisterComponent(this);
        }
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        EntityCollection entityCollection;
        String string = null;
        if (this.info != null && (entityCollection = this.info.getEntityCollection()) != null) {
            Insets insets = this.getInsets();
            ChartEntity chartEntity = entityCollection.getEntity(mouseEvent.getX() - insets.left, mouseEvent.getY() - insets.top);
            if (chartEntity != null) {
                string = chartEntity.getToolTipText();
            }
        }
        return string;
    }

    public void addLegendClickListener(LegendClickListener legendClickListener) {
        if (legendClickListener == null) {
            throw new IllegalArgumentException("Null 'listener' argument.");
        }
        this.listeners.add(LegendClickListener.class, legendClickListener);
    }

    public void removeLegendClickListener(LegendClickListener legendClickListener) {
        if (legendClickListener == null) {
            throw new IllegalArgumentException("Null 'listener' argument.");
        }
        this.listeners.remove(LegendClickListener.class, legendClickListener);
    }

    public void fireLegendClickEvent(LegendClickEvent legendClickEvent) {
        EventListener[] eventListenerArray = this.listeners.getListeners(LegendClickListener.class);
        for (int i = eventListenerArray.length - 1; i >= 0; --i) {
            ((LegendClickListener)eventListenerArray[i]).onLegendClick(legendClickEvent);
        }
    }

    private void drawZoomRectangle(Graphics2D graphics2D) {
        graphics2D.setXORMode(Color.gray);
        if (this.zoomRectangle != null) {
            if (this.fillZoomRectangle) {
                graphics2D.fill(this.zoomRectangle);
            } else {
                graphics2D.draw(this.zoomRectangle);
            }
        }
        graphics2D.setPaintMode();
    }

    public void chartChanged(ChartChangeEvent chartChangeEvent) {
        this.refreshBuffer = true;
        this.repaint();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("SAVE_AS")) {
            try {
                this.doSaveAs();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    protected void doSaveAs() throws IOException {
        JFileChooser jFileChooser = new JFileChooser();
        ExtensionFileFilter extensionFileFilter = new ExtensionFileFilter("PNG Files", ".png");
        jFileChooser.addChoosableFileFilter(extensionFileFilter);
        int n = jFileChooser.showSaveDialog(this);
        if (n == 0) {
            String string = jFileChooser.getSelectedFile().getPath();
            ChartUtilities.saveChartAsPNG(new File(string), this.chart, this.getWidth(), this.getHeight());
        }
    }

    static {
        PropertyEditorManager.registerEditor(Paint.class, PaintEditor.class);
        PropertyEditorManager.registerEditor(Stroke.class, StrokeEditor.class);
        PropertyEditorManager.registerEditor(PlotOrientation.class, PlotOrientationEditor.class);
        PropertyEditorManager.registerEditor(RectangleEdge.class, RectangleEdgeEditor.class);
        PropertyEditorManager.registerEditor(AxisLocation.class, AxisLocationEditor.class);
        PropertyEditorManager.registerEditor(LegendPosition.class, LegendPositionEditor.class);
    }
}

