/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.beans;

import ai.org.jfree.beans.AbstractChart;
import ai.org.jfree.beans.events.CategoryItemClickEvent;
import ai.org.jfree.beans.events.CategoryItemClickListener;
import ai.org.jfree.chart.axis.AxisLocation;
import ai.org.jfree.chart.entity.CategoryItemEntity;
import ai.org.jfree.chart.entity.ChartEntity;
import ai.org.jfree.chart.labels.StandardCategoryToolTipGenerator;
import ai.org.jfree.chart.plot.CategoryPlot;
import ai.org.jfree.chart.plot.PlotOrientation;
import ai.org.jfree.chart.renderer.category.CategoryItemRenderer;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.event.MouseEvent;
import java.text.NumberFormat;
import java.util.EventListener;

public abstract class AbstractCategoryChart
extends AbstractChart {
    public PlotOrientation getOrientation() {
        PlotOrientation plotOrientation = null;
        CategoryPlot categoryPlot = (CategoryPlot)this.chart.getPlot();
        if (categoryPlot != null) {
            plotOrientation = categoryPlot.getOrientation();
        }
        return plotOrientation;
    }

    public void setOrientation(PlotOrientation plotOrientation) {
        if (plotOrientation == null) {
            throw new IllegalArgumentException("Null 'orientation' argument.");
        }
        CategoryPlot categoryPlot = (CategoryPlot)this.chart.getPlot();
        if (categoryPlot != null) {
            PlotOrientation plotOrientation2 = categoryPlot.getOrientation();
            categoryPlot.setOrientation(plotOrientation);
            this.firePropertyChange("orientation", plotOrientation2, plotOrientation);
        }
    }

    public String getCategoryAxisLabel() {
        String string = null;
        CategoryPlot categoryPlot = (CategoryPlot)this.chart.getPlot();
        if (categoryPlot != null) {
            string = categoryPlot.getDomainAxis().getLabel();
        }
        return string;
    }

    public void setCategoryAxisLabel(String string) {
        CategoryPlot categoryPlot = (CategoryPlot)this.chart.getPlot();
        if (categoryPlot != null) {
            String string2 = categoryPlot.getDomainAxis().getLabel();
            categoryPlot.getDomainAxis().setLabel(string);
            this.firePropertyChange("categoryAxisLabel", string2, string);
        }
    }

    public Font getCategoryAxisLabelFont() {
        CategoryPlot categoryPlot = (CategoryPlot)this.chart.getPlot();
        if (categoryPlot != null) {
            return categoryPlot.getDomainAxis().getLabelFont();
        }
        return null;
    }

    public void setCategoryAxisLabelFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("Null 'font' argument.");
        }
        CategoryPlot categoryPlot = (CategoryPlot)this.chart.getPlot();
        if (categoryPlot != null) {
            Font font2 = categoryPlot.getDomainAxis().getLabelFont();
            categoryPlot.getDomainAxis().setLabelFont(font);
            this.firePropertyChange("categoryAxisLabelFont", font2, font);
        }
    }

    public Paint getCategoryAxisLabelPaint() {
        CategoryPlot categoryPlot = (CategoryPlot)this.chart.getPlot();
        if (categoryPlot != null) {
            return categoryPlot.getDomainAxis().getLabelPaint();
        }
        return null;
    }

    public void setCategoryAxisLabelPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        CategoryPlot categoryPlot = (CategoryPlot)this.chart.getPlot();
        if (categoryPlot != null) {
            Paint paint2 = categoryPlot.getDomainAxis().getLabelPaint();
            categoryPlot.getDomainAxis().setLabelPaint(paint);
            this.firePropertyChange("categoryAxisLabelPaint", paint2, paint);
        }
    }

    public double getCategoryAxisLowerMargin() {
        CategoryPlot categoryPlot = (CategoryPlot)this.chart.getPlot();
        if (categoryPlot != null) {
            return categoryPlot.getDomainAxis().getLowerMargin();
        }
        return -1.0;
    }

    public void setCategoryAxisLowerMargin(double d) {
        CategoryPlot categoryPlot = (CategoryPlot)this.chart.getPlot();
        if (categoryPlot != null) {
            double d2 = categoryPlot.getDomainAxis().getLowerMargin();
            categoryPlot.getDomainAxis().setLowerMargin(d);
            this.firePropertyChange("categoryAxisLowerMargin", d2, d);
        }
    }

    public double getCategoryAxisUpperMargin() {
        CategoryPlot categoryPlot = (CategoryPlot)this.chart.getPlot();
        if (categoryPlot != null) {
            return categoryPlot.getDomainAxis().getUpperMargin();
        }
        return -1.0;
    }

    public void setCategoryAxisUpperMargin(double d) {
        CategoryPlot categoryPlot = (CategoryPlot)this.chart.getPlot();
        if (categoryPlot != null) {
            double d2 = categoryPlot.getDomainAxis().getUpperMargin();
            categoryPlot.getDomainAxis().setUpperMargin(d);
            this.firePropertyChange("categoryAxisUpperMargin", d2, d);
        }
    }

    public double getCategoryAxisMargin() {
        CategoryPlot categoryPlot = (CategoryPlot)this.chart.getPlot();
        if (categoryPlot != null) {
            return categoryPlot.getDomainAxis().getCategoryMargin();
        }
        return -1.0;
    }

    public void setCategoryAxisMargin(double d) {
        CategoryPlot categoryPlot = (CategoryPlot)this.chart.getPlot();
        if (categoryPlot != null) {
            double d2 = categoryPlot.getDomainAxis().getCategoryMargin();
            categoryPlot.getDomainAxis().setCategoryMargin(d);
            this.firePropertyChange("categoryAxisMargin", d2, d);
        }
    }

    public String getValueAxisLabel() {
        String string = null;
        CategoryPlot categoryPlot = (CategoryPlot)this.chart.getPlot();
        if (categoryPlot != null) {
            string = categoryPlot.getRangeAxis().getLabel();
        }
        return string;
    }

    public void setValueAxisLabel(String string) {
        CategoryPlot categoryPlot = (CategoryPlot)this.chart.getPlot();
        if (categoryPlot != null) {
            String string2 = categoryPlot.getRangeAxis().getLabel();
            categoryPlot.getRangeAxis().setLabel(string);
            this.firePropertyChange("valueAxisLabel", string2, string);
        }
    }

    public boolean isValueAxisInverted() {
        CategoryPlot categoryPlot = (CategoryPlot)this.chart.getPlot();
        if (categoryPlot != null) {
            return categoryPlot.getRangeAxis().isInverted();
        }
        return false;
    }

    public void setValueAxisInverted(boolean bl) {
        CategoryPlot categoryPlot = (CategoryPlot)this.chart.getPlot();
        if (categoryPlot != null) {
            boolean bl2 = categoryPlot.getRangeAxis().isInverted();
            categoryPlot.getRangeAxis().setInverted(bl);
            this.firePropertyChange("valueAxisInverted", bl2, bl);
        }
    }

    public double getValueAxisLowerMargin() {
        CategoryPlot categoryPlot = (CategoryPlot)this.chart.getPlot();
        if (categoryPlot != null) {
            return categoryPlot.getRangeAxis().getLowerMargin();
        }
        return -1.0;
    }

    public void setValueAxisLowerMargin(double d) {
        CategoryPlot categoryPlot = (CategoryPlot)this.chart.getPlot();
        if (categoryPlot != null) {
            double d2 = categoryPlot.getRangeAxis().getLowerMargin();
            categoryPlot.getRangeAxis().setLowerMargin(d);
            this.firePropertyChange("valueAxisLowerMargin", d2, d);
        }
    }

    public double getValueAxisUpperMargin() {
        CategoryPlot categoryPlot = (CategoryPlot)this.chart.getPlot();
        if (categoryPlot != null) {
            return categoryPlot.getRangeAxis().getUpperMargin();
        }
        return -1.0;
    }

    public void setValueAxisUpperMargin(double d) {
        CategoryPlot categoryPlot = (CategoryPlot)this.chart.getPlot();
        if (categoryPlot != null) {
            double d2 = categoryPlot.getRangeAxis().getUpperMargin();
            categoryPlot.getRangeAxis().setUpperMargin(d);
            this.firePropertyChange("valueAxisUpperMargin", d2, d);
        }
    }

    public boolean isValueAxisGridlinesVisible() {
        CategoryPlot categoryPlot = (CategoryPlot)this.chart.getPlot();
        if (categoryPlot != null) {
            return categoryPlot.isRangeGridlinesVisible();
        }
        return false;
    }

    public void setValueAxisGridlinesVisible(boolean bl) {
        CategoryPlot categoryPlot = (CategoryPlot)this.chart.getPlot();
        if (categoryPlot != null) {
            boolean bl2 = categoryPlot.isRangeGridlinesVisible();
            categoryPlot.setRangeGridlinesVisible(bl);
            this.firePropertyChange("valueAxisGridlinesVisible", bl2, bl);
        }
    }

    public boolean isValueAxisLineVisible() {
        CategoryPlot categoryPlot = (CategoryPlot)this.chart.getPlot();
        if (categoryPlot != null) {
            return categoryPlot.getRangeAxis().isAxisLineVisible();
        }
        return false;
    }

    public void setValueAxisLineVisible(boolean bl) {
        CategoryPlot categoryPlot = (CategoryPlot)this.chart.getPlot();
        if (categoryPlot != null) {
            boolean bl2 = categoryPlot.getRangeAxis().isAxisLineVisible();
            categoryPlot.getRangeAxis().setAxisLineVisible(bl);
            this.firePropertyChange("valueAxisLineVisible", bl2, bl);
        }
    }

    public boolean isCategoryAxisLineVisible() {
        CategoryPlot categoryPlot = (CategoryPlot)this.chart.getPlot();
        if (categoryPlot != null) {
            return categoryPlot.getDomainAxis().isAxisLineVisible();
        }
        return false;
    }

    public void setCategoryAxisLineVisible(boolean bl) {
        CategoryPlot categoryPlot = (CategoryPlot)this.chart.getPlot();
        if (categoryPlot != null) {
            boolean bl2 = categoryPlot.getDomainAxis().isAxisLineVisible();
            categoryPlot.getDomainAxis().setAxisLineVisible(bl);
            this.firePropertyChange("categoryAxisLineVisible", bl2, bl);
        }
    }

    public AxisLocation getCategoryAxisLocation() {
        CategoryPlot categoryPlot = (CategoryPlot)this.chart.getPlot();
        if (categoryPlot != null) {
            return categoryPlot.getDomainAxisLocation();
        }
        return null;
    }

    public void setCategoryAxisLocation(AxisLocation axisLocation) {
        if (axisLocation == null) {
            throw new IllegalArgumentException("Null 'location' argument.");
        }
        CategoryPlot categoryPlot = (CategoryPlot)this.chart.getPlot();
        if (categoryPlot != null) {
            AxisLocation axisLocation2 = categoryPlot.getDomainAxisLocation();
            categoryPlot.setDomainAxisLocation(axisLocation);
            this.firePropertyChange("categoryAxisLocation", axisLocation2, axisLocation);
        }
    }

    public AxisLocation getValueAxisLocation() {
        CategoryPlot categoryPlot = (CategoryPlot)this.chart.getPlot();
        if (categoryPlot != null) {
            return categoryPlot.getRangeAxisLocation();
        }
        return null;
    }

    public void setValueAxisLocation(AxisLocation axisLocation) {
        if (axisLocation == null) {
            throw new IllegalArgumentException("Null 'location' argument.");
        }
        CategoryPlot categoryPlot = (CategoryPlot)this.chart.getPlot();
        if (categoryPlot != null) {
            AxisLocation axisLocation2 = categoryPlot.getRangeAxisLocation();
            categoryPlot.setRangeAxisLocation(axisLocation);
            this.firePropertyChange("valueAxisLocation", axisLocation2, axisLocation);
        }
    }

    public String getToolTipFormat() {
        CategoryPlot categoryPlot = (CategoryPlot)this.chart.getPlot();
        if (categoryPlot == null) {
            return "";
        }
        CategoryItemRenderer categoryItemRenderer = categoryPlot.getRenderer();
        if (categoryItemRenderer == null) {
            return "";
        }
        StandardCategoryToolTipGenerator standardCategoryToolTipGenerator = (StandardCategoryToolTipGenerator)categoryItemRenderer.getBaseToolTipGenerator();
        if (standardCategoryToolTipGenerator == null) {
            return "";
        }
        return standardCategoryToolTipGenerator.getLabelFormat();
    }

    public void setToolTipFormat(String string) {
        CategoryPlot categoryPlot = (CategoryPlot)this.chart.getPlot();
        if (categoryPlot == null) {
            return;
        }
        CategoryItemRenderer categoryItemRenderer = categoryPlot.getRenderer();
        if (categoryItemRenderer == null) {
            return;
        }
        if (string.equals("")) {
            categoryItemRenderer.setBaseToolTipGenerator(null);
        } else {
            categoryItemRenderer.setBaseToolTipGenerator(new StandardCategoryToolTipGenerator(string, NumberFormat.getInstance()));
        }
        this.firePropertyChange("toolTipFormat", null, string);
    }

    public void addCategoryItemClickListener(CategoryItemClickListener categoryItemClickListener) {
        if (categoryItemClickListener == null) {
            throw new IllegalArgumentException("Null 'listener' argument.");
        }
        this.listeners.add(CategoryItemClickListener.class, categoryItemClickListener);
    }

    public void removeCategoryItemClickListener(CategoryItemClickListener categoryItemClickListener) {
        if (categoryItemClickListener == null) {
            throw new IllegalArgumentException("Null 'listener' argument.");
        }
        this.listeners.remove(CategoryItemClickListener.class, categoryItemClickListener);
    }

    public void fireCategoryItemClickEvent(CategoryItemClickEvent categoryItemClickEvent) {
        EventListener[] eventListenerArray = this.listeners.getListeners(CategoryItemClickListener.class);
        for (int i = eventListenerArray.length - 1; i >= 0; --i) {
            ((CategoryItemClickListener)eventListenerArray[i]).onCategoryItemClick(categoryItemClickEvent);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        Object object;
        EventListener[] eventListenerArray = this.listeners.getListeners(CategoryItemClickListener.class);
        if (eventListenerArray.length == 0) {
            super.mouseClicked(mouseEvent);
        }
        Insets insets = this.getInsets();
        int n = mouseEvent.getX() - insets.left;
        int n2 = mouseEvent.getY() - insets.top;
        ChartEntity chartEntity = null;
        if (this.info != null && (object = this.info.getEntityCollection()) != null) {
            chartEntity = object.getEntity(n, n2);
        }
        if (chartEntity instanceof CategoryItemEntity) {
            object = (CategoryItemEntity)chartEntity;
            CategoryItemClickEvent categoryItemClickEvent = new CategoryItemClickEvent(this, ((CategoryItemEntity)object).getDataset(), ((CategoryItemEntity)object).getRowKey(), ((CategoryItemEntity)object).getColumnKey());
            this.fireCategoryItemClickEvent(categoryItemClickEvent);
        } else {
            super.mouseClicked(mouseEvent);
        }
    }
}

