/*
 * Decompiled with CFR 0.152.
 */
package ai.org.jfree.base;

import ai.org.jfree.base.BootableProjectInfo;
import ai.org.jfree.base.Library;
import ai.org.jfree.base.config.HierarchicalConfiguration;
import ai.org.jfree.base.config.PropertyFileConfiguration;
import ai.org.jfree.base.config.SystemPropertyConfiguration;
import ai.org.jfree.base.modules.PackageManager;
import ai.org.jfree.base.modules.SubSystem;
import ai.org.jfree.util.Configuration;
import ai.org.jfree.util.ExtendedConfiguration;
import ai.org.jfree.util.ExtendedConfigurationWrapper;
import ai.org.jfree.util.Log;
import ai.org.jfree.util.ObjectUtilities;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;

public abstract class AbstractBoot
implements SubSystem {
    private ExtendedConfigurationWrapper extWrapper;
    private PackageManager packageManager;
    private Configuration globalConfig;
    private boolean bootInProgress;
    private boolean bootDone;

    protected AbstractBoot() {
    }

    public synchronized PackageManager getPackageManager() {
        if (this.packageManager == null) {
            this.packageManager = PackageManager.createInstance(this);
        }
        return this.packageManager;
    }

    public synchronized Configuration getGlobalConfig() {
        if (this.globalConfig == null) {
            this.globalConfig = this.loadConfiguration();
        }
        return this.globalConfig;
    }

    public final synchronized boolean isBootInProgress() {
        return this.bootInProgress;
    }

    public final synchronized boolean isBootDone() {
        return this.bootDone;
    }

    protected abstract Configuration loadConfiguration();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start() {
        Object object;
        Object object2 = this;
        synchronized (object2) {
            if (this.isBootDone()) {
                return;
            }
            while (this.isBootInProgress()) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.isBootDone()) {
                return;
            }
            this.bootInProgress = true;
        }
        object2 = this.getProjectInfo();
        if (object2 != null) {
            object = ((BootableProjectInfo)object2).getDependencies();
            for (int i = 0; i < ((BootableProjectInfo[])object).length; ++i) {
                AbstractBoot abstractBoot = this.loadBooter(object[i].getBootClass());
                if (abstractBoot == null) continue;
                AbstractBoot abstractBoot2 = abstractBoot;
                synchronized (abstractBoot2) {
                    abstractBoot.start();
                    while (!abstractBoot.isBootDone()) {
                        try {
                            abstractBoot.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    continue;
                }
            }
        }
        this.performBoot();
        if (object2 != null) {
            Log.info(((Library)object2).getName() + " " + ((Library)object2).getVersion() + " started.");
        } else {
            Log.info(this.getClass() + " started.");
        }
        object = this;
        synchronized (object) {
            this.bootInProgress = false;
            this.bootDone = true;
            this.notifyAll();
        }
    }

    protected abstract void performBoot();

    protected abstract BootableProjectInfo getProjectInfo();

    protected AbstractBoot loadBooter(String string) {
        if (string == null) {
            return null;
        }
        try {
            Class<?> clazz = ObjectUtilities.getClassLoader(this.getClass()).loadClass(string);
            Method method = clazz.getMethod("getInstance", null);
            return (AbstractBoot)method.invoke(null, (Object[])null);
        }
        catch (Exception exception) {
            Log.info("Unable to boot dependent class: " + string);
            return null;
        }
    }

    protected Configuration createDefaultHierarchicalConfiguration(String string, String string2, boolean bl) {
        return this.createDefaultHierarchicalConfiguration(string, string2, bl, PropertyFileConfiguration.class);
    }

    protected Configuration createDefaultHierarchicalConfiguration(String string, String string2, boolean bl, Class clazz) {
        Object object;
        HierarchicalConfiguration hierarchicalConfiguration = new HierarchicalConfiguration();
        if (string != null) {
            object = new PropertyFileConfiguration();
            ((PropertyFileConfiguration)object).load(string, this.getClass());
            hierarchicalConfiguration.insertConfiguration((HierarchicalConfiguration)object);
            hierarchicalConfiguration.insertConfiguration(this.getPackageManager().getPackageConfiguration());
        }
        if (string2 != null) {
            object = string2.startsWith("/") ? string2.substring(1) : string2;
            try {
                PropertyFileConfiguration propertyFileConfiguration;
                Enumeration<URL> enumeration = ObjectUtilities.getClassLoader(this.getClass()).getResources((String)object);
                ArrayList<PropertyFileConfiguration> arrayList = new ArrayList<PropertyFileConfiguration>();
                while (enumeration.hasMoreElements()) {
                    URL uRL = enumeration.nextElement();
                    try {
                        propertyFileConfiguration = new PropertyFileConfiguration();
                        InputStream inputStream = uRL.openStream();
                        propertyFileConfiguration.load(inputStream);
                        inputStream.close();
                        arrayList.add(propertyFileConfiguration);
                    }
                    catch (IOException iOException) {
                        Log.warn("Failed to load the user configuration at " + uRL, iOException);
                    }
                }
                for (int i = arrayList.size() - 1; i >= 0; --i) {
                    propertyFileConfiguration = (PropertyFileConfiguration)arrayList.get(i);
                    hierarchicalConfiguration.insertConfiguration(propertyFileConfiguration);
                }
            }
            catch (IOException iOException) {
                Log.warn("Failed to lookup the user configurations.", iOException);
            }
        }
        if (bl) {
            object = new SystemPropertyConfiguration();
            hierarchicalConfiguration.insertConfiguration((HierarchicalConfiguration)object);
        }
        return hierarchicalConfiguration;
    }

    public synchronized ExtendedConfiguration getExtendedConfig() {
        if (this.extWrapper == null) {
            this.extWrapper = new ExtendedConfigurationWrapper(this.getGlobalConfig());
        }
        return this.extWrapper;
    }
}

