/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.util;

import ai.org.apache.poi.util.StringUtil;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class POILogger {
    public static final int DEBUG = 1;
    public static final int INFO = 3;
    public static final int WARN = 5;
    public static final int ERROR = 7;
    public static final int FATAL = 9;
    protected static final String[] LEVEL_STRINGS_SHORT = new String[]{"?", "D", "?", "I", "?", "W", "?", "E", "?", "F", "?"};
    protected static final String[] LEVEL_STRINGS = new String[]{"?0?", "DEBUG", "?2?", "INFO", "?4?", "WARN", "?6?", "ERROR", "?8?", "FATAL", "?10+?"};

    POILogger() {
    }

    public abstract void initialize(String var1);

    public abstract void log(int var1, Object var2);

    public abstract void log(int var1, Object var2, Throwable var3);

    public abstract boolean check(int var1);

    public void log(int n, Object object, Object object2) {
        if (this.check(n)) {
            this.log(n, new StringBuffer(32).append(object).append(object2));
        }
    }

    public void log(int n, Object object, Object object2, Object object3) {
        if (this.check(n)) {
            this.log(n, new StringBuffer(48).append(object).append(object2).append(object3));
        }
    }

    public void log(int n, Object object, Object object2, Object object3, Object object4) {
        if (this.check(n)) {
            this.log(n, new StringBuffer(64).append(object).append(object2).append(object3).append(object4));
        }
    }

    public void log(int n, Object object, Object object2, Object object3, Object object4, Object object5) {
        if (this.check(n)) {
            this.log(n, new StringBuffer(80).append(object).append(object2).append(object3).append(object4).append(object5));
        }
    }

    public void log(int n, Object object, Object object2, Object object3, Object object4, Object object5, Object object6) {
        if (this.check(n)) {
            this.log(n, new StringBuffer(96).append(object).append(object2).append(object3).append(object4).append(object5).append(object6));
        }
    }

    public void log(int n, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7) {
        if (this.check(n)) {
            this.log(n, new StringBuffer(112).append(object).append(object2).append(object3).append(object4).append(object5).append(object6).append(object7));
        }
    }

    public void log(int n, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8) {
        if (this.check(n)) {
            this.log(n, new StringBuffer(128).append(object).append(object2).append(object3).append(object4).append(object5).append(object6).append(object7).append(object8));
        }
    }

    public void log(int n, Throwable throwable) {
        this.log(n, null, throwable);
    }

    public void log(int n, Object object, Object object2, Throwable throwable) {
        if (this.check(n)) {
            this.log(n, (Object)new StringBuffer(32).append(object).append(object2), throwable);
        }
    }

    public void log(int n, Object object, Object object2, Object object3, Throwable throwable) {
        if (this.check(n)) {
            this.log(n, (Object)new StringBuffer(48).append(object).append(object2).append(object3), throwable);
        }
    }

    public void log(int n, Object object, Object object2, Object object3, Object object4, Throwable throwable) {
        if (this.check(n)) {
            this.log(n, (Object)new StringBuffer(64).append(object).append(object2).append(object3).append(object4), throwable);
        }
    }

    public void log(int n, Object object, Object object2, Object object3, Object object4, Object object5, Throwable throwable) {
        if (this.check(n)) {
            this.log(n, (Object)new StringBuffer(80).append(object).append(object2).append(object3).append(object4).append(object5), throwable);
        }
    }

    public void log(int n, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Throwable throwable) {
        if (this.check(n)) {
            this.log(n, (Object)new StringBuffer(96).append(object).append(object2).append(object3).append(object4).append(object5).append(object6), throwable);
        }
    }

    public void log(int n, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Throwable throwable) {
        if (this.check(n)) {
            this.log(n, (Object)new StringBuffer(112).append(object).append(object2).append(object3).append(object4).append(object5).append(object6).append(object7), throwable);
        }
    }

    public void log(int n, Object object, Object object2, Object object3, Object object4, Object object5, Object object6, Object object7, Object object8, Throwable throwable) {
        if (this.check(n)) {
            this.log(n, (Object)new StringBuffer(128).append(object).append(object2).append(object3).append(object4).append(object5).append(object6).append(object7).append(object8), throwable);
        }
    }

    public void logFormatted(int n, String string, Object object) {
        this.commonLogFormatted(n, string, new Object[]{object});
    }

    public void logFormatted(int n, String string, Object object, Object object2) {
        this.commonLogFormatted(n, string, new Object[]{object, object2});
    }

    public void logFormatted(int n, String string, Object object, Object object2, Object object3) {
        this.commonLogFormatted(n, string, new Object[]{object, object2, object3});
    }

    public void logFormatted(int n, String string, Object object, Object object2, Object object3, Object object4) {
        this.commonLogFormatted(n, string, new Object[]{object, object2, object3, object4});
    }

    private void commonLogFormatted(int n, String string, Object[] objectArray) {
        if (this.check(n)) {
            Object[] objectArray2 = this.flattenArrays(objectArray);
            if (objectArray2[objectArray2.length - 1] instanceof Throwable) {
                this.log(n, (Object)StringUtil.format(string, objectArray2), (Throwable)objectArray2[objectArray2.length - 1]);
            } else {
                this.log(n, StringUtil.format(string, objectArray2));
            }
        }
    }

    private Object[] flattenArrays(Object[] objectArray) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < objectArray.length; ++i) {
            arrayList.addAll(this.objectToObjectArray(objectArray[i]));
        }
        return arrayList.toArray(new Object[arrayList.size()]);
    }

    private List<Object> objectToObjectArray(Object object) {
        int n;
        Object[] objectArray;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (object instanceof byte[]) {
            objectArray = (byte[])object;
            for (n = 0; n < objectArray.length; ++n) {
                arrayList.add(objectArray[n]);
            }
        }
        if (object instanceof char[]) {
            objectArray = (char[])object;
            for (n = 0; n < objectArray.length; ++n) {
                arrayList.add(Character.valueOf((char)objectArray[n]));
            }
        } else if (object instanceof short[]) {
            objectArray = (short[])object;
            for (n = 0; n < objectArray.length; ++n) {
                arrayList.add(objectArray[n]);
            }
        } else if (object instanceof int[]) {
            objectArray = (int[])object;
            for (n = 0; n < objectArray.length; ++n) {
                arrayList.add(objectArray[n]);
            }
        } else if (object instanceof long[]) {
            objectArray = (long[])object;
            for (n = 0; n < objectArray.length; ++n) {
                arrayList.add(objectArray[n]);
            }
        } else if (object instanceof float[]) {
            objectArray = (float[])object;
            for (n = 0; n < objectArray.length; ++n) {
                arrayList.add(new Float(objectArray[n]));
            }
        } else if (object instanceof double[]) {
            objectArray = (double[])object;
            for (n = 0; n < objectArray.length; ++n) {
                arrayList.add(new Double(objectArray[n]));
            }
        } else if (object instanceof Object[]) {
            objectArray = (Object[])object;
            for (n = 0; n < objectArray.length; ++n) {
                arrayList.add(objectArray[n]);
            }
        } else {
            arrayList.add(object);
        }
        return arrayList;
    }
}

