/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.util;

import ai.org.apache.poi.util.DelayableLittleEndianOutput;
import ai.org.apache.poi.util.LittleEndianOutput;

public final class LittleEndianByteArrayOutputStream
implements LittleEndianOutput,
DelayableLittleEndianOutput {
    private final byte[] _buf;
    private final int _endIndex;
    private int _writeIndex;

    public LittleEndianByteArrayOutputStream(byte[] byArray, int n, int n2) {
        if (n < 0 || n > byArray.length) {
            throw new IllegalArgumentException("Specified startOffset (" + n + ") is out of allowable range (0.." + byArray.length + ")");
        }
        this._buf = byArray;
        this._writeIndex = n;
        this._endIndex = n + n2;
        if (this._endIndex < n || this._endIndex > byArray.length) {
            throw new IllegalArgumentException("calculated end index (" + this._endIndex + ") is out of allowable range (" + this._writeIndex + ".." + byArray.length + ")");
        }
    }

    public LittleEndianByteArrayOutputStream(byte[] byArray, int n) {
        this(byArray, n, byArray.length - n);
    }

    private void checkPosition(int n) {
        if (n > this._endIndex - this._writeIndex) {
            throw new RuntimeException("Buffer overrun");
        }
    }

    public void writeByte(int n) {
        this.checkPosition(1);
        this._buf[this._writeIndex++] = (byte)n;
    }

    public void writeDouble(double d) {
        this.writeLong(Double.doubleToLongBits(d));
    }

    public void writeInt(int n) {
        this.checkPosition(4);
        int n2 = this._writeIndex;
        this._buf[n2++] = (byte)(n >>> 0 & 0xFF);
        this._buf[n2++] = (byte)(n >>> 8 & 0xFF);
        this._buf[n2++] = (byte)(n >>> 16 & 0xFF);
        this._buf[n2++] = (byte)(n >>> 24 & 0xFF);
        this._writeIndex = n2;
    }

    public void writeLong(long l) {
        this.writeInt((int)(l >> 0));
        this.writeInt((int)(l >> 32));
    }

    public void writeShort(int n) {
        this.checkPosition(2);
        int n2 = this._writeIndex;
        this._buf[n2++] = (byte)(n >>> 0 & 0xFF);
        this._buf[n2++] = (byte)(n >>> 8 & 0xFF);
        this._writeIndex = n2;
    }

    public void write(byte[] byArray) {
        int n = byArray.length;
        this.checkPosition(n);
        System.arraycopy(byArray, 0, this._buf, this._writeIndex, n);
        this._writeIndex += n;
    }

    public void write(byte[] byArray, int n, int n2) {
        this.checkPosition(n2);
        System.arraycopy(byArray, n, this._buf, this._writeIndex, n2);
        this._writeIndex += n2;
    }

    public int getWriteIndex() {
        return this._writeIndex;
    }

    public LittleEndianOutput createDelayedOutput(int n) {
        this.checkPosition(n);
        LittleEndianByteArrayOutputStream littleEndianByteArrayOutputStream = new LittleEndianByteArrayOutputStream(this._buf, this._writeIndex, n);
        this._writeIndex += n;
        return littleEndianByteArrayOutputStream;
    }
}

