/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.util;

import ai.org.apache.poi.util.LittleEndianInput;

public final class LittleEndianByteArrayInputStream
implements LittleEndianInput {
    private final byte[] _buf;
    private final int _endIndex;
    private int _readIndex;

    public LittleEndianByteArrayInputStream(byte[] byArray, int n, int n2) {
        this._buf = byArray;
        this._readIndex = n;
        this._endIndex = n + n2;
    }

    public LittleEndianByteArrayInputStream(byte[] byArray, int n) {
        this(byArray, n, byArray.length - n);
    }

    public LittleEndianByteArrayInputStream(byte[] byArray) {
        this(byArray, 0, byArray.length);
    }

    public int available() {
        return this._endIndex - this._readIndex;
    }

    private void checkPosition(int n) {
        if (n > this._endIndex - this._readIndex) {
            throw new RuntimeException("Buffer overrun");
        }
    }

    public int getReadIndex() {
        return this._readIndex;
    }

    public byte readByte() {
        this.checkPosition(1);
        return this._buf[this._readIndex++];
    }

    public int readInt() {
        this.checkPosition(4);
        int n = this._readIndex;
        int n2 = this._buf[n++] & 0xFF;
        int n3 = this._buf[n++] & 0xFF;
        int n4 = this._buf[n++] & 0xFF;
        int n5 = this._buf[n++] & 0xFF;
        this._readIndex = n;
        return (n5 << 24) + (n4 << 16) + (n3 << 8) + (n2 << 0);
    }

    public long readLong() {
        this.checkPosition(8);
        int n = this._readIndex;
        int n2 = this._buf[n++] & 0xFF;
        int n3 = this._buf[n++] & 0xFF;
        int n4 = this._buf[n++] & 0xFF;
        int n5 = this._buf[n++] & 0xFF;
        int n6 = this._buf[n++] & 0xFF;
        int n7 = this._buf[n++] & 0xFF;
        int n8 = this._buf[n++] & 0xFF;
        int n9 = this._buf[n++] & 0xFF;
        this._readIndex = n;
        return ((long)n9 << 56) + ((long)n8 << 48) + ((long)n7 << 40) + ((long)n6 << 32) + ((long)n5 << 24) + (long)(n4 << 16) + (long)(n3 << 8) + (long)(n2 << 0);
    }

    public short readShort() {
        return (short)this.readUShort();
    }

    public int readUByte() {
        this.checkPosition(1);
        return this._buf[this._readIndex++] & 0xFF;
    }

    public int readUShort() {
        this.checkPosition(2);
        int n = this._readIndex;
        int n2 = this._buf[n++] & 0xFF;
        int n3 = this._buf[n++] & 0xFF;
        this._readIndex = n;
        return (n3 << 8) + (n2 << 0);
    }

    public void readFully(byte[] byArray, int n, int n2) {
        this.checkPosition(n2);
        System.arraycopy(this._buf, this._readIndex, byArray, n, n2);
        this._readIndex += n2;
    }

    public void readFully(byte[] byArray) {
        this.readFully(byArray, 0, byArray.length);
    }

    public double readDouble() {
        return Double.longBitsToDouble(this.readLong());
    }
}

