/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.util;

import ai.org.apache.poi.util.FixedField;
import ai.org.apache.poi.util.LittleEndian;
import java.io.IOException;
import java.io.InputStream;

public class IntegerField
implements FixedField {
    private int _value;
    private final int _offset;

    public IntegerField(int n) throws ArrayIndexOutOfBoundsException {
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("negative offset");
        }
        this._offset = n;
    }

    public IntegerField(int n, int n2) throws ArrayIndexOutOfBoundsException {
        this(n);
        this.set(n2);
    }

    public IntegerField(int n, byte[] byArray) throws ArrayIndexOutOfBoundsException {
        this(n);
        this.readFromBytes(byArray);
    }

    public IntegerField(int n, int n2, byte[] byArray) throws ArrayIndexOutOfBoundsException {
        this(n);
        this.set(n2, byArray);
    }

    public int get() {
        return this._value;
    }

    public void set(int n) {
        this._value = n;
    }

    public void set(int n, byte[] byArray) throws ArrayIndexOutOfBoundsException {
        this._value = n;
        this.writeToBytes(byArray);
    }

    public void readFromBytes(byte[] byArray) throws ArrayIndexOutOfBoundsException {
        this._value = LittleEndian.getInt(byArray, this._offset);
    }

    public void readFromStream(InputStream inputStream) throws IOException, LittleEndian.BufferUnderrunException {
        this._value = LittleEndian.readInt(inputStream);
    }

    public void writeToBytes(byte[] byArray) throws ArrayIndexOutOfBoundsException {
        LittleEndian.putInt(byArray, this._offset, this._value);
    }

    public String toString() {
        return String.valueOf(this._value);
    }
}

