/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.util;

public class ArrayUtil {
    public static void arraycopy(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        if (n < 0) {
            throw new IllegalArgumentException("src_position was less than 0.  Actual value " + n);
        }
        if (n >= byArray.length) {
            throw new IllegalArgumentException("src_position was greater than src array size.  Tried to write starting at position " + n + " but the array length is " + byArray.length);
        }
        if (n + n3 > byArray.length) {
            throw new IllegalArgumentException("src_position + length would overrun the src array.  Expected end at " + (n + n3) + " actual end at " + byArray.length);
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("dst_position was less than 0.  Actual value " + n2);
        }
        if (n2 >= byArray2.length) {
            throw new IllegalArgumentException("dst_position was greater than dst array size.  Tried to write starting at position " + n2 + " but the array length is " + byArray2.length);
        }
        if (n2 + n3 > byArray2.length) {
            throw new IllegalArgumentException("dst_position + length would overrun the dst array.  Expected end at " + (n2 + n3) + " actual end at " + byArray2.length);
        }
        System.arraycopy(byArray, n, byArray2, n2, n3);
    }

    public static void arrayMoveWithin(Object[] objectArray, int n, int n2, int n3) {
        int n4;
        Object[] objectArray2;
        if (n3 <= 0) {
            return;
        }
        if (n == n2) {
            return;
        }
        if (n < 0 || n >= objectArray.length) {
            throw new IllegalArgumentException("The moveFrom must be a valid array index");
        }
        if (n2 < 0 || n2 >= objectArray.length) {
            throw new IllegalArgumentException("The moveTo must be a valid array index");
        }
        if (n + n3 > objectArray.length) {
            throw new IllegalArgumentException("Asked to move more entries than the array has");
        }
        if (n2 + n3 > objectArray.length) {
            throw new IllegalArgumentException("Asked to move to a position that doesn't have enough space");
        }
        Object[] objectArray3 = new Object[n3];
        System.arraycopy(objectArray, n, objectArray3, 0, n3);
        if (n > n2) {
            objectArray2 = new Object[n - n2];
            System.arraycopy(objectArray, n2, objectArray2, 0, objectArray2.length);
            n4 = n2 + n3;
        } else {
            objectArray2 = new Object[n2 - n];
            System.arraycopy(objectArray, n + n3, objectArray2, 0, objectArray2.length);
            n4 = n;
        }
        System.arraycopy(objectArray3, 0, objectArray, n2, objectArray3.length);
        System.arraycopy(objectArray2, 0, objectArray, n4, objectArray2.length);
    }
}

