/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.ss.util;

public class WorkbookUtil {
    public static final String createSafeSheetName(String string) {
        return WorkbookUtil.createSafeSheetName(string, ' ');
    }

    public static final String createSafeSheetName(String string, char c) {
        if (string == null) {
            return "null";
        }
        if (string.length() < 1) {
            return "empty";
        }
        int n = Math.min(31, string.length());
        String string2 = string.substring(0, n);
        StringBuilder stringBuilder = new StringBuilder(string2);
        block4: for (int i = 0; i < n; ++i) {
            char c2 = stringBuilder.charAt(i);
            switch (c2) {
                case '\u0000': 
                case '\u0003': 
                case '*': 
                case '/': 
                case ':': 
                case '?': 
                case '[': 
                case '\\': 
                case ']': {
                    stringBuilder.setCharAt(i, c);
                    continue block4;
                }
                case '\'': {
                    if (i != 0 && i != n - 1) continue block4;
                    stringBuilder.setCharAt(i, c);
                    continue block4;
                }
            }
        }
        return stringBuilder.toString();
    }

    public static void validateSheetName(String string) {
        if (string == null) {
            throw new IllegalArgumentException("sheetName must not be null");
        }
        int n = string.length();
        if (n < 1 || n > 31) {
            throw new IllegalArgumentException("sheetName '" + string + "' is invalid - character count MUST be greater than or equal to 1 and less than or equal to 31");
        }
        block3: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '*': 
                case '/': 
                case ':': 
                case '?': 
                case '[': 
                case '\\': 
                case ']': {
                    break;
                }
                default: {
                    continue block3;
                }
            }
            throw new IllegalArgumentException("Invalid char (" + c + ") found at index (" + i + ") in sheet name '" + string + "'");
        }
        if (string.charAt(0) == '\'' || string.charAt(n - 1) == '\'') {
            throw new IllegalArgumentException("Invalid sheet name '" + string + "'. Sheet names must not begin or end with (').");
        }
    }

    public static void validateSheetState(int n) {
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Ivalid sheet state : " + n + "\n" + "Sheet state must beone of the Workbook.SHEET_STATE_* constants");
            }
        }
    }
}

