/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.ss.util;

import ai.org.apache.poi.ss.usermodel.Cell;
import ai.org.apache.poi.ss.usermodel.CellStyle;
import ai.org.apache.poi.ss.usermodel.CellValue;
import ai.org.apache.poi.ss.usermodel.DataFormatter;
import ai.org.apache.poi.ss.usermodel.Font;
import ai.org.apache.poi.ss.usermodel.FormulaEvaluator;
import ai.org.apache.poi.ss.usermodel.RichTextString;
import ai.org.apache.poi.ss.usermodel.Row;
import ai.org.apache.poi.ss.usermodel.Sheet;
import ai.org.apache.poi.ss.usermodel.Workbook;
import ai.org.apache.poi.ss.util.CellRangeAddress;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.text.AttributedString;
import java.util.Map;

public class SheetUtil {
    private static final char defaultChar = '0';
    private static final double fontHeightMultiple = 2.0;
    private static final FormulaEvaluator dummyEvaluator = new FormulaEvaluator(){

        @Override
        public void clearAllCachedResultValues() {
        }

        @Override
        public void notifySetFormula(Cell cell) {
        }

        @Override
        public void notifyDeleteCell(Cell cell) {
        }

        @Override
        public void notifyUpdateCell(Cell cell) {
        }

        @Override
        public CellValue evaluate(Cell cell) {
            return null;
        }

        @Override
        public Cell evaluateInCell(Cell cell) {
            return null;
        }

        @Override
        public void setupReferencedWorkbooks(Map<String, FormulaEvaluator> map) {
        }

        @Override
        public void setDebugEvaluationOutputForNextEval(boolean bl) {
        }

        @Override
        public void setIgnoreMissingWorkbooks(boolean bl) {
        }

        @Override
        public void evaluateAll() {
        }

        @Override
        public int evaluateFormulaCell(Cell cell) {
            return cell.getCachedFormulaResultType();
        }
    };
    private static final FontRenderContext fontRenderContext = new FontRenderContext(null, true, true);

    public static double getCellWidth(Cell cell, int n, DataFormatter dataFormatter, boolean bl) {
        Sheet sheet = cell.getSheet();
        Workbook workbook = sheet.getWorkbook();
        Row row = cell.getRow();
        int n2 = cell.getColumnIndex();
        int n3 = 1;
        for (int i = 0; i < sheet.getNumMergedRegions(); ++i) {
            CellRangeAddress cellRangeAddress = sheet.getMergedRegion(i);
            if (!SheetUtil.containsCell(cellRangeAddress, row.getRowNum(), n2)) continue;
            if (!bl) {
                return -1.0;
            }
            cell = row.getCell(cellRangeAddress.getFirstColumn());
            n3 = 1 + cellRangeAddress.getLastColumn() - cellRangeAddress.getFirstColumn();
        }
        CellStyle cellStyle = cell.getCellStyle();
        int n4 = cell.getCellType();
        if (n4 == 2) {
            n4 = cell.getCachedFormulaResultType();
        }
        Font font = workbook.getFontAt(cellStyle.getFontIndex());
        double d = -1.0;
        if (n4 == 1) {
            RichTextString richTextString = cell.getRichStringCellValue();
            String[] stringArray = richTextString.getString().split("\\n");
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i] + '0';
                AttributedString attributedString = new AttributedString(string);
                SheetUtil.copyAttributes(font, attributedString, 0, string.length());
                if (richTextString.numFormattingRuns() > 0) {
                    // empty if block
                }
                TextLayout textLayout = new TextLayout(attributedString.getIterator(), fontRenderContext);
                if (cellStyle.getRotation() != 0) {
                    AffineTransform affineTransform = new AffineTransform();
                    affineTransform.concatenate(AffineTransform.getRotateInstance((double)cellStyle.getRotation() * 2.0 * Math.PI / 360.0));
                    affineTransform.concatenate(AffineTransform.getScaleInstance(1.0, 2.0));
                    d = Math.max(d, textLayout.getOutline(affineTransform).getBounds().getWidth() / (double)n3 / (double)n + (double)cell.getCellStyle().getIndention());
                    continue;
                }
                d = Math.max(d, textLayout.getBounds().getWidth() / (double)n3 / (double)n + (double)cell.getCellStyle().getIndention());
            }
        } else {
            String string = null;
            if (n4 == 0) {
                try {
                    string = dataFormatter.formatCellValue(cell, dummyEvaluator);
                }
                catch (Exception exception) {
                    string = String.valueOf(cell.getNumericCellValue());
                }
            } else if (n4 == 4) {
                string = String.valueOf(cell.getBooleanCellValue()).toUpperCase();
            }
            if (string != null) {
                String string2 = string + '0';
                AttributedString attributedString = new AttributedString(string2);
                SheetUtil.copyAttributes(font, attributedString, 0, string2.length());
                TextLayout textLayout = new TextLayout(attributedString.getIterator(), fontRenderContext);
                if (cellStyle.getRotation() != 0) {
                    AffineTransform affineTransform = new AffineTransform();
                    affineTransform.concatenate(AffineTransform.getRotateInstance((double)cellStyle.getRotation() * 2.0 * Math.PI / 360.0));
                    affineTransform.concatenate(AffineTransform.getScaleInstance(1.0, 2.0));
                    d = Math.max(d, textLayout.getOutline(affineTransform).getBounds().getWidth() / (double)n3 / (double)n + (double)cell.getCellStyle().getIndention());
                } else {
                    d = Math.max(d, textLayout.getBounds().getWidth() / (double)n3 / (double)n + (double)cell.getCellStyle().getIndention());
                }
            }
        }
        return d;
    }

    public static double getColumnWidth(Sheet sheet, int n, boolean bl) {
        Workbook workbook = sheet.getWorkbook();
        DataFormatter dataFormatter = new DataFormatter();
        Font font = workbook.getFontAt((short)0);
        AttributedString attributedString = new AttributedString(String.valueOf('0'));
        SheetUtil.copyAttributes(font, attributedString, 0, 1);
        TextLayout textLayout = new TextLayout(attributedString.getIterator(), fontRenderContext);
        int n2 = (int)textLayout.getAdvance();
        double d = -1.0;
        for (Row row : sheet) {
            Cell cell = row.getCell(n);
            if (cell == null) continue;
            double d2 = SheetUtil.getCellWidth(cell, n2, dataFormatter, bl);
            d = Math.max(d, d2);
        }
        return d;
    }

    public static double getColumnWidth(Sheet sheet, int n, boolean bl, int n2, int n3) {
        Workbook workbook = sheet.getWorkbook();
        DataFormatter dataFormatter = new DataFormatter();
        Font font = workbook.getFontAt((short)0);
        AttributedString attributedString = new AttributedString(String.valueOf('0'));
        SheetUtil.copyAttributes(font, attributedString, 0, 1);
        TextLayout textLayout = new TextLayout(attributedString.getIterator(), fontRenderContext);
        int n4 = (int)textLayout.getAdvance();
        double d = -1.0;
        for (int i = n2; i <= n3; ++i) {
            Cell cell;
            Row row = sheet.getRow(i);
            if (row == null || (cell = row.getCell(n)) == null) continue;
            double d2 = SheetUtil.getCellWidth(cell, n4, dataFormatter, bl);
            d = Math.max(d, d2);
        }
        return d;
    }

    private static void copyAttributes(Font font, AttributedString attributedString, int n, int n2) {
        attributedString.addAttribute(TextAttribute.FAMILY, font.getFontName(), n, n2);
        attributedString.addAttribute(TextAttribute.SIZE, Float.valueOf(font.getFontHeightInPoints()));
        if (font.getBoldweight() == 700) {
            attributedString.addAttribute(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD, n, n2);
        }
        if (font.getItalic()) {
            attributedString.addAttribute(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE, n, n2);
        }
        if (font.getUnderline() == 1) {
            attributedString.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON, n, n2);
        }
    }

    public static boolean containsCell(CellRangeAddress cellRangeAddress, int n, int n2) {
        return cellRangeAddress.getFirstRow() <= n && cellRangeAddress.getLastRow() >= n && cellRangeAddress.getFirstColumn() <= n2 && cellRangeAddress.getLastColumn() >= n2;
    }

    public static Cell getCellWithMerges(Sheet sheet, int n, int n2) {
        Cell cell;
        Row row = sheet.getRow(n);
        if (row != null && (cell = row.getCell(n2)) != null) {
            return cell;
        }
        for (int i = 0; i < sheet.getNumMergedRegions(); ++i) {
            CellRangeAddress cellRangeAddress = sheet.getMergedRegion(i);
            if (!cellRangeAddress.isInRange(n, n2) || (row = sheet.getRow(cellRangeAddress.getFirstRow())) == null) continue;
            return row.getCell(cellRangeAddress.getFirstColumn());
        }
        return null;
    }
}

