/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.ss.util;

import ai.org.apache.poi.ss.usermodel.Cell;
import ai.org.apache.poi.ss.usermodel.Row;
import ai.org.apache.poi.ss.usermodel.Sheet;
import ai.org.apache.poi.ss.usermodel.Workbook;
import java.util.Calendar;
import java.util.Date;

public class SheetBuilder {
    private final Workbook workbook;
    private final Object[][] cells;
    private boolean shouldCreateEmptyCells = false;
    private String sheetName = null;

    public SheetBuilder(Workbook workbook, Object[][] objectArray) {
        this.workbook = workbook;
        this.cells = objectArray;
    }

    public boolean getCreateEmptyCells() {
        return this.shouldCreateEmptyCells;
    }

    public SheetBuilder setCreateEmptyCells(boolean bl) {
        this.shouldCreateEmptyCells = bl;
        return this;
    }

    public SheetBuilder setSheetName(String string) {
        this.sheetName = string;
        return this;
    }

    public Sheet build() {
        Sheet sheet = this.sheetName == null ? this.workbook.createSheet() : this.workbook.createSheet(this.sheetName);
        Row row = null;
        Cell cell = null;
        for (int i = 0; i < this.cells.length; ++i) {
            Object[] objectArray = this.cells[i];
            row = sheet.createRow(i);
            for (int j = 0; j < objectArray.length; ++j) {
                Object object = objectArray[j];
                if (object == null && !this.shouldCreateEmptyCells) continue;
                cell = row.createCell(j);
                this.setCellValue(cell, object);
            }
        }
        return sheet;
    }

    private void setCellValue(Cell cell, Object object) {
        if (object == null || cell == null) {
            return;
        }
        if (object instanceof Number) {
            double d = ((Number)object).doubleValue();
            cell.setCellValue(d);
        } else if (object instanceof Date) {
            cell.setCellValue((Date)object);
        } else if (object instanceof Calendar) {
            cell.setCellValue((Calendar)object);
        } else if (this.isFormulaDefinition(object)) {
            cell.setCellFormula(this.getFormula(object));
        } else {
            cell.setCellValue(object.toString());
        }
    }

    private boolean isFormulaDefinition(Object object) {
        if (object instanceof String) {
            String string = (String)object;
            if (string.length() < 2) {
                return false;
            }
            return ((String)object).charAt(0) == '=';
        }
        return false;
    }

    private String getFormula(Object object) {
        return ((String)object).substring(1);
    }
}

