/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.ss.util;

import ai.org.apache.poi.ss.usermodel.Cell;
import ai.org.apache.poi.ss.usermodel.CellRange;
import ai.org.apache.poi.ss.util.CellRangeAddress;
import ai.org.apache.poi.util.Internal;
import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Internal
public final class SSCellRange<K extends Cell>
implements CellRange<K> {
    private final int _height;
    private final int _width;
    private final K[] _flattenedArray;
    private final int _firstRow;
    private final int _firstColumn;

    private SSCellRange(int n, int n2, int n3, int n4, K[] KArray) {
        this._firstRow = n;
        this._firstColumn = n2;
        this._height = n3;
        this._width = n4;
        this._flattenedArray = KArray;
    }

    public static <B extends Cell> SSCellRange<B> create(int n, int n2, int n3, int n4, List<B> list, Class<B> clazz) {
        int n5 = list.size();
        if (n3 * n4 != n5) {
            throw new IllegalArgumentException("Array size mismatch.");
        }
        Cell[] cellArray = (Cell[])Array.newInstance(clazz, n5);
        list.toArray(cellArray);
        return new SSCellRange(n, n2, n3, n4, cellArray);
    }

    @Override
    public int getHeight() {
        return this._height;
    }

    @Override
    public int getWidth() {
        return this._width;
    }

    @Override
    public int size() {
        return this._height * this._width;
    }

    @Override
    public String getReferenceText() {
        CellRangeAddress cellRangeAddress = new CellRangeAddress(this._firstRow, this._firstRow + this._height - 1, this._firstColumn, this._firstColumn + this._width - 1);
        return cellRangeAddress.formatAsString();
    }

    @Override
    public K getTopLeftCell() {
        return this._flattenedArray[0];
    }

    @Override
    public K getCell(int n, int n2) {
        if (n < 0 || n >= this._height) {
            throw new ArrayIndexOutOfBoundsException("Specified row " + n + " is outside the allowable range (0.." + (this._height - 1) + ").");
        }
        if (n2 < 0 || n2 >= this._width) {
            throw new ArrayIndexOutOfBoundsException("Specified colummn " + n2 + " is outside the allowable range (0.." + (this._width - 1) + ").");
        }
        int n3 = this._width * n + n2;
        return this._flattenedArray[n3];
    }

    @Override
    public K[] getFlattenedCells() {
        return (Cell[])this._flattenedArray.clone();
    }

    @Override
    public K[][] getCells() {
        Class<?> clazz = this._flattenedArray.getClass();
        Cell[][] cellArray = (Cell[][])Array.newInstance(clazz, this._height);
        clazz = clazz.getComponentType();
        for (int i = this._height - 1; i >= 0; --i) {
            Cell[] cellArray2 = (Cell[])Array.newInstance(clazz, this._width);
            int n = this._width * i;
            System.arraycopy(this._flattenedArray, n, cellArray2, 0, this._width);
        }
        return cellArray;
    }

    @Override
    public Iterator<K> iterator() {
        return new ArrayIterator<K>(this._flattenedArray);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ArrayIterator<D>
    implements Iterator<D> {
        private final D[] _array;
        private int _index;

        public ArrayIterator(D[] DArray) {
            this._array = DArray;
            this._index = 0;
        }

        @Override
        public boolean hasNext() {
            return this._index < this._array.length;
        }

        @Override
        public D next() {
            if (this._index >= this._array.length) {
                throw new NoSuchElementException(String.valueOf(this._index));
            }
            return this._array[this._index++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Cannot remove cells from this CellRange.");
        }
    }
}

