/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.ss.util;

import ai.org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import ai.org.apache.poi.ss.usermodel.ClientAnchor;
import ai.org.apache.poi.ss.usermodel.Picture;
import ai.org.apache.poi.ss.usermodel.PictureData;
import ai.org.apache.poi.ss.usermodel.Row;
import ai.org.apache.poi.ss.usermodel.Sheet;
import ai.org.apache.poi.util.POILogFactory;
import ai.org.apache.poi.util.POILogger;
import ai.org.apache.poi.util.Units;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ImageUtils {
    private static final POILogger logger = POILogFactory.getLogger(ImageUtils.class);
    public static final int PIXEL_DPI = 96;

    public static Dimension getImageDimension(InputStream inputStream, int n) {
        Dimension dimension = new Dimension();
        switch (n) {
            case 5: 
            case 6: 
            case 7: {
                try {
                    ImageInputStream imageInputStream = ImageIO.createImageInputStream(inputStream);
                    Iterator<ImageReader> iterator = ImageIO.getImageReaders(imageInputStream);
                    ImageReader imageReader = iterator.next();
                    imageReader.setInput(imageInputStream);
                    BufferedImage bufferedImage = imageReader.read(0);
                    int[] nArray = ImageUtils.getResolution(imageReader);
                    if (nArray[0] == 0) {
                        nArray[0] = 96;
                    }
                    if (nArray[1] == 0) {
                        nArray[1] = 96;
                    }
                    dimension.width = bufferedImage.getWidth() * 96 / nArray[0];
                    dimension.height = bufferedImage.getHeight() * 96 / nArray[1];
                    imageReader.dispose();
                    imageInputStream.close();
                }
                catch (IOException iOException) {
                    logger.log(5, iOException);
                }
                break;
            }
            default: {
                logger.log(5, "Only JPEG, PNG and DIB pictures can be automatically sized");
            }
        }
        return dimension;
    }

    public static int[] getResolution(ImageReader imageReader) throws IOException {
        int n = 96;
        int n2 = 96;
        double d = 25.4;
        Element element = (Element)imageReader.getImageMetadata(0).getAsTree("javax_imageio_1.0");
        NodeList nodeList = element.getElementsByTagName("HorizontalPixelSize");
        if (nodeList != null && nodeList.getLength() == 1) {
            n = (int)(d / (double)Float.parseFloat(((Element)nodeList.item(0)).getAttribute("value")));
        }
        if ((nodeList = element.getElementsByTagName("VerticalPixelSize")) != null && nodeList.getLength() == 1) {
            n2 = (int)(d / (double)Float.parseFloat(((Element)nodeList.item(0)).getAttribute("value")));
        }
        return new int[]{n, n2};
    }

    public static Dimension setPreferredSize(Picture picture, double d, double d2) {
        double d3;
        ClientAnchor clientAnchor = picture.getClientAnchor();
        boolean bl = clientAnchor instanceof HSSFClientAnchor;
        PictureData pictureData = picture.getPictureData();
        Sheet sheet = picture.getSheet();
        Dimension dimension = ImageUtils.getImageDimension(new ByteArrayInputStream(pictureData.getData()), pictureData.getPictureType());
        Dimension dimension2 = ImageUtils.getDimensionFromAnchor(picture);
        double d4 = d == Double.MAX_VALUE ? dimension.getWidth() : dimension2.getWidth() / 9525.0 * d;
        double d5 = d2 == Double.MAX_VALUE ? dimension.getHeight() : dimension2.getHeight() / 9525.0 * d2;
        double d6 = 0.0;
        int n = clientAnchor.getCol1();
        int n2 = 0;
        d6 = sheet.getColumnWidthInPixels(n++);
        d6 = bl ? (d6 *= 1.0 - (double)clientAnchor.getDx1() / 1024.0) : (d6 -= (double)(clientAnchor.getDx1() / 9525));
        while (d6 < d4) {
            d6 += (double)sheet.getColumnWidthInPixels(n++);
        }
        if (d6 > d4) {
            d3 = sheet.getColumnWidthInPixels(--n);
            double d7 = d6 - d4;
            n2 = bl ? (int)((d3 - d7) / d3 * 1024.0) : (int)((d3 - d7) * 9525.0);
            if (n2 < 0) {
                n2 = 0;
            }
        }
        clientAnchor.setCol2(n);
        clientAnchor.setDx2(n2);
        d3 = 0.0;
        int n3 = clientAnchor.getRow1();
        int n4 = 0;
        d3 = ImageUtils.getRowHeightInPixels(sheet, n3++);
        d3 = bl ? (d3 *= 1.0 - (double)clientAnchor.getDy1() / 256.0) : (d3 -= (double)(clientAnchor.getDy1() / 9525));
        while (d3 < d5) {
            d3 += ImageUtils.getRowHeightInPixels(sheet, n3++);
        }
        if (d3 > d5) {
            double d8 = ImageUtils.getRowHeightInPixels(sheet, --n3);
            double d9 = d3 - d5;
            n4 = bl ? (int)((d8 - d9) / d8 * 256.0) : (int)((d8 - d9) * 9525.0);
            if (n4 < 0) {
                n4 = 0;
            }
        }
        clientAnchor.setRow2(n3);
        clientAnchor.setDy2(n4);
        Dimension dimension3 = new Dimension((int)Math.round(d4 * 9525.0), (int)Math.round(d5 * 9525.0));
        return dimension3;
    }

    public static Dimension getDimensionFromAnchor(Picture picture) {
        ClientAnchor clientAnchor = picture.getClientAnchor();
        boolean bl = clientAnchor instanceof HSSFClientAnchor;
        Sheet sheet = picture.getSheet();
        double d = 0.0;
        int n = clientAnchor.getCol1();
        d = sheet.getColumnWidthInPixels(n++);
        d = bl ? (d *= 1.0 - (double)clientAnchor.getDx1() / 1024.0) : (d -= (double)(clientAnchor.getDx1() / 9525));
        while (n < clientAnchor.getCol2()) {
            d += (double)sheet.getColumnWidthInPixels(n++);
        }
        d = bl ? (d += (double)(sheet.getColumnWidthInPixels(n) * (float)clientAnchor.getDx2()) / 1024.0) : (d += (double)(clientAnchor.getDx2() / 9525));
        double d2 = 0.0;
        int n2 = clientAnchor.getRow1();
        d2 = ImageUtils.getRowHeightInPixels(sheet, n2++);
        d2 = bl ? (d2 *= 1.0 - (double)clientAnchor.getDy1() / 256.0) : (d2 -= (double)(clientAnchor.getDy1() / 9525));
        while (n2 < clientAnchor.getRow2()) {
            d2 += ImageUtils.getRowHeightInPixels(sheet, n2++);
        }
        d2 = bl ? (d2 += ImageUtils.getRowHeightInPixels(sheet, n2) * (double)clientAnchor.getDy2() / 256.0) : (d2 += (double)(clientAnchor.getDy2() / 9525));
        return new Dimension((int)d * 9525, (int)d2 * 9525);
    }

    private static double getRowHeightInPixels(Sheet sheet, int n) {
        Row row = sheet.getRow(n);
        double d = row == null ? (double)sheet.getDefaultRowHeightInPoints() : (double)row.getHeightInPoints();
        return Units.toEMU(d) / 9525;
    }
}

