/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.ss.util;

import ai.org.apache.poi.ss.SpreadsheetVersion;
import ai.org.apache.poi.ss.formula.SheetNameFormatter;
import ai.org.apache.poi.ss.usermodel.Cell;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CellReference {
    private static final char ABSOLUTE_REFERENCE_MARKER = '$';
    private static final char SHEET_NAME_DELIMITER = '!';
    private static final char SPECIAL_NAME_DELIMITER = '\'';
    private static final Pattern CELL_REF_PATTERN = Pattern.compile("\\$?([A-Za-z]+)\\$?([0-9]+)");
    private static final Pattern COLUMN_REF_PATTERN = Pattern.compile("\\$?([A-Za-z]+)");
    private static final Pattern ROW_REF_PATTERN = Pattern.compile("\\$?([0-9]+)");
    private static final Pattern NAMED_RANGE_NAME_PATTERN = Pattern.compile("[_A-Za-z][_.A-Za-z0-9]*");
    private final int _rowIndex;
    private final int _colIndex;
    private final String _sheetName;
    private final boolean _isRowAbs;
    private final boolean _isColAbs;

    public CellReference(String string) {
        if (string.endsWith("#REF!")) {
            throw new IllegalArgumentException("Cell reference invalid: " + string);
        }
        String[] stringArray = CellReference.separateRefParts(string);
        this._sheetName = stringArray[0];
        String string2 = stringArray[1];
        boolean bl = this._isColAbs = string2.length() > 0 && string2.charAt(0) == '$';
        if (this._isColAbs) {
            string2 = string2.substring(1);
        }
        this._colIndex = string2.length() == 0 ? -1 : CellReference.convertColStringToIndex(string2);
        String string3 = stringArray[2];
        boolean bl2 = this._isRowAbs = string3.length() > 0 && string3.charAt(0) == '$';
        if (this._isRowAbs) {
            string3 = string3.substring(1);
        }
        this._rowIndex = string3.length() == 0 ? -1 : Integer.parseInt(string3) - 1;
    }

    public CellReference(int n, int n2) {
        this(n, n2, false, false);
    }

    public CellReference(int n, short s) {
        this(n, s & 0xFFFF, false, false);
    }

    public CellReference(Cell cell) {
        this(cell.getRowIndex(), cell.getColumnIndex(), false, false);
    }

    public CellReference(int n, int n2, boolean bl, boolean bl2) {
        this(null, n, n2, bl, bl2);
    }

    public CellReference(String string, int n, int n2, boolean bl, boolean bl2) {
        if (n < -1) {
            throw new IllegalArgumentException("row index may not be negative");
        }
        if (n2 < -1) {
            throw new IllegalArgumentException("column index may not be negative");
        }
        this._sheetName = string;
        this._rowIndex = n;
        this._colIndex = n2;
        this._isRowAbs = bl;
        this._isColAbs = bl2;
    }

    public int getRow() {
        return this._rowIndex;
    }

    public short getCol() {
        return (short)this._colIndex;
    }

    public boolean isRowAbsolute() {
        return this._isRowAbs;
    }

    public boolean isColAbsolute() {
        return this._isColAbs;
    }

    public String getSheetName() {
        return this._sheetName;
    }

    public static boolean isPartAbsolute(String string) {
        return string.charAt(0) == '$';
    }

    public static int convertColStringToIndex(String string) {
        int n = 0;
        char[] cArray = string.toUpperCase().toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (c == '$') {
                if (i == 0) continue;
                throw new IllegalArgumentException("Bad col ref format '" + string + "'");
            }
            n = n * 26 + (c - 65 + 1);
        }
        return n - 1;
    }

    public static NameType classifyCellReference(String string, SpreadsheetVersion spreadsheetVersion) {
        String string2;
        int n = string.length();
        if (n < 1) {
            throw new IllegalArgumentException("Empty string not allowed");
        }
        char c = string.charAt(0);
        switch (c) {
            case '$': 
            case '.': 
            case '_': {
                break;
            }
            default: {
                if (Character.isLetter(c) || Character.isDigit(c)) break;
                throw new IllegalArgumentException("Invalid first char (" + c + ") of cell reference or named range.  Letter expected");
            }
        }
        if (!Character.isDigit(string.charAt(n - 1))) {
            return CellReference.validateNamedRangeName(string, spreadsheetVersion);
        }
        Matcher matcher = CELL_REF_PATTERN.matcher(string);
        if (!matcher.matches()) {
            return CellReference.validateNamedRangeName(string, spreadsheetVersion);
        }
        String string3 = matcher.group(1);
        if (CellReference.cellReferenceIsWithinRange(string3, string2 = matcher.group(2), spreadsheetVersion)) {
            return NameType.CELL;
        }
        if (string.indexOf(36) >= 0) {
            return NameType.BAD_CELL_OR_NAMED_RANGE;
        }
        return NameType.NAMED_RANGE;
    }

    private static NameType validateNamedRangeName(String string, SpreadsheetVersion spreadsheetVersion) {
        String string2;
        Object object;
        Matcher matcher = COLUMN_REF_PATTERN.matcher(string);
        if (matcher.matches() && CellReference.isColumnWithnRange((String)(object = matcher.group(1)), spreadsheetVersion)) {
            return NameType.COLUMN;
        }
        object = ROW_REF_PATTERN.matcher(string);
        if (((Matcher)object).matches() && CellReference.isRowWithnRange(string2 = ((Matcher)object).group(1), spreadsheetVersion)) {
            return NameType.ROW;
        }
        if (!NAMED_RANGE_NAME_PATTERN.matcher(string).matches()) {
            return NameType.BAD_CELL_OR_NAMED_RANGE;
        }
        return NameType.NAMED_RANGE;
    }

    public static boolean cellReferenceIsWithinRange(String string, String string2, SpreadsheetVersion spreadsheetVersion) {
        if (!CellReference.isColumnWithnRange(string, spreadsheetVersion)) {
            return false;
        }
        return CellReference.isRowWithnRange(string2, spreadsheetVersion);
    }

    public static boolean isColumnWithnRange(String string, SpreadsheetVersion spreadsheetVersion) {
        String string2 = spreadsheetVersion.getLastColumnName();
        int n = string2.length();
        int n2 = string.length();
        if (n2 > n) {
            return false;
        }
        return n2 != n || string.toUpperCase().compareTo(string2) <= 0;
    }

    public static boolean isRowWithnRange(String string, SpreadsheetVersion spreadsheetVersion) {
        int n = Integer.parseInt(string);
        if (n < 0) {
            throw new IllegalStateException("Invalid rowStr '" + string + "'.");
        }
        if (n == 0) {
            return false;
        }
        return n <= spreadsheetVersion.getMaxRows();
    }

    private static String[] separateRefParts(String string) {
        char c;
        int n = string.lastIndexOf(33);
        String string2 = CellReference.parseSheetName(string, n);
        int n2 = n + 1;
        int n3 = string.length();
        int n4 = n2;
        if (string.charAt(n4) == '$') {
            ++n4;
        }
        while (n4 < n3 && !Character.isDigit(c = string.charAt(n4)) && c != '$') {
            ++n4;
        }
        return new String[]{string2, string.substring(n2, n4), string.substring(n4)};
    }

    private static String parseSheetName(String string, int n) {
        boolean bl;
        if (n < 0) {
            return null;
        }
        boolean bl2 = bl = string.charAt(0) == '\'';
        if (!bl) {
            return string.substring(0, n);
        }
        int n2 = n - 1;
        if (string.charAt(n2) != '\'') {
            throw new RuntimeException("Mismatched quotes: (" + string + ")");
        }
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 1; i < n2; ++i) {
            char c = string.charAt(i);
            if (c != '\'') {
                stringBuffer.append(c);
                continue;
            }
            if (i < n2 && string.charAt(i + 1) == '\'') {
                ++i;
                stringBuffer.append(c);
                continue;
            }
            throw new RuntimeException("Bad sheet name quote escaping: (" + string + ")");
        }
        return stringBuffer.toString();
    }

    public static String convertNumToColString(int n) {
        int n2 = n + 1;
        StringBuilder stringBuilder = new StringBuilder(2);
        int n3 = n2;
        while (n3 > 0) {
            int n4 = n3 % 26;
            if (n4 == 0) {
                n4 = 26;
            }
            n3 = (n3 - n4) / 26;
            char c = (char)(n4 + 64);
            stringBuilder.insert(0, c);
        }
        return stringBuilder.toString();
    }

    public String formatAsString() {
        StringBuffer stringBuffer = new StringBuffer(32);
        if (this._sheetName != null) {
            SheetNameFormatter.appendFormat(stringBuffer, this._sheetName);
            stringBuffer.append('!');
        }
        this.appendCellReference(stringBuffer);
        return stringBuffer.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append(this.getClass().getName()).append(" [");
        stringBuffer.append(this.formatAsString());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public String[] getCellRefParts() {
        return new String[]{this._sheetName, Integer.toString(this._rowIndex + 1), CellReference.convertNumToColString(this._colIndex)};
    }

    void appendCellReference(StringBuffer stringBuffer) {
        if (this._colIndex != -1) {
            if (this._isColAbs) {
                stringBuffer.append('$');
            }
            stringBuffer.append(CellReference.convertNumToColString(this._colIndex));
        }
        if (this._rowIndex != -1) {
            if (this._isRowAbs) {
                stringBuffer.append('$');
            }
            stringBuffer.append(this._rowIndex + 1);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CellReference)) {
            return false;
        }
        CellReference cellReference = (CellReference)object;
        return this._rowIndex == cellReference._rowIndex && this._colIndex == cellReference._colIndex && this._isRowAbs == cellReference._isRowAbs && this._isColAbs == cellReference._isColAbs;
    }

    public int hashCode() {
        int n = 17;
        n = 31 * n + this._rowIndex;
        n = 31 * n + this._colIndex;
        n = 31 * n + (this._isRowAbs ? 1 : 0);
        n = 31 * n + (this._isColAbs ? 1 : 0);
        return n;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum NameType {
        CELL,
        NAMED_RANGE,
        COLUMN,
        ROW,
        BAD_CELL_OR_NAMED_RANGE;

    }
}

