/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.ss.usermodel;

import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum FormulaError {
    NULL(0, "#NULL!"),
    DIV0(7, "#DIV/0!"),
    VALUE(15, "#VALUE!"),
    REF(23, "#REF!"),
    NAME(29, "#NAME?"),
    NUM(36, "#NUM!"),
    NA(42, "#N/A");

    private byte type;
    private String repr;
    private static Map<String, FormulaError> smap;
    private static Map<Byte, FormulaError> imap;

    private FormulaError(int n2, String string2) {
        this.type = (byte)n2;
        this.repr = string2;
    }

    public byte getCode() {
        return this.type;
    }

    public String getString() {
        return this.repr;
    }

    public static FormulaError forInt(byte by) {
        FormulaError formulaError = imap.get(by);
        if (formulaError == null) {
            throw new IllegalArgumentException("Unknown error type: " + by);
        }
        return formulaError;
    }

    public static FormulaError forString(String string) {
        FormulaError formulaError = smap.get(string);
        if (formulaError == null) {
            throw new IllegalArgumentException("Unknown error code: " + string);
        }
        return formulaError;
    }

    static {
        smap = new HashMap<String, FormulaError>();
        imap = new HashMap<Byte, FormulaError>();
        for (FormulaError formulaError : FormulaError.values()) {
            imap.put(formulaError.getCode(), formulaError);
            smap.put(formulaError.getString(), formulaError);
        }
    }
}

