/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.ss.formula.ptg;

import ai.org.apache.poi.ss.formula.ptg.ScalarConstantPtg;
import ai.org.apache.poi.util.LittleEndianInput;
import ai.org.apache.poi.util.LittleEndianOutput;
import ai.org.apache.poi.util.StringUtil;

public final class StringPtg
extends ScalarConstantPtg {
    public static final byte sid = 23;
    private static final char FORMULA_DELIMITER = '\"';
    private final boolean _is16bitUnicode;
    private final String field_3_string;

    public StringPtg(LittleEndianInput littleEndianInput) {
        int n = littleEndianInput.readUByte();
        this._is16bitUnicode = (littleEndianInput.readByte() & 1) != 0;
        this.field_3_string = this._is16bitUnicode ? StringUtil.readUnicodeLE(littleEndianInput, n) : StringUtil.readCompressedUnicode(littleEndianInput, n);
    }

    public StringPtg(String string) {
        if (string.length() > 255) {
            throw new IllegalArgumentException("String literals in formulas can't be bigger than 255 characters ASCII");
        }
        this._is16bitUnicode = StringUtil.hasMultibyte(string);
        this.field_3_string = string;
    }

    public String getValue() {
        return this.field_3_string;
    }

    public void write(LittleEndianOutput littleEndianOutput) {
        littleEndianOutput.writeByte(23 + this.getPtgClass());
        littleEndianOutput.writeByte(this.field_3_string.length());
        littleEndianOutput.writeByte(this._is16bitUnicode ? 1 : 0);
        if (this._is16bitUnicode) {
            StringUtil.putUnicodeLE(this.field_3_string, littleEndianOutput);
        } else {
            StringUtil.putCompressedUnicode(this.field_3_string, littleEndianOutput);
        }
    }

    public int getSize() {
        return 3 + this.field_3_string.length() * (this._is16bitUnicode ? 2 : 1);
    }

    public String toFormulaString() {
        String string = this.field_3_string;
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n + 4);
        stringBuffer.append('\"');
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '\"') {
                stringBuffer.append('\"');
            }
            stringBuffer.append(c);
        }
        stringBuffer.append('\"');
        return stringBuffer.toString();
    }
}

