/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.ss.formula.ptg;

import ai.org.apache.poi.ss.formula.SheetIdentifier;
import ai.org.apache.poi.ss.formula.SheetNameFormatter;
import ai.org.apache.poi.ss.formula.SheetRangeIdentifier;
import ai.org.apache.poi.ss.formula.ptg.Pxg;
import ai.org.apache.poi.ss.formula.ptg.RefPtgBase;
import ai.org.apache.poi.ss.util.CellReference;
import ai.org.apache.poi.util.LittleEndianOutput;

public final class Ref3DPxg
extends RefPtgBase
implements Pxg {
    private int externalWorkbookNumber = -1;
    private String firstSheetName;
    private String lastSheetName;

    public Ref3DPxg(int n, SheetIdentifier sheetIdentifier, String string) {
        this(n, sheetIdentifier, new CellReference(string));
    }

    public Ref3DPxg(int n, SheetIdentifier sheetIdentifier, CellReference cellReference) {
        super(cellReference);
        this.externalWorkbookNumber = n;
        this.firstSheetName = sheetIdentifier.getSheetIdentifier().getName();
        this.lastSheetName = sheetIdentifier instanceof SheetRangeIdentifier ? ((SheetRangeIdentifier)sheetIdentifier).getLastSheetIdentifier().getName() : null;
    }

    public Ref3DPxg(SheetIdentifier sheetIdentifier, String string) {
        this(sheetIdentifier, new CellReference(string));
    }

    public Ref3DPxg(SheetIdentifier sheetIdentifier, CellReference cellReference) {
        this(-1, sheetIdentifier, cellReference);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append(" [");
        if (this.externalWorkbookNumber >= 0) {
            stringBuffer.append(" [");
            stringBuffer.append("workbook=").append(this.getExternalWorkbookNumber());
            stringBuffer.append("] ");
        }
        stringBuffer.append("sheet=").append(this.firstSheetName);
        if (this.lastSheetName != null) {
            stringBuffer.append(" : ");
            stringBuffer.append("sheet=").append(this.lastSheetName);
        }
        stringBuffer.append(" ! ");
        stringBuffer.append(this.formatReferenceAsString());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public int getExternalWorkbookNumber() {
        return this.externalWorkbookNumber;
    }

    public String getSheetName() {
        return this.firstSheetName;
    }

    public String getLastSheetName() {
        return this.lastSheetName;
    }

    public void setSheetName(String string) {
        this.firstSheetName = string;
    }

    public void setLastSheetName(String string) {
        this.lastSheetName = string;
    }

    public String format2DRefAsString() {
        return this.formatReferenceAsString();
    }

    public String toFormulaString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.externalWorkbookNumber >= 0) {
            stringBuffer.append('[');
            stringBuffer.append(this.externalWorkbookNumber);
            stringBuffer.append(']');
        }
        if (this.firstSheetName != null) {
            SheetNameFormatter.appendFormat(stringBuffer, this.firstSheetName);
        }
        if (this.lastSheetName != null) {
            stringBuffer.append(':');
            SheetNameFormatter.appendFormat(stringBuffer, this.lastSheetName);
        }
        stringBuffer.append('!');
        stringBuffer.append(this.formatReferenceAsString());
        return stringBuffer.toString();
    }

    public int getSize() {
        return 1;
    }

    public void write(LittleEndianOutput littleEndianOutput) {
        throw new IllegalStateException("XSSF-only Ptg, should not be serialised");
    }
}

