/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.ss.formula.ptg;

import ai.org.apache.poi.ss.formula.FormulaRenderingWorkbook;
import ai.org.apache.poi.ss.formula.WorkbookDependentFormula;
import ai.org.apache.poi.ss.formula.ptg.OperandPtg;
import ai.org.apache.poi.util.LittleEndianInput;
import ai.org.apache.poi.util.LittleEndianOutput;

public final class NameXPtg
extends OperandPtg
implements WorkbookDependentFormula {
    public static final short sid = 57;
    private static final int SIZE = 7;
    private final int _sheetRefIndex;
    private final int _nameNumber;
    private final int _reserved;

    private NameXPtg(int n, int n2, int n3) {
        this._sheetRefIndex = n;
        this._nameNumber = n2;
        this._reserved = n3;
    }

    public NameXPtg(int n, int n2) {
        this(n, n2 + 1, 0);
    }

    public NameXPtg(LittleEndianInput littleEndianInput) {
        this(littleEndianInput.readUShort(), littleEndianInput.readUShort(), littleEndianInput.readUShort());
    }

    public void write(LittleEndianOutput littleEndianOutput) {
        littleEndianOutput.writeByte(57 + this.getPtgClass());
        littleEndianOutput.writeShort(this._sheetRefIndex);
        littleEndianOutput.writeShort(this._nameNumber);
        littleEndianOutput.writeShort(this._reserved);
    }

    public int getSize() {
        return 7;
    }

    public String toFormulaString(FormulaRenderingWorkbook formulaRenderingWorkbook) {
        return formulaRenderingWorkbook.resolveNameXText(this);
    }

    public String toFormulaString() {
        throw new RuntimeException("3D references need a workbook to determine formula text");
    }

    public String toString() {
        String string = "NameXPtg:[sheetRefIndex:" + this._sheetRefIndex + " , nameNumber:" + this._nameNumber + "]";
        return string;
    }

    public byte getDefaultOperandClass() {
        return 32;
    }

    public int getSheetRefIndex() {
        return this._sheetRefIndex;
    }

    public int getNameIndex() {
        return this._nameNumber - 1;
    }
}

