/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.ss.formula.ptg;

import ai.org.apache.poi.ss.formula.function.FunctionMetadata;
import ai.org.apache.poi.ss.formula.function.FunctionMetadataRegistry;
import ai.org.apache.poi.ss.formula.ptg.AbstractFunctionPtg;
import ai.org.apache.poi.util.LittleEndianInput;
import ai.org.apache.poi.util.LittleEndianOutput;

public final class FuncPtg
extends AbstractFunctionPtg {
    public static final byte sid = 33;
    public static final int SIZE = 3;

    public static FuncPtg create(LittleEndianInput littleEndianInput) {
        return FuncPtg.create(littleEndianInput.readUShort());
    }

    private FuncPtg(int n, FunctionMetadata functionMetadata) {
        super(n, functionMetadata.getReturnClassCode(), functionMetadata.getParameterClassCodes(), functionMetadata.getMinParams());
    }

    public static FuncPtg create(int n) {
        FunctionMetadata functionMetadata = FunctionMetadataRegistry.getFunctionByIndex(n);
        if (functionMetadata == null) {
            throw new RuntimeException("Invalid built-in function index (" + n + ")");
        }
        return new FuncPtg(n, functionMetadata);
    }

    public void write(LittleEndianOutput littleEndianOutput) {
        littleEndianOutput.writeByte(33 + this.getPtgClass());
        littleEndianOutput.writeShort(this.getFunctionIndex());
    }

    public int getSize() {
        return 3;
    }
}

