/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.ss.formula.functions;

import ai.org.apache.poi.ss.formula.TwoDEval;
import ai.org.apache.poi.ss.formula.eval.ErrorEval;
import ai.org.apache.poi.ss.formula.eval.EvaluationException;
import ai.org.apache.poi.ss.formula.eval.NumberEval;
import ai.org.apache.poi.ss.formula.eval.RefEval;
import ai.org.apache.poi.ss.formula.eval.ValueEval;
import ai.org.apache.poi.ss.formula.functions.Fixed2ArgFunction;
import ai.org.apache.poi.ss.formula.functions.LookupUtils;

public abstract class XYNumericFunction
extends Fixed2ArgFunction {
    protected abstract Accumulator createAccumulator();

    public ValueEval evaluate(int n, int n2, ValueEval valueEval, ValueEval valueEval2) {
        double d;
        try {
            LookupUtils.ValueVector valueVector = XYNumericFunction.createValueVector(valueEval);
            LookupUtils.ValueVector valueVector2 = XYNumericFunction.createValueVector(valueEval2);
            int n3 = valueVector.getSize();
            if (n3 == 0 || valueVector2.getSize() != n3) {
                return ErrorEval.NA;
            }
            d = this.evaluateInternal(valueVector, valueVector2, n3);
        }
        catch (EvaluationException evaluationException) {
            return evaluationException.getErrorEval();
        }
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            return ErrorEval.NUM_ERROR;
        }
        return new NumberEval(d);
    }

    private double evaluateInternal(LookupUtils.ValueVector valueVector, LookupUtils.ValueVector valueVector2, int n) throws EvaluationException {
        Accumulator accumulator = this.createAccumulator();
        ErrorEval errorEval = null;
        ErrorEval errorEval2 = null;
        boolean bl = false;
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            ValueEval valueEval = valueVector.getItem(i);
            ValueEval valueEval2 = valueVector2.getItem(i);
            if (valueEval instanceof ErrorEval && errorEval == null) {
                errorEval = (ErrorEval)valueEval;
                continue;
            }
            if (valueEval2 instanceof ErrorEval && errorEval2 == null) {
                errorEval2 = (ErrorEval)valueEval2;
                continue;
            }
            if (!(valueEval instanceof NumberEval) || !(valueEval2 instanceof NumberEval)) continue;
            bl = true;
            NumberEval numberEval = (NumberEval)valueEval;
            NumberEval numberEval2 = (NumberEval)valueEval2;
            d += accumulator.accumulate(numberEval.getNumberValue(), numberEval2.getNumberValue());
        }
        if (errorEval != null) {
            throw new EvaluationException(errorEval);
        }
        if (errorEval2 != null) {
            throw new EvaluationException(errorEval2);
        }
        if (!bl) {
            throw new EvaluationException(ErrorEval.DIV_ZERO);
        }
        return d;
    }

    private static LookupUtils.ValueVector createValueVector(ValueEval valueEval) throws EvaluationException {
        if (valueEval instanceof ErrorEval) {
            throw new EvaluationException((ErrorEval)valueEval);
        }
        if (valueEval instanceof TwoDEval) {
            return new AreaValueArray((TwoDEval)valueEval);
        }
        if (valueEval instanceof RefEval) {
            return new RefValueArray((RefEval)valueEval);
        }
        return new SingleCellValueArray(valueEval);
    }

    protected static interface Accumulator {
        public double accumulate(double var1, double var3);
    }

    private static final class AreaValueArray
    extends ValueArray {
        private final TwoDEval _ae;
        private final int _width;

        public AreaValueArray(TwoDEval twoDEval) {
            super(twoDEval.getWidth() * twoDEval.getHeight());
            this._ae = twoDEval;
            this._width = twoDEval.getWidth();
        }

        protected ValueEval getItemInternal(int n) {
            int n2 = n / this._width;
            int n3 = n % this._width;
            return this._ae.getValue(n2, n3);
        }
    }

    private static final class RefValueArray
    extends ValueArray {
        private final RefEval _ref;
        private final int _width;

        public RefValueArray(RefEval refEval) {
            super(refEval.getNumberOfSheets());
            this._ref = refEval;
            this._width = refEval.getNumberOfSheets();
        }

        protected ValueEval getItemInternal(int n) {
            int n2 = n % this._width + this._ref.getFirstSheetIndex();
            return this._ref.getInnerValueEval(n2);
        }
    }

    private static final class SingleCellValueArray
    extends ValueArray {
        private final ValueEval _value;

        public SingleCellValueArray(ValueEval valueEval) {
            super(1);
            this._value = valueEval;
        }

        protected ValueEval getItemInternal(int n) {
            return this._value;
        }
    }

    private static abstract class ValueArray
    implements LookupUtils.ValueVector {
        private final int _size;

        protected ValueArray(int n) {
            this._size = n;
        }

        public ValueEval getItem(int n) {
            if (n < 0 || n > this._size) {
                throw new IllegalArgumentException("Specified index " + n + " is outside range (0.." + (this._size - 1) + ")");
            }
            return this.getItemInternal(n);
        }

        protected abstract ValueEval getItemInternal(int var1);

        public final int getSize() {
            return this._size;
        }
    }
}

