/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.ss.formula.functions;

import ai.org.apache.poi.ss.formula.OperationEvaluationContext;
import ai.org.apache.poi.ss.formula.eval.ErrorEval;
import ai.org.apache.poi.ss.formula.eval.EvaluationException;
import ai.org.apache.poi.ss.formula.eval.NumberEval;
import ai.org.apache.poi.ss.formula.eval.OperandResolver;
import ai.org.apache.poi.ss.formula.eval.ValueEval;
import ai.org.apache.poi.ss.formula.functions.Fixed2ArgFunction;
import ai.org.apache.poi.ss.formula.functions.FreeRefFunction;
import ai.org.apache.poi.ss.formula.functions.NumericFunction;
import ai.org.apache.poi.ss.usermodel.DateUtil;
import java.util.Calendar;
import java.util.GregorianCalendar;

public class WeekNum
extends Fixed2ArgFunction
implements FreeRefFunction {
    public static final FreeRefFunction instance = new WeekNum();

    public ValueEval evaluate(int n, int n2, ValueEval valueEval, ValueEval valueEval2) {
        double d = 0.0;
        try {
            d = NumericFunction.singleOperandEvaluate(valueEval, n, n2);
        }
        catch (EvaluationException evaluationException) {
            return ErrorEval.VALUE_INVALID;
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(DateUtil.getJavaDate(d, false));
        int n3 = 0;
        try {
            ValueEval valueEval3 = OperandResolver.getSingleValue(valueEval2, n, n2);
            n3 = OperandResolver.coerceValueToInt(valueEval3);
        }
        catch (EvaluationException evaluationException) {
            return ErrorEval.NUM_ERROR;
        }
        if (n3 != 1 && n3 != 2) {
            return ErrorEval.NUM_ERROR;
        }
        return new NumberEval(this.getWeekNo(gregorianCalendar, n3));
    }

    public int getWeekNo(Calendar calendar, int n) {
        if (n == 1) {
            calendar.setFirstDayOfWeek(1);
        } else {
            calendar.setFirstDayOfWeek(2);
        }
        return calendar.get(3);
    }

    public ValueEval evaluate(ValueEval[] valueEvalArray, OperationEvaluationContext operationEvaluationContext) {
        if (valueEvalArray.length == 2) {
            return this.evaluate(operationEvaluationContext.getRowIndex(), operationEvaluationContext.getColumnIndex(), valueEvalArray[0], valueEvalArray[1]);
        }
        return ErrorEval.VALUE_INVALID;
    }
}

