/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.ss.formula.functions;

import ai.org.apache.poi.ss.formula.eval.ErrorEval;
import ai.org.apache.poi.ss.formula.eval.EvaluationException;
import ai.org.apache.poi.ss.formula.eval.MissingArgEval;
import ai.org.apache.poi.ss.formula.eval.NumberEval;
import ai.org.apache.poi.ss.formula.eval.OperandResolver;
import ai.org.apache.poi.ss.formula.eval.ValueEval;
import ai.org.apache.poi.ss.formula.functions.Fixed3ArgFunction;

public final class TimeFunc
extends Fixed3ArgFunction {
    private static final int SECONDS_PER_MINUTE = 60;
    private static final int SECONDS_PER_HOUR = 3600;
    private static final int HOURS_PER_DAY = 24;
    private static final int SECONDS_PER_DAY = 86400;

    public ValueEval evaluate(int n, int n2, ValueEval valueEval, ValueEval valueEval2, ValueEval valueEval3) {
        double d;
        try {
            d = TimeFunc.evaluate(TimeFunc.evalArg(valueEval, n, n2), TimeFunc.evalArg(valueEval2, n, n2), TimeFunc.evalArg(valueEval3, n, n2));
        }
        catch (EvaluationException evaluationException) {
            return evaluationException.getErrorEval();
        }
        return new NumberEval(d);
    }

    private static int evalArg(ValueEval valueEval, int n, int n2) throws EvaluationException {
        if (valueEval == MissingArgEval.instance) {
            return 0;
        }
        ValueEval valueEval2 = OperandResolver.getSingleValue(valueEval, n, n2);
        return OperandResolver.coerceValueToInt(valueEval2);
    }

    private static double evaluate(int n, int n2, int n3) throws EvaluationException {
        if (n > Short.MAX_VALUE || n2 > Short.MAX_VALUE || n3 > Short.MAX_VALUE) {
            throw new EvaluationException(ErrorEval.VALUE_INVALID);
        }
        int n4 = n * 3600 + n2 * 60 + n3;
        if (n4 < 0) {
            throw new EvaluationException(ErrorEval.VALUE_INVALID);
        }
        return (double)(n4 % 86400) / 86400.0;
    }
}

