/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.ss.formula.functions;

import ai.org.apache.poi.ss.formula.OperationEvaluationContext;
import ai.org.apache.poi.ss.formula.eval.AreaEval;
import ai.org.apache.poi.ss.formula.eval.ErrorEval;
import ai.org.apache.poi.ss.formula.eval.EvaluationException;
import ai.org.apache.poi.ss.formula.eval.NumberEval;
import ai.org.apache.poi.ss.formula.eval.RefEval;
import ai.org.apache.poi.ss.formula.eval.ValueEval;
import ai.org.apache.poi.ss.formula.functions.CountUtils;
import ai.org.apache.poi.ss.formula.functions.Countif;
import ai.org.apache.poi.ss.formula.functions.FreeRefFunction;

public final class Sumifs
implements FreeRefFunction {
    public static final FreeRefFunction instance = new Sumifs();

    public ValueEval evaluate(ValueEval[] valueEvalArray, OperationEvaluationContext operationEvaluationContext) {
        if (valueEvalArray.length < 3 || valueEvalArray.length % 2 == 0) {
            return ErrorEval.VALUE_INVALID;
        }
        try {
            AreaEval areaEval = Sumifs.convertRangeArg(valueEvalArray[0]);
            AreaEval[] areaEvalArray = new AreaEval[(valueEvalArray.length - 1) / 2];
            CountUtils.I_MatchPredicate[] i_MatchPredicateArray = new CountUtils.I_MatchPredicate[areaEvalArray.length];
            int n = 1;
            int n2 = 0;
            while (n < valueEvalArray.length) {
                areaEvalArray[n2] = Sumifs.convertRangeArg(valueEvalArray[n]);
                i_MatchPredicateArray[n2] = Countif.createCriteriaPredicate(valueEvalArray[n + 1], operationEvaluationContext.getRowIndex(), operationEvaluationContext.getColumnIndex());
                n += 2;
                ++n2;
            }
            this.validateCriteriaRanges(areaEvalArray, areaEval);
            double d = Sumifs.sumMatchingCells(areaEvalArray, i_MatchPredicateArray, areaEval);
            return new NumberEval(d);
        }
        catch (EvaluationException evaluationException) {
            return evaluationException.getErrorEval();
        }
    }

    private void validateCriteriaRanges(AreaEval[] areaEvalArray, AreaEval areaEval) throws EvaluationException {
        for (AreaEval areaEval2 : areaEvalArray) {
            if (areaEval2.getHeight() == areaEval.getHeight() && areaEval2.getWidth() == areaEval.getWidth()) continue;
            throw EvaluationException.invalidValue();
        }
    }

    private static double sumMatchingCells(AreaEval[] areaEvalArray, CountUtils.I_MatchPredicate[] i_MatchPredicateArray, AreaEval areaEval) {
        int n = areaEval.getHeight();
        int n2 = areaEval.getWidth();
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                boolean bl = true;
                for (int k = 0; k < areaEvalArray.length; ++k) {
                    CountUtils.I_MatchPredicate i_MatchPredicate = i_MatchPredicateArray[k];
                    AreaEval areaEval2 = areaEvalArray[k];
                    if (i_MatchPredicate.matches(areaEval2.getRelativeValue(i, j))) continue;
                    bl = false;
                    break;
                }
                if (!bl) continue;
                d += Sumifs.accumulate(areaEval, i, j);
            }
        }
        return d;
    }

    private static double accumulate(AreaEval areaEval, int n, int n2) {
        ValueEval valueEval = areaEval.getRelativeValue(n, n2);
        if (valueEval instanceof NumberEval) {
            return ((NumberEval)valueEval).getNumberValue();
        }
        return 0.0;
    }

    private static AreaEval convertRangeArg(ValueEval valueEval) throws EvaluationException {
        if (valueEval instanceof AreaEval) {
            return (AreaEval)valueEval;
        }
        if (valueEval instanceof RefEval) {
            return ((RefEval)valueEval).offset(0, 0, 0, 0);
        }
        throw new EvaluationException(ErrorEval.VALUE_INVALID);
    }
}

