/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.ss.formula.functions;

import java.util.Arrays;

final class StatsLib {
    private StatsLib() {
    }

    public static double avedev(double[] dArray) {
        int n;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        int n2 = dArray.length;
        for (n = 0; n < n2; ++n) {
            d3 += dArray[n];
        }
        d2 = d3 / (double)dArray.length;
        d3 = 0.0;
        n2 = dArray.length;
        for (n = 0; n < n2; ++n) {
            d3 += Math.abs(dArray[n] - d2);
        }
        d = d3 / (double)dArray.length;
        return d;
    }

    public static double stdev(double[] dArray) {
        double d = Double.NaN;
        if (dArray != null && dArray.length > 1) {
            d = Math.sqrt(StatsLib.devsq(dArray) / (double)(dArray.length - 1));
        }
        return d;
    }

    public static double var(double[] dArray) {
        double d = Double.NaN;
        if (dArray != null && dArray.length > 1) {
            d = StatsLib.devsq(dArray) / (double)(dArray.length - 1);
        }
        return d;
    }

    public static double varp(double[] dArray) {
        double d = Double.NaN;
        if (dArray != null && dArray.length > 1) {
            d = StatsLib.devsq(dArray) / (double)dArray.length;
        }
        return d;
    }

    public static double median(double[] dArray) {
        double d = Double.NaN;
        if (dArray != null && dArray.length >= 1) {
            int n = dArray.length;
            Arrays.sort(dArray);
            d = n % 2 == 0 ? (dArray[n / 2] + dArray[n / 2 - 1]) / 2.0 : dArray[n / 2];
        }
        return d;
    }

    public static double devsq(double[] dArray) {
        double d = Double.NaN;
        if (dArray != null && dArray.length >= 1) {
            int n;
            double d2 = 0.0;
            double d3 = 0.0;
            int n2 = dArray.length;
            for (n = 0; n < n2; ++n) {
                d3 += dArray[n];
            }
            d2 = d3 / (double)n2;
            d3 = 0.0;
            for (n = 0; n < n2; ++n) {
                d3 += (dArray[n] - d2) * (dArray[n] - d2);
            }
            d = n2 == 1 ? 0.0 : d3;
        }
        return d;
    }

    public static double kthLargest(double[] dArray, int n) {
        double d = Double.NaN;
        int n2 = n - 1;
        if (dArray != null && dArray.length > n2 && n2 >= 0) {
            Arrays.sort(dArray);
            d = dArray[dArray.length - n2 - 1];
        }
        return d;
    }

    public static double kthSmallest(double[] dArray, int n) {
        double d = Double.NaN;
        int n2 = n - 1;
        if (dArray != null && dArray.length > n2 && n2 >= 0) {
            Arrays.sort(dArray);
            d = dArray[n2];
        }
        return d;
    }
}

