/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.ss.formula.functions;

import ai.org.apache.poi.ss.formula.eval.AreaEval;
import ai.org.apache.poi.ss.formula.eval.ErrorEval;
import ai.org.apache.poi.ss.formula.eval.EvaluationException;
import ai.org.apache.poi.ss.formula.eval.OperandResolver;
import ai.org.apache.poi.ss.formula.eval.RefEval;
import ai.org.apache.poi.ss.formula.eval.ValueEval;
import ai.org.apache.poi.ss.formula.functions.Function;

public final class Offset
implements Function {
    private static final int LAST_VALID_ROW_INDEX = 65535;
    private static final int LAST_VALID_COLUMN_INDEX = 255;

    public ValueEval evaluate(ValueEval[] valueEvalArray, int n, int n2) {
        if (valueEvalArray.length < 3 || valueEvalArray.length > 5) {
            return ErrorEval.VALUE_INVALID;
        }
        try {
            BaseRef baseRef = Offset.evaluateBaseRef(valueEvalArray[0]);
            int n3 = Offset.evaluateIntArg(valueEvalArray[1], n, n2);
            int n4 = Offset.evaluateIntArg(valueEvalArray[2], n, n2);
            int n5 = baseRef.getHeight();
            int n6 = baseRef.getWidth();
            switch (valueEvalArray.length) {
                case 5: {
                    n6 = Offset.evaluateIntArg(valueEvalArray[4], n, n2);
                }
                case 4: {
                    n5 = Offset.evaluateIntArg(valueEvalArray[3], n, n2);
                }
            }
            if (n5 == 0 || n6 == 0) {
                return ErrorEval.REF_INVALID;
            }
            LinearOffsetRange linearOffsetRange = new LinearOffsetRange(n3, n5);
            LinearOffsetRange linearOffsetRange2 = new LinearOffsetRange(n4, n6);
            return Offset.createOffset(baseRef, linearOffsetRange, linearOffsetRange2);
        }
        catch (EvaluationException evaluationException) {
            return evaluationException.getErrorEval();
        }
    }

    private static AreaEval createOffset(BaseRef baseRef, LinearOffsetRange linearOffsetRange, LinearOffsetRange linearOffsetRange2) throws EvaluationException {
        LinearOffsetRange linearOffsetRange3 = linearOffsetRange.normaliseAndTranslate(baseRef.getFirstRowIndex());
        LinearOffsetRange linearOffsetRange4 = linearOffsetRange2.normaliseAndTranslate(baseRef.getFirstColumnIndex());
        if (linearOffsetRange3.isOutOfBounds(0, 65535)) {
            throw new EvaluationException(ErrorEval.REF_INVALID);
        }
        if (linearOffsetRange4.isOutOfBounds(0, 255)) {
            throw new EvaluationException(ErrorEval.REF_INVALID);
        }
        return baseRef.offset(linearOffsetRange.getFirstIndex(), linearOffsetRange.getLastIndex(), linearOffsetRange2.getFirstIndex(), linearOffsetRange2.getLastIndex());
    }

    private static BaseRef evaluateBaseRef(ValueEval valueEval) throws EvaluationException {
        if (valueEval instanceof RefEval) {
            return new BaseRef((RefEval)valueEval);
        }
        if (valueEval instanceof AreaEval) {
            return new BaseRef((AreaEval)valueEval);
        }
        if (valueEval instanceof ErrorEval) {
            throw new EvaluationException((ErrorEval)valueEval);
        }
        throw new EvaluationException(ErrorEval.VALUE_INVALID);
    }

    static int evaluateIntArg(ValueEval valueEval, int n, int n2) throws EvaluationException {
        ValueEval valueEval2 = OperandResolver.getSingleValue(valueEval, n, n2);
        return OperandResolver.coerceValueToInt(valueEval2);
    }

    private static final class BaseRef {
        private final int _firstRowIndex;
        private final int _firstColumnIndex;
        private final int _width;
        private final int _height;
        private final RefEval _refEval;
        private final AreaEval _areaEval;

        public BaseRef(RefEval refEval) {
            this._refEval = refEval;
            this._areaEval = null;
            this._firstRowIndex = refEval.getRow();
            this._firstColumnIndex = refEval.getColumn();
            this._height = 1;
            this._width = 1;
        }

        public BaseRef(AreaEval areaEval) {
            this._refEval = null;
            this._areaEval = areaEval;
            this._firstRowIndex = areaEval.getFirstRow();
            this._firstColumnIndex = areaEval.getFirstColumn();
            this._height = areaEval.getLastRow() - areaEval.getFirstRow() + 1;
            this._width = areaEval.getLastColumn() - areaEval.getFirstColumn() + 1;
        }

        public int getWidth() {
            return this._width;
        }

        public int getHeight() {
            return this._height;
        }

        public int getFirstRowIndex() {
            return this._firstRowIndex;
        }

        public int getFirstColumnIndex() {
            return this._firstColumnIndex;
        }

        public AreaEval offset(int n, int n2, int n3, int n4) {
            if (this._refEval == null) {
                return this._areaEval.offset(n, n2, n3, n4);
            }
            return this._refEval.offset(n, n2, n3, n4);
        }
    }

    static final class LinearOffsetRange {
        private final int _offset;
        private final int _length;

        public LinearOffsetRange(int n, int n2) {
            if (n2 == 0) {
                throw new RuntimeException("length may not be zero");
            }
            this._offset = n;
            this._length = n2;
        }

        public short getFirstIndex() {
            return (short)this._offset;
        }

        public short getLastIndex() {
            return (short)(this._offset + this._length - 1);
        }

        public LinearOffsetRange normaliseAndTranslate(int n) {
            if (this._length > 0) {
                if (n == 0) {
                    return this;
                }
                return new LinearOffsetRange(n + this._offset, this._length);
            }
            return new LinearOffsetRange(n + this._offset + this._length + 1, -this._length);
        }

        public boolean isOutOfBounds(int n, int n2) {
            if (this._offset < n) {
                return true;
            }
            return this.getLastIndex() > n2;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(64);
            stringBuffer.append(this.getClass().getName()).append(" [");
            stringBuffer.append(this._offset).append("...").append(this.getLastIndex());
            stringBuffer.append("]");
            return stringBuffer.toString();
        }
    }
}

