/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.ss.formula.functions;

import ai.org.apache.poi.ss.formula.eval.ErrorEval;
import ai.org.apache.poi.ss.formula.eval.EvaluationException;
import ai.org.apache.poi.ss.formula.eval.NumberEval;
import ai.org.apache.poi.ss.formula.eval.ValueEval;
import ai.org.apache.poi.ss.formula.functions.AggregateFunction;
import ai.org.apache.poi.ss.formula.functions.FinanceLib;
import ai.org.apache.poi.ss.formula.functions.Function;
import ai.org.apache.poi.ss.formula.functions.NumericFunction;

public final class Npv
implements Function {
    public ValueEval evaluate(ValueEval[] valueEvalArray, int n, int n2) {
        int n3 = valueEvalArray.length;
        if (n3 < 2) {
            return ErrorEval.VALUE_INVALID;
        }
        try {
            double d = NumericFunction.singleOperandEvaluate(valueEvalArray[0], n, n2);
            ValueEval[] valueEvalArray2 = new ValueEval[valueEvalArray.length - 1];
            System.arraycopy(valueEvalArray, 1, valueEvalArray2, 0, valueEvalArray2.length);
            double[] dArray = AggregateFunction.ValueCollector.collectValues(valueEvalArray2);
            double d2 = FinanceLib.npv(d, dArray);
            NumericFunction.checkValue(d2);
            return new NumberEval(d2);
        }
        catch (EvaluationException evaluationException) {
            return evaluationException.getErrorEval();
        }
    }
}

