/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.ss.formula.functions;

import ai.org.apache.poi.ss.formula.TwoDEval;
import ai.org.apache.poi.ss.formula.eval.BlankEval;
import ai.org.apache.poi.ss.formula.eval.BoolEval;
import ai.org.apache.poi.ss.formula.eval.ErrorEval;
import ai.org.apache.poi.ss.formula.eval.EvaluationException;
import ai.org.apache.poi.ss.formula.eval.NumberEval;
import ai.org.apache.poi.ss.formula.eval.NumericValueEval;
import ai.org.apache.poi.ss.formula.eval.OperandResolver;
import ai.org.apache.poi.ss.formula.eval.RefEval;
import ai.org.apache.poi.ss.formula.eval.StringEval;
import ai.org.apache.poi.ss.formula.eval.ValueEval;
import ai.org.apache.poi.ss.formula.functions.Countif;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class LookupUtils {
    LookupUtils() {
    }

    public static ValueVector createRowVector(TwoDEval twoDEval, int n) {
        return new RowVector(twoDEval, n);
    }

    public static ValueVector createColumnVector(TwoDEval twoDEval, int n) {
        return new ColumnVector(twoDEval, n);
    }

    public static ValueVector createVector(TwoDEval twoDEval) {
        if (twoDEval.isColumn()) {
            return LookupUtils.createColumnVector(twoDEval, 0);
        }
        if (twoDEval.isRow()) {
            return LookupUtils.createRowVector(twoDEval, 0);
        }
        return null;
    }

    public static ValueVector createVector(RefEval refEval) {
        return new SheetVector(refEval);
    }

    public static int resolveRowOrColIndexArg(ValueEval valueEval, int n, int n2) throws EvaluationException {
        StringEval stringEval;
        String string;
        Double d;
        ValueEval valueEval2;
        if (valueEval == null) {
            throw new IllegalArgumentException("argument must not be null");
        }
        try {
            valueEval2 = OperandResolver.getSingleValue(valueEval, n, (short)n2);
        }
        catch (EvaluationException evaluationException) {
            throw EvaluationException.invalidRef();
        }
        if (valueEval2 instanceof StringEval && (d = OperandResolver.parseDouble(string = (stringEval = (StringEval)valueEval2).getStringValue())) == null) {
            throw EvaluationException.invalidRef();
        }
        int n3 = OperandResolver.coerceValueToInt(valueEval2);
        if (n3 < 1) {
            throw EvaluationException.invalidValue();
        }
        return n3 - 1;
    }

    public static TwoDEval resolveTableArrayArg(ValueEval valueEval) throws EvaluationException {
        if (valueEval instanceof TwoDEval) {
            return (TwoDEval)valueEval;
        }
        if (valueEval instanceof RefEval) {
            RefEval refEval = (RefEval)valueEval;
            return refEval.offset(0, 0, 0, 0);
        }
        throw EvaluationException.invalidValue();
    }

    public static boolean resolveRangeLookupArg(ValueEval valueEval, int n, int n2) throws EvaluationException {
        ValueEval valueEval2 = OperandResolver.getSingleValue(valueEval, n, n2);
        if (valueEval2 instanceof BlankEval) {
            return false;
        }
        if (valueEval2 instanceof BoolEval) {
            BoolEval boolEval = (BoolEval)valueEval2;
            return boolEval.getBooleanValue();
        }
        if (valueEval2 instanceof StringEval) {
            String string = ((StringEval)valueEval2).getStringValue();
            if (string.length() < 1) {
                throw EvaluationException.invalidValue();
            }
            Boolean bl = Countif.parseBoolean(string);
            if (bl != null) {
                return bl;
            }
            throw EvaluationException.invalidValue();
        }
        if (valueEval2 instanceof NumericValueEval) {
            NumericValueEval numericValueEval = (NumericValueEval)valueEval2;
            return 0.0 != numericValueEval.getNumberValue();
        }
        throw new RuntimeException("Unexpected eval type (" + valueEval2.getClass().getName() + ")");
    }

    public static int lookupIndexOfValue(ValueEval valueEval, ValueVector valueVector, boolean bl) throws EvaluationException {
        LookupValueComparer lookupValueComparer = LookupUtils.createLookupComparer(valueEval, bl, false);
        int n = bl ? LookupUtils.performBinarySearch(valueVector, lookupValueComparer) : LookupUtils.lookupIndexOfExactValue(lookupValueComparer, valueVector);
        if (n < 0) {
            throw new EvaluationException(ErrorEval.NA);
        }
        return n;
    }

    private static int lookupIndexOfExactValue(LookupValueComparer lookupValueComparer, ValueVector valueVector) {
        int n = valueVector.getSize();
        for (int i = 0; i < n; ++i) {
            if (!lookupValueComparer.compareTo(valueVector.getItem(i)).isEqual()) continue;
            return i;
        }
        return -1;
    }

    private static int performBinarySearch(ValueVector valueVector, LookupValueComparer lookupValueComparer) {
        BinarySearchIndexes binarySearchIndexes = new BinarySearchIndexes(valueVector.getSize());
        int n;
        while ((n = binarySearchIndexes.getMidIx()) >= 0) {
            CompareResult compareResult = lookupValueComparer.compareTo(valueVector.getItem(n));
            if (compareResult.isTypeMismatch()) {
                int n2 = LookupUtils.handleMidValueTypeMismatch(lookupValueComparer, valueVector, binarySearchIndexes, n);
                if (n2 < 0) continue;
                n = n2;
                compareResult = lookupValueComparer.compareTo(valueVector.getItem(n));
            }
            if (compareResult.isEqual()) {
                return LookupUtils.findLastIndexInRunOfEqualValues(lookupValueComparer, valueVector, n, binarySearchIndexes.getHighIx());
            }
            binarySearchIndexes.narrowSearch(n, compareResult.isLessThan());
        }
        return binarySearchIndexes.getLowIx();
    }

    private static int handleMidValueTypeMismatch(LookupValueComparer lookupValueComparer, ValueVector valueVector, BinarySearchIndexes binarySearchIndexes, int n) {
        CompareResult compareResult;
        int n2 = n;
        int n3 = binarySearchIndexes.getHighIx();
        do {
            if (++n2 == n3) {
                binarySearchIndexes.narrowSearch(n, true);
                return -1;
            }
            compareResult = lookupValueComparer.compareTo(valueVector.getItem(n2));
            if (!compareResult.isLessThan() || n2 != n3 - 1) continue;
            binarySearchIndexes.narrowSearch(n, true);
            return -1;
        } while (compareResult.isTypeMismatch());
        if (compareResult.isEqual()) {
            return n2;
        }
        binarySearchIndexes.narrowSearch(n2, compareResult.isLessThan());
        return -1;
    }

    private static int findLastIndexInRunOfEqualValues(LookupValueComparer lookupValueComparer, ValueVector valueVector, int n, int n2) {
        for (int i = n + 1; i < n2; ++i) {
            if (lookupValueComparer.compareTo(valueVector.getItem(i)).isEqual()) continue;
            return i - 1;
        }
        return n2 - 1;
    }

    public static LookupValueComparer createLookupComparer(ValueEval valueEval, boolean bl, boolean bl2) {
        if (valueEval == BlankEval.instance) {
            return new NumberLookupComparer(NumberEval.ZERO);
        }
        if (valueEval instanceof StringEval) {
            return new StringLookupComparer((StringEval)valueEval, bl, bl2);
        }
        if (valueEval instanceof NumberEval) {
            return new NumberLookupComparer((NumberEval)valueEval);
        }
        if (valueEval instanceof BoolEval) {
            return new BooleanLookupComparer((BoolEval)valueEval);
        }
        throw new IllegalArgumentException("Bad lookup value type (" + valueEval.getClass().getName() + ")");
    }

    private static final class BinarySearchIndexes {
        private int _lowIx = -1;
        private int _highIx;

        public BinarySearchIndexes(int n) {
            this._highIx = n;
        }

        public int getMidIx() {
            int n = this._highIx - this._lowIx;
            if (n < 2) {
                return -1;
            }
            return this._lowIx + n / 2;
        }

        public int getLowIx() {
            return this._lowIx;
        }

        public int getHighIx() {
            return this._highIx;
        }

        public void narrowSearch(int n, boolean bl) {
            if (bl) {
                this._highIx = n;
            } else {
                this._lowIx = n;
            }
        }
    }

    private static final class BooleanLookupComparer
    extends LookupValueComparerBase {
        private boolean _value;

        protected BooleanLookupComparer(BoolEval boolEval) {
            super(boolEval);
            this._value = boolEval.getBooleanValue();
        }

        protected CompareResult compareSameType(ValueEval valueEval) {
            BoolEval boolEval = (BoolEval)valueEval;
            boolean bl = boolEval.getBooleanValue();
            if (this._value == bl) {
                return CompareResult.EQUAL;
            }
            if (this._value) {
                return CompareResult.GREATER_THAN;
            }
            return CompareResult.LESS_THAN;
        }

        protected String getValueAsString() {
            return String.valueOf(this._value);
        }
    }

    private static final class NumberLookupComparer
    extends LookupValueComparerBase {
        private double _value;

        protected NumberLookupComparer(NumberEval numberEval) {
            super(numberEval);
            this._value = numberEval.getNumberValue();
        }

        protected CompareResult compareSameType(ValueEval valueEval) {
            NumberEval numberEval = (NumberEval)valueEval;
            return CompareResult.valueOf(Double.compare(this._value, numberEval.getNumberValue()));
        }

        protected String getValueAsString() {
            return String.valueOf(this._value);
        }
    }

    private static final class StringLookupComparer
    extends LookupValueComparerBase {
        private String _value;
        private final Pattern _wildCardPattern;
        private boolean _matchExact;
        private boolean _isMatchFunction;

        protected StringLookupComparer(StringEval stringEval, boolean bl, boolean bl2) {
            super(stringEval);
            this._value = stringEval.getStringValue();
            this._wildCardPattern = Countif.StringMatcher.getWildCardPattern(this._value);
            this._matchExact = bl;
            this._isMatchFunction = bl2;
        }

        protected CompareResult compareSameType(ValueEval valueEval) {
            StringEval stringEval = (StringEval)valueEval;
            String string = stringEval.getStringValue();
            if (this._wildCardPattern != null) {
                Matcher matcher = this._wildCardPattern.matcher(string);
                boolean bl = matcher.matches();
                if (this._isMatchFunction || !this._matchExact) {
                    return CompareResult.valueOf(bl);
                }
            }
            return CompareResult.valueOf(this._value.compareToIgnoreCase(string));
        }

        protected String getValueAsString() {
            return this._value;
        }
    }

    private static abstract class LookupValueComparerBase
    implements LookupValueComparer {
        private final Class<? extends ValueEval> _targetClass;

        protected LookupValueComparerBase(ValueEval valueEval) {
            if (valueEval == null) {
                throw new RuntimeException("targetValue cannot be null");
            }
            this._targetClass = valueEval.getClass();
        }

        public final CompareResult compareTo(ValueEval valueEval) {
            if (valueEval == null) {
                throw new RuntimeException("compare to value cannot be null");
            }
            if (this._targetClass != valueEval.getClass()) {
                return CompareResult.TYPE_MISMATCH;
            }
            return this.compareSameType(valueEval);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(64);
            stringBuffer.append(this.getClass().getName()).append(" [");
            stringBuffer.append(this.getValueAsString());
            stringBuffer.append("]");
            return stringBuffer.toString();
        }

        protected abstract CompareResult compareSameType(ValueEval var1);

        protected abstract String getValueAsString();
    }

    public static interface LookupValueComparer {
        public CompareResult compareTo(ValueEval var1);
    }

    public static final class CompareResult {
        private final boolean _isTypeMismatch;
        private final boolean _isLessThan;
        private final boolean _isEqual;
        private final boolean _isGreaterThan;
        public static final CompareResult TYPE_MISMATCH = new CompareResult(true, 0);
        public static final CompareResult LESS_THAN = new CompareResult(false, -1);
        public static final CompareResult EQUAL = new CompareResult(false, 0);
        public static final CompareResult GREATER_THAN = new CompareResult(false, 1);

        private CompareResult(boolean bl, int n) {
            if (bl) {
                this._isTypeMismatch = true;
                this._isLessThan = false;
                this._isEqual = false;
                this._isGreaterThan = false;
            } else {
                this._isTypeMismatch = false;
                this._isLessThan = n < 0;
                this._isEqual = n == 0;
                this._isGreaterThan = n > 0;
            }
        }

        public static final CompareResult valueOf(int n) {
            if (n < 0) {
                return LESS_THAN;
            }
            if (n > 0) {
                return GREATER_THAN;
            }
            return EQUAL;
        }

        public static final CompareResult valueOf(boolean bl) {
            if (bl) {
                return EQUAL;
            }
            return LESS_THAN;
        }

        public boolean isTypeMismatch() {
            return this._isTypeMismatch;
        }

        public boolean isLessThan() {
            return this._isLessThan;
        }

        public boolean isEqual() {
            return this._isEqual;
        }

        public boolean isGreaterThan() {
            return this._isGreaterThan;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(64);
            stringBuffer.append(this.getClass().getName()).append(" [");
            stringBuffer.append(this.formatAsString());
            stringBuffer.append("]");
            return stringBuffer.toString();
        }

        private String formatAsString() {
            if (this._isTypeMismatch) {
                return "TYPE_MISMATCH";
            }
            if (this._isLessThan) {
                return "LESS_THAN";
            }
            if (this._isEqual) {
                return "EQUAL";
            }
            if (this._isGreaterThan) {
                return "GREATER_THAN";
            }
            return "??error??";
        }
    }

    private static final class SheetVector
    implements ValueVector {
        private final RefEval _re;
        private final int _size;

        public SheetVector(RefEval refEval) {
            this._size = refEval.getNumberOfSheets();
            this._re = refEval;
        }

        public ValueEval getItem(int n) {
            if (n >= this._size) {
                throw new ArrayIndexOutOfBoundsException("Specified index (" + n + ") is outside the allowed range (0.." + (this._size - 1) + ")");
            }
            int n2 = this._re.getFirstSheetIndex() + n;
            return this._re.getInnerValueEval(n2);
        }

        public int getSize() {
            return this._size;
        }
    }

    private static final class ColumnVector
    implements ValueVector {
        private final TwoDEval _tableArray;
        private final int _size;
        private final int _columnIndex;

        public ColumnVector(TwoDEval twoDEval, int n) {
            this._columnIndex = n;
            int n2 = twoDEval.getWidth() - 1;
            if (n < 0 || n > n2) {
                throw new IllegalArgumentException("Specified column index (" + n + ") is outside the allowed range (0.." + n2 + ")");
            }
            this._tableArray = twoDEval;
            this._size = this._tableArray.getHeight();
        }

        public ValueEval getItem(int n) {
            if (n > this._size) {
                throw new ArrayIndexOutOfBoundsException("Specified index (" + n + ") is outside the allowed range (0.." + (this._size - 1) + ")");
            }
            return this._tableArray.getValue(n, this._columnIndex);
        }

        public int getSize() {
            return this._size;
        }
    }

    private static final class RowVector
    implements ValueVector {
        private final TwoDEval _tableArray;
        private final int _size;
        private final int _rowIndex;

        public RowVector(TwoDEval twoDEval, int n) {
            this._rowIndex = n;
            int n2 = twoDEval.getHeight() - 1;
            if (n < 0 || n > n2) {
                throw new IllegalArgumentException("Specified row index (" + n + ") is outside the allowed range (0.." + n2 + ")");
            }
            this._tableArray = twoDEval;
            this._size = twoDEval.getWidth();
        }

        public ValueEval getItem(int n) {
            if (n > this._size) {
                throw new ArrayIndexOutOfBoundsException("Specified index (" + n + ") is outside the allowed range (0.." + (this._size - 1) + ")");
            }
            return this._tableArray.getValue(this._rowIndex, n);
        }

        public int getSize() {
            return this._size;
        }
    }

    public static interface ValueVector {
        public ValueEval getItem(int var1);

        public int getSize();
    }
}

