/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.ss.formula.functions;

import ai.org.apache.poi.ss.formula.eval.ErrorEval;
import ai.org.apache.poi.ss.formula.eval.EvaluationException;
import ai.org.apache.poi.ss.formula.eval.NumberEval;
import ai.org.apache.poi.ss.formula.eval.ValueEval;
import ai.org.apache.poi.ss.formula.functions.AggregateFunction;
import ai.org.apache.poi.ss.formula.functions.Function;
import ai.org.apache.poi.ss.formula.functions.NumericFunction;

public final class Irr
implements Function {
    public ValueEval evaluate(ValueEval[] valueEvalArray, int n, int n2) {
        if (valueEvalArray.length == 0 || valueEvalArray.length > 2) {
            return ErrorEval.VALUE_INVALID;
        }
        try {
            double[] dArray = AggregateFunction.ValueCollector.collectValues(valueEvalArray[0]);
            double d = valueEvalArray.length == 2 ? NumericFunction.singleOperandEvaluate(valueEvalArray[1], n, n2) : 0.1;
            double d2 = Irr.irr(dArray, d);
            NumericFunction.checkValue(d2);
            return new NumberEval(d2);
        }
        catch (EvaluationException evaluationException) {
            return evaluationException.getErrorEval();
        }
    }

    public static double irr(double[] dArray) {
        return Irr.irr(dArray, 0.1);
    }

    public static double irr(double[] dArray, double d) {
        int n = 20;
        double d2 = 1.0E-7;
        double d3 = d;
        for (int i = 0; i < n; ++i) {
            double d4 = 0.0;
            double d5 = 0.0;
            for (int j = 0; j < dArray.length; ++j) {
                d4 += dArray[j] / Math.pow(1.0 + d3, j);
                d5 += (double)(-j) * dArray[j] / Math.pow(1.0 + d3, j + 1);
            }
            double d6 = d3 - d4 / d5;
            if (Math.abs(d6 - d3) <= d2) {
                return d6;
            }
            d3 = d6;
        }
        return Double.NaN;
    }
}

