/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.ss.formula.functions;

import ai.org.apache.poi.ss.formula.OperationEvaluationContext;
import ai.org.apache.poi.ss.formula.eval.ErrorEval;
import ai.org.apache.poi.ss.formula.eval.EvaluationException;
import ai.org.apache.poi.ss.formula.eval.NumberEval;
import ai.org.apache.poi.ss.formula.eval.OperandResolver;
import ai.org.apache.poi.ss.formula.eval.ValueEval;
import ai.org.apache.poi.ss.formula.functions.Fixed1ArgFunction;
import ai.org.apache.poi.ss.formula.functions.FreeRefFunction;
import java.math.BigInteger;
import java.util.HashMap;

public class FactDouble
extends Fixed1ArgFunction
implements FreeRefFunction {
    public static final FreeRefFunction instance = new FactDouble();
    static HashMap<Integer, BigInteger> cache = new HashMap();

    public ValueEval evaluate(int n, int n2, ValueEval valueEval) {
        int n3;
        try {
            n3 = OperandResolver.coerceValueToInt(valueEval);
        }
        catch (EvaluationException evaluationException) {
            return ErrorEval.VALUE_INVALID;
        }
        if (n3 < 0) {
            return ErrorEval.NUM_ERROR;
        }
        return new NumberEval(FactDouble.factorial(n3).longValue());
    }

    public static BigInteger factorial(int n) {
        if (n == 0 || n < 0) {
            return BigInteger.ONE;
        }
        if (cache.containsKey(n)) {
            return cache.get(n);
        }
        BigInteger bigInteger = BigInteger.valueOf(n).multiply(FactDouble.factorial(n - 2));
        cache.put(n, bigInteger);
        return bigInteger;
    }

    public ValueEval evaluate(ValueEval[] valueEvalArray, OperationEvaluationContext operationEvaluationContext) {
        if (valueEvalArray.length != 1) {
            return ErrorEval.VALUE_INVALID;
        }
        return this.evaluate(operationEvaluationContext.getRowIndex(), operationEvaluationContext.getColumnIndex(), valueEvalArray[0]);
    }
}

