/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.ss.formula.functions;

import ai.org.apache.poi.ss.formula.eval.ErrorEval;
import ai.org.apache.poi.ss.formula.eval.EvaluationException;
import ai.org.apache.poi.ss.formula.eval.NumberEval;
import ai.org.apache.poi.ss.formula.eval.OperandResolver;
import ai.org.apache.poi.ss.formula.eval.ValueEval;
import ai.org.apache.poi.ss.formula.functions.Fixed1ArgFunction;

public final class Errortype
extends Fixed1ArgFunction {
    public ValueEval evaluate(int n, int n2, ValueEval valueEval) {
        try {
            OperandResolver.getSingleValue(valueEval, n, n2);
            return ErrorEval.NA;
        }
        catch (EvaluationException evaluationException) {
            int n3 = this.translateErrorCodeToErrorTypeValue(evaluationException.getErrorEval().getErrorCode());
            return new NumberEval(n3);
        }
    }

    private int translateErrorCodeToErrorTypeValue(int n) {
        switch (n) {
            case 0: {
                return 1;
            }
            case 7: {
                return 2;
            }
            case 15: {
                return 3;
            }
            case 23: {
                return 4;
            }
            case 29: {
                return 5;
            }
            case 36: {
                return 6;
            }
            case 42: {
                return 7;
            }
        }
        throw new IllegalArgumentException("Invalid error code (" + n + ")");
    }
}

