/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.ss.formula.functions;

import ai.org.apache.poi.ss.formula.eval.EvaluationException;
import ai.org.apache.poi.ss.formula.eval.NumberEval;
import ai.org.apache.poi.ss.formula.eval.OperandResolver;
import ai.org.apache.poi.ss.formula.eval.ValueEval;
import ai.org.apache.poi.ss.formula.functions.NumericFunction;
import ai.org.apache.poi.ss.formula.functions.Var2or3ArgFunction;
import ai.org.apache.poi.ss.usermodel.DateUtil;
import java.util.Calendar;
import java.util.GregorianCalendar;

public class Days360
extends Var2or3ArgFunction {
    public ValueEval evaluate(int n, int n2, ValueEval valueEval, ValueEval valueEval2) {
        double d;
        try {
            double d2 = NumericFunction.singleOperandEvaluate(valueEval, n, n2);
            double d3 = NumericFunction.singleOperandEvaluate(valueEval2, n, n2);
            d = Days360.evaluate(d2, d3, false);
        }
        catch (EvaluationException evaluationException) {
            return evaluationException.getErrorEval();
        }
        return new NumberEval(d);
    }

    public ValueEval evaluate(int n, int n2, ValueEval valueEval, ValueEval valueEval2, ValueEval valueEval3) {
        double d;
        try {
            double d2 = NumericFunction.singleOperandEvaluate(valueEval, n, n2);
            double d3 = NumericFunction.singleOperandEvaluate(valueEval2, n, n2);
            ValueEval valueEval4 = OperandResolver.getSingleValue(valueEval3, n, n2);
            Boolean bl = OperandResolver.coerceValueToBoolean(valueEval4, false);
            d = Days360.evaluate(d2, d3, bl == null ? false : bl);
        }
        catch (EvaluationException evaluationException) {
            return evaluationException.getErrorEval();
        }
        return new NumberEval(d);
    }

    private static double evaluate(double d, double d2, boolean bl) {
        Calendar calendar = Days360.getStartingDate(d);
        Calendar calendar2 = Days360.getEndingDateAccordingToStartingDate(d2, calendar);
        long l = calendar.get(2) * 30 + calendar.get(5);
        long l2 = (calendar2.get(1) - calendar.get(1)) * 360 + calendar2.get(2) * 30 + calendar2.get(5);
        return l2 - l;
    }

    private static Calendar getDate(double d) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(DateUtil.getJavaDate(d, false));
        return gregorianCalendar;
    }

    private static Calendar getStartingDate(double d) {
        Calendar calendar = Days360.getDate(d);
        if (Days360.isLastDayOfMonth(calendar)) {
            calendar.set(5, 30);
        }
        return calendar;
    }

    private static Calendar getEndingDateAccordingToStartingDate(double d, Calendar calendar) {
        Calendar calendar2 = Days360.getDate(d);
        calendar2.setTime(DateUtil.getJavaDate(d, false));
        if (Days360.isLastDayOfMonth(calendar2) && calendar.get(5) < 30) {
            calendar2 = Days360.getFirstDayOfNextMonth(calendar2);
        }
        return calendar2;
    }

    private static boolean isLastDayOfMonth(Calendar calendar) {
        Calendar calendar2 = (Calendar)calendar.clone();
        calendar2.add(2, 1);
        calendar2.add(5, -1);
        int n = calendar2.get(5);
        return calendar.get(5) == n;
    }

    private static Calendar getFirstDayOfNextMonth(Calendar calendar) {
        Calendar calendar2 = (Calendar)calendar.clone();
        if (calendar.get(2) < 11) {
            calendar2.set(2, calendar.get(2) + 1);
        } else {
            calendar2.set(2, 1);
            calendar2.set(1, calendar.get(1) + 1);
        }
        calendar2.set(5, 1);
        return calendar2;
    }
}

