/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.ss.formula.functions;

import ai.org.apache.poi.ss.formula.eval.ErrorEval;
import ai.org.apache.poi.ss.formula.eval.EvaluationException;
import ai.org.apache.poi.ss.formula.eval.NumberEval;
import ai.org.apache.poi.ss.formula.eval.OperandResolver;
import ai.org.apache.poi.ss.formula.eval.ValueEval;
import ai.org.apache.poi.ss.formula.functions.Fixed2ArgFunction;
import ai.org.apache.poi.ss.formula.functions.Function;
import ai.org.apache.poi.ss.formula.functions.MathX;
import ai.org.apache.poi.ss.formula.functions.MultiOperandNumericFunction;
import ai.org.apache.poi.ss.formula.functions.NumericFunction;
import ai.org.apache.poi.ss.formula.functions.StatsLib;

public abstract class AggregateFunction
extends MultiOperandNumericFunction {
    public static final Function AVEDEV = new AggregateFunction(){

        protected double evaluate(double[] dArray) {
            return StatsLib.avedev(dArray);
        }
    };
    public static final Function AVERAGE = new AggregateFunction(){

        protected double evaluate(double[] dArray) throws EvaluationException {
            if (dArray.length < 1) {
                throw new EvaluationException(ErrorEval.DIV_ZERO);
            }
            return MathX.average(dArray);
        }
    };
    public static final Function DEVSQ = new AggregateFunction(){

        protected double evaluate(double[] dArray) {
            return StatsLib.devsq(dArray);
        }
    };
    public static final Function LARGE = new LargeSmall(true);
    public static final Function MAX = new AggregateFunction(){

        protected double evaluate(double[] dArray) {
            return dArray.length > 0 ? MathX.max(dArray) : 0.0;
        }
    };
    public static final Function MEDIAN = new AggregateFunction(){

        protected double evaluate(double[] dArray) {
            return StatsLib.median(dArray);
        }
    };
    public static final Function MIN = new AggregateFunction(){

        protected double evaluate(double[] dArray) {
            return dArray.length > 0 ? MathX.min(dArray) : 0.0;
        }
    };
    public static final Function PERCENTILE = new Percentile();
    public static final Function PRODUCT = new AggregateFunction(){

        protected double evaluate(double[] dArray) {
            return MathX.product(dArray);
        }
    };
    public static final Function SMALL = new LargeSmall(false);
    public static final Function STDEV = new AggregateFunction(){

        protected double evaluate(double[] dArray) throws EvaluationException {
            if (dArray.length < 1) {
                throw new EvaluationException(ErrorEval.DIV_ZERO);
            }
            return StatsLib.stdev(dArray);
        }
    };
    public static final Function SUM = new AggregateFunction(){

        protected double evaluate(double[] dArray) {
            return MathX.sum(dArray);
        }
    };
    public static final Function SUMSQ = new AggregateFunction(){

        protected double evaluate(double[] dArray) {
            return MathX.sumsq(dArray);
        }
    };
    public static final Function VAR = new AggregateFunction(){

        protected double evaluate(double[] dArray) throws EvaluationException {
            if (dArray.length < 1) {
                throw new EvaluationException(ErrorEval.DIV_ZERO);
            }
            return StatsLib.var(dArray);
        }
    };
    public static final Function VARP = new AggregateFunction(){

        protected double evaluate(double[] dArray) throws EvaluationException {
            if (dArray.length < 1) {
                throw new EvaluationException(ErrorEval.DIV_ZERO);
            }
            return StatsLib.varp(dArray);
        }
    };

    protected AggregateFunction() {
        super(false, false);
    }

    static Function subtotalInstance(Function function) {
        final AggregateFunction aggregateFunction = (AggregateFunction)function;
        return new AggregateFunction(){

            protected double evaluate(double[] dArray) throws EvaluationException {
                return aggregateFunction.evaluate(dArray);
            }

            public boolean isSubtotalCounted() {
                return false;
            }
        };
    }

    static final class ValueCollector
    extends MultiOperandNumericFunction {
        private static final ValueCollector instance = new ValueCollector();

        public ValueCollector() {
            super(false, false);
        }

        public static double[] collectValues(ValueEval ... valueEvalArray) throws EvaluationException {
            return instance.getNumberArray(valueEvalArray);
        }

        protected double evaluate(double[] dArray) {
            throw new IllegalStateException("should not be called");
        }
    }

    private static final class Percentile
    extends Fixed2ArgFunction {
        protected Percentile() {
        }

        public ValueEval evaluate(int n, int n2, ValueEval valueEval, ValueEval valueEval2) {
            double d;
            double d2;
            try {
                ValueEval valueEval3 = OperandResolver.getSingleValue(valueEval2, n, n2);
                d2 = OperandResolver.coerceValueToDouble(valueEval3);
            }
            catch (EvaluationException evaluationException) {
                return ErrorEval.VALUE_INVALID;
            }
            if (d2 < 0.0 || d2 > 1.0) {
                return ErrorEval.NUM_ERROR;
            }
            try {
                double[] dArray = ValueCollector.collectValues(valueEval);
                int n3 = dArray.length;
                if (n3 == 0 || n3 > 8191) {
                    return ErrorEval.NUM_ERROR;
                }
                double d3 = (double)(n3 - 1) * d2 + 1.0;
                if (d3 == 1.0) {
                    d = StatsLib.kthSmallest(dArray, 1);
                } else if (d3 == (double)n3) {
                    d = StatsLib.kthLargest(dArray, 1);
                } else {
                    int n4 = (int)d3;
                    double d4 = d3 - (double)n4;
                    d = StatsLib.kthSmallest(dArray, n4) + d4 * (StatsLib.kthSmallest(dArray, n4 + 1) - StatsLib.kthSmallest(dArray, n4));
                }
                NumericFunction.checkValue(d);
            }
            catch (EvaluationException evaluationException) {
                return evaluationException.getErrorEval();
            }
            return new NumberEval(d);
        }
    }

    private static final class LargeSmall
    extends Fixed2ArgFunction {
        private final boolean _isLarge;

        protected LargeSmall(boolean bl) {
            this._isLarge = bl;
        }

        public ValueEval evaluate(int n, int n2, ValueEval valueEval, ValueEval valueEval2) {
            double d;
            double d2;
            try {
                ValueEval valueEval3 = OperandResolver.getSingleValue(valueEval2, n, n2);
                d2 = OperandResolver.coerceValueToDouble(valueEval3);
            }
            catch (EvaluationException evaluationException) {
                return ErrorEval.VALUE_INVALID;
            }
            if (d2 < 1.0) {
                return ErrorEval.NUM_ERROR;
            }
            int n3 = (int)Math.ceil(d2);
            try {
                double[] dArray = ValueCollector.collectValues(valueEval);
                if (n3 > dArray.length) {
                    return ErrorEval.NUM_ERROR;
                }
                d = this._isLarge ? StatsLib.kthLargest(dArray, n3) : StatsLib.kthSmallest(dArray, n3);
                NumericFunction.checkValue(d);
            }
            catch (EvaluationException evaluationException) {
                return evaluationException.getErrorEval();
            }
            return new NumberEval(d);
        }
    }
}

