/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.ss.formula.eval.forked;

import ai.org.apache.poi.ss.formula.EvaluationCell;
import ai.org.apache.poi.ss.formula.EvaluationSheet;
import ai.org.apache.poi.ss.formula.EvaluationWorkbook;
import ai.org.apache.poi.ss.formula.eval.forked.ForkedEvaluationCell;
import ai.org.apache.poi.ss.usermodel.Cell;
import ai.org.apache.poi.ss.usermodel.Row;
import ai.org.apache.poi.ss.usermodel.Sheet;
import ai.org.apache.poi.ss.util.CellReference;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

final class ForkedEvaluationSheet
implements EvaluationSheet {
    private final EvaluationSheet _masterSheet;
    private final Map<RowColKey, ForkedEvaluationCell> _sharedCellsByRowCol;

    public ForkedEvaluationSheet(EvaluationSheet evaluationSheet) {
        this._masterSheet = evaluationSheet;
        this._sharedCellsByRowCol = new HashMap<RowColKey, ForkedEvaluationCell>();
    }

    public EvaluationCell getCell(int n, int n2) {
        RowColKey rowColKey = new RowColKey(n, n2);
        ForkedEvaluationCell forkedEvaluationCell = this._sharedCellsByRowCol.get(rowColKey);
        if (forkedEvaluationCell == null) {
            return this._masterSheet.getCell(n, n2);
        }
        return forkedEvaluationCell;
    }

    public ForkedEvaluationCell getOrCreateUpdatableCell(int n, int n2) {
        RowColKey rowColKey = new RowColKey(n, n2);
        ForkedEvaluationCell forkedEvaluationCell = this._sharedCellsByRowCol.get(rowColKey);
        if (forkedEvaluationCell == null) {
            EvaluationCell evaluationCell = this._masterSheet.getCell(n, n2);
            if (evaluationCell == null) {
                CellReference cellReference = new CellReference(n, n2);
                throw new UnsupportedOperationException("Underlying cell '" + cellReference.formatAsString() + "' is missing in master sheet.");
            }
            forkedEvaluationCell = new ForkedEvaluationCell(this, evaluationCell);
            this._sharedCellsByRowCol.put(rowColKey, forkedEvaluationCell);
        }
        return forkedEvaluationCell;
    }

    public void copyUpdatedCells(Sheet sheet) {
        Object[] objectArray = new RowColKey[this._sharedCellsByRowCol.size()];
        this._sharedCellsByRowCol.keySet().toArray(objectArray);
        Arrays.sort(objectArray);
        for (int i = 0; i < objectArray.length; ++i) {
            Cell cell;
            Object object = objectArray[i];
            Row row = sheet.getRow(((RowColKey)object).getRowIndex());
            if (row == null) {
                row = sheet.createRow(((RowColKey)object).getRowIndex());
            }
            if ((cell = row.getCell(((RowColKey)object).getColumnIndex())) == null) {
                cell = row.createCell(((RowColKey)object).getColumnIndex());
            }
            ForkedEvaluationCell forkedEvaluationCell = this._sharedCellsByRowCol.get(object);
            forkedEvaluationCell.copyValue(cell);
        }
    }

    public int getSheetIndex(EvaluationWorkbook evaluationWorkbook) {
        return evaluationWorkbook.getSheetIndex(this._masterSheet);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class RowColKey
    implements Comparable<RowColKey> {
        private final int _rowIndex;
        private final int _columnIndex;

        public RowColKey(int n, int n2) {
            this._rowIndex = n;
            this._columnIndex = n2;
        }

        public boolean equals(Object object) {
            assert (object instanceof RowColKey) : "these private cache key instances are only compared to themselves";
            RowColKey rowColKey = (RowColKey)object;
            return this._rowIndex == rowColKey._rowIndex && this._columnIndex == rowColKey._columnIndex;
        }

        public int hashCode() {
            return this._rowIndex ^ this._columnIndex;
        }

        @Override
        public int compareTo(RowColKey rowColKey) {
            int n = this._rowIndex - rowColKey._rowIndex;
            if (n != 0) {
                return n;
            }
            return this._columnIndex - rowColKey._columnIndex;
        }

        public int getRowIndex() {
            return this._rowIndex;
        }

        public int getColumnIndex() {
            return this._columnIndex;
        }
    }
}

