/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.ss.formula.eval;

import ai.org.apache.poi.ss.formula.SheetRange;
import ai.org.apache.poi.ss.formula.eval.RefEval;

public abstract class RefEvalBase
implements RefEval {
    private final int _firstSheetIndex;
    private final int _lastSheetIndex;
    private final int _rowIndex;
    private final int _columnIndex;

    protected RefEvalBase(SheetRange sheetRange, int n, int n2) {
        if (sheetRange == null) {
            throw new IllegalArgumentException("sheetRange must not be null");
        }
        this._firstSheetIndex = sheetRange.getFirstSheetIndex();
        this._lastSheetIndex = sheetRange.getLastSheetIndex();
        this._rowIndex = n;
        this._columnIndex = n2;
    }

    protected RefEvalBase(int n, int n2, int n3, int n4) {
        this._firstSheetIndex = n;
        this._lastSheetIndex = n2;
        this._rowIndex = n3;
        this._columnIndex = n4;
    }

    protected RefEvalBase(int n, int n2, int n3) {
        this(n, n, n2, n3);
    }

    public int getNumberOfSheets() {
        return this._lastSheetIndex - this._firstSheetIndex + 1;
    }

    public int getFirstSheetIndex() {
        return this._firstSheetIndex;
    }

    public int getLastSheetIndex() {
        return this._lastSheetIndex;
    }

    public final int getRow() {
        return this._rowIndex;
    }

    public final int getColumn() {
        return this._columnIndex;
    }
}

