/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.ss.formula.eval;

import ai.org.apache.poi.ss.formula.eval.AreaEval;
import ai.org.apache.poi.ss.formula.eval.BlankEval;
import ai.org.apache.poi.ss.formula.eval.BoolEval;
import ai.org.apache.poi.ss.formula.eval.ErrorEval;
import ai.org.apache.poi.ss.formula.eval.EvaluationException;
import ai.org.apache.poi.ss.formula.eval.NumericValueEval;
import ai.org.apache.poi.ss.formula.eval.RefEval;
import ai.org.apache.poi.ss.formula.eval.StringEval;
import ai.org.apache.poi.ss.formula.eval.StringValueEval;
import ai.org.apache.poi.ss.formula.eval.ValueEval;
import java.util.regex.Pattern;

public final class OperandResolver {
    private static final String Digits = "(\\p{Digit}+)";
    private static final String Exp = "[eE][+-]?(\\p{Digit}+)";
    private static final String fpRegex = "[\\x00-\\x20]*[+-]?(((((\\p{Digit}+)(\\.)?((\\p{Digit}+)?)([eE][+-]?(\\p{Digit}+))?)|(\\.((\\p{Digit}+))([eE][+-]?(\\p{Digit}+))?))))[\\x00-\\x20]*";

    private OperandResolver() {
    }

    public static ValueEval getSingleValue(ValueEval valueEval, int n, int n2) throws EvaluationException {
        ValueEval valueEval2 = valueEval instanceof RefEval ? OperandResolver.chooseSingleElementFromRef((RefEval)valueEval) : (valueEval instanceof AreaEval ? OperandResolver.chooseSingleElementFromArea((AreaEval)valueEval, n, n2) : valueEval);
        if (valueEval2 instanceof ErrorEval) {
            throw new EvaluationException((ErrorEval)valueEval2);
        }
        return valueEval2;
    }

    public static ValueEval chooseSingleElementFromArea(AreaEval areaEval, int n, int n2) throws EvaluationException {
        ValueEval valueEval = OperandResolver.chooseSingleElementFromAreaInternal(areaEval, n, n2);
        if (valueEval instanceof ErrorEval) {
            throw new EvaluationException((ErrorEval)valueEval);
        }
        return valueEval;
    }

    private static ValueEval chooseSingleElementFromAreaInternal(AreaEval areaEval, int n, int n2) throws EvaluationException {
        if (areaEval.isColumn()) {
            if (areaEval.isRow()) {
                return areaEval.getRelativeValue(0, 0);
            }
            if (!areaEval.containsRow(n)) {
                throw EvaluationException.invalidValue();
            }
            return areaEval.getAbsoluteValue(n, areaEval.getFirstColumn());
        }
        if (!areaEval.isRow()) {
            if (areaEval.containsRow(n) && areaEval.containsColumn(n2)) {
                return areaEval.getAbsoluteValue(areaEval.getFirstRow(), areaEval.getFirstColumn());
            }
            throw EvaluationException.invalidValue();
        }
        if (!areaEval.containsColumn(n2)) {
            throw EvaluationException.invalidValue();
        }
        return areaEval.getAbsoluteValue(areaEval.getFirstRow(), n2);
    }

    private static ValueEval chooseSingleElementFromRef(RefEval refEval) {
        return refEval.getInnerValueEval(refEval.getFirstSheetIndex());
    }

    public static int coerceValueToInt(ValueEval valueEval) throws EvaluationException {
        if (valueEval == BlankEval.instance) {
            return 0;
        }
        double d = OperandResolver.coerceValueToDouble(valueEval);
        return (int)Math.floor(d);
    }

    public static double coerceValueToDouble(ValueEval valueEval) throws EvaluationException {
        if (valueEval == BlankEval.instance) {
            return 0.0;
        }
        if (valueEval instanceof NumericValueEval) {
            return ((NumericValueEval)valueEval).getNumberValue();
        }
        if (valueEval instanceof StringEval) {
            Double d = OperandResolver.parseDouble(((StringEval)valueEval).getStringValue());
            if (d == null) {
                throw EvaluationException.invalidValue();
            }
            return d;
        }
        throw new RuntimeException("Unexpected arg eval type (" + valueEval.getClass().getName() + ")");
    }

    public static Double parseDouble(String string) {
        if (Pattern.matches(fpRegex, string)) {
            try {
                return Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        return null;
    }

    public static String coerceValueToString(ValueEval valueEval) {
        if (valueEval instanceof StringValueEval) {
            StringValueEval stringValueEval = (StringValueEval)valueEval;
            return stringValueEval.getStringValue();
        }
        if (valueEval == BlankEval.instance) {
            return "";
        }
        throw new IllegalArgumentException("Unexpected eval class (" + valueEval.getClass().getName() + ")");
    }

    public static Boolean coerceValueToBoolean(ValueEval valueEval, boolean bl) throws EvaluationException {
        if (valueEval == null || valueEval == BlankEval.instance) {
            return null;
        }
        if (valueEval instanceof BoolEval) {
            return ((BoolEval)valueEval).getBooleanValue();
        }
        if (valueEval == BlankEval.instance) {
            return null;
        }
        if (valueEval instanceof StringEval) {
            if (bl) {
                return null;
            }
            String string = ((StringEval)valueEval).getStringValue();
            if (string.equalsIgnoreCase("true")) {
                return Boolean.TRUE;
            }
            if (string.equalsIgnoreCase("false")) {
                return Boolean.FALSE;
            }
            throw new EvaluationException(ErrorEval.VALUE_INVALID);
        }
        if (valueEval instanceof NumericValueEval) {
            NumericValueEval numericValueEval = (NumericValueEval)valueEval;
            double d = numericValueEval.getNumberValue();
            if (Double.isNaN(d)) {
                throw new EvaluationException(ErrorEval.VALUE_INVALID);
            }
            return d != 0.0;
        }
        if (valueEval instanceof ErrorEval) {
            throw new EvaluationException((ErrorEval)valueEval);
        }
        throw new RuntimeException("Unexpected eval (" + valueEval.getClass().getName() + ")");
    }
}

