/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.ss.formula.eval;

import ai.org.apache.poi.ss.formula.eval.AreaEval;
import ai.org.apache.poi.ss.formula.eval.ErrorEval;
import ai.org.apache.poi.ss.formula.eval.EvaluationException;
import ai.org.apache.poi.ss.formula.eval.RefEval;
import ai.org.apache.poi.ss.formula.eval.ValueEval;
import ai.org.apache.poi.ss.formula.functions.Fixed2ArgFunction;
import ai.org.apache.poi.ss.formula.functions.Function;

public final class IntersectionEval
extends Fixed2ArgFunction {
    public static final Function instance = new IntersectionEval();

    private IntersectionEval() {
    }

    public ValueEval evaluate(int n, int n2, ValueEval valueEval, ValueEval valueEval2) {
        try {
            AreaEval areaEval = IntersectionEval.evaluateRef(valueEval);
            AreaEval areaEval2 = IntersectionEval.evaluateRef(valueEval2);
            AreaEval areaEval3 = IntersectionEval.resolveRange(areaEval, areaEval2);
            if (areaEval3 == null) {
                return ErrorEval.NULL_INTERSECTION;
            }
            return areaEval3;
        }
        catch (EvaluationException evaluationException) {
            return evaluationException.getErrorEval();
        }
    }

    private static AreaEval resolveRange(AreaEval areaEval, AreaEval areaEval2) {
        int n;
        int n2;
        int n3 = areaEval.getFirstRow();
        int n4 = areaEval.getFirstColumn();
        if (n4 > (n2 = areaEval2.getLastColumn())) {
            return null;
        }
        int n5 = areaEval2.getFirstColumn();
        if (n5 > areaEval.getLastColumn()) {
            return null;
        }
        int n6 = areaEval2.getLastRow();
        if (n3 > n6) {
            return null;
        }
        int n7 = areaEval2.getFirstRow();
        if (n7 > (n = areaEval.getLastRow())) {
            return null;
        }
        int n8 = Math.max(n3, n7);
        int n9 = Math.min(n, n6);
        int n10 = Math.max(n4, n5);
        int n11 = Math.min(areaEval.getLastColumn(), n2);
        return areaEval.offset(n8 - n3, n9 - n3, n10 - n4, n11 - n4);
    }

    private static AreaEval evaluateRef(ValueEval valueEval) throws EvaluationException {
        if (valueEval instanceof AreaEval) {
            return (AreaEval)valueEval;
        }
        if (valueEval instanceof RefEval) {
            return ((RefEval)valueEval).offset(0, 0, 0, 0);
        }
        if (valueEval instanceof ErrorEval) {
            throw new EvaluationException((ErrorEval)valueEval);
        }
        throw new IllegalArgumentException("Unexpected ref arg class (" + valueEval.getClass().getName() + ")");
    }
}

