/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.ss.formula.eval;

import ai.org.apache.poi.ss.formula.eval.ValueEval;
import ai.org.apache.poi.ss.usermodel.ErrorConstants;

public final class ErrorEval
implements ValueEval {
    private static final ErrorConstants EC = null;
    public static final ErrorEval NULL_INTERSECTION = new ErrorEval(0);
    public static final ErrorEval DIV_ZERO = new ErrorEval(7);
    public static final ErrorEval VALUE_INVALID = new ErrorEval(15);
    public static final ErrorEval REF_INVALID = new ErrorEval(23);
    public static final ErrorEval NAME_INVALID = new ErrorEval(29);
    public static final ErrorEval NUM_ERROR = new ErrorEval(36);
    public static final ErrorEval NA = new ErrorEval(42);
    private static final int CIRCULAR_REF_ERROR_CODE = -60;
    private static final int FUNCTION_NOT_IMPLEMENTED_CODE = -30;
    public static final ErrorEval CIRCULAR_REF_ERROR = new ErrorEval(-60);
    private int _errorCode;

    public static ErrorEval valueOf(int n) {
        switch (n) {
            case 0: {
                return NULL_INTERSECTION;
            }
            case 7: {
                return DIV_ZERO;
            }
            case 15: {
                return VALUE_INVALID;
            }
            case 23: {
                return REF_INVALID;
            }
            case 29: {
                return NAME_INVALID;
            }
            case 36: {
                return NUM_ERROR;
            }
            case 42: {
                return NA;
            }
            case -60: {
                return CIRCULAR_REF_ERROR;
            }
        }
        throw new RuntimeException("Unexpected error code (" + n + ")");
    }

    public static String getText(int n) {
        if (ErrorConstants.isValidCode(n)) {
            return ErrorConstants.getText(n);
        }
        switch (n) {
            case -60: {
                return "~CIRCULAR~REF~";
            }
            case -30: {
                return "~FUNCTION~NOT~IMPLEMENTED~";
            }
        }
        return "~non~std~err(" + n + ")~";
    }

    private ErrorEval(int n) {
        this._errorCode = n;
    }

    public int getErrorCode() {
        return this._errorCode;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append(this.getClass().getName()).append(" [");
        stringBuffer.append(ErrorEval.getText(this._errorCode));
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

