/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.ss.formula.atp;

import ai.org.apache.poi.ss.formula.eval.ErrorEval;
import ai.org.apache.poi.ss.formula.eval.EvaluationException;
import ai.org.apache.poi.ss.usermodel.DateUtil;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;

final class YearFracCalculator {
    private static final TimeZone UTC_TIME_ZONE = TimeZone.getTimeZone("UTC");
    private static final int MS_PER_HOUR = 3600000;
    private static final int MS_PER_DAY = 86400000;
    private static final int DAYS_PER_NORMAL_YEAR = 365;
    private static final int DAYS_PER_LEAP_YEAR = 366;
    private static final int LONG_MONTH_LEN = 31;
    private static final int SHORT_MONTH_LEN = 30;
    private static final int SHORT_FEB_LEN = 28;
    private static final int LONG_FEB_LEN = 29;

    private YearFracCalculator() {
    }

    public static double calculate(double d, double d2, int n) throws EvaluationException {
        int n2;
        if (n < 0 || n >= 5) {
            throw new EvaluationException(ErrorEval.NUM_ERROR);
        }
        int n3 = (int)Math.floor(d);
        if (n3 == (n2 = (int)Math.floor(d2))) {
            return 0.0;
        }
        if (n3 > n2) {
            int n4 = n3;
            n3 = n2;
            n2 = n4;
        }
        switch (n) {
            case 0: {
                return YearFracCalculator.basis0(n3, n2);
            }
            case 1: {
                return YearFracCalculator.basis1(n3, n2);
            }
            case 2: {
                return YearFracCalculator.basis2(n3, n2);
            }
            case 3: {
                return YearFracCalculator.basis3(n3, n2);
            }
            case 4: {
                return YearFracCalculator.basis4(n3, n2);
            }
        }
        throw new IllegalStateException("cannot happen");
    }

    public static double basis0(int n, int n2) {
        SimpleDate simpleDate = YearFracCalculator.createDate(n);
        SimpleDate simpleDate2 = YearFracCalculator.createDate(n2);
        int n3 = simpleDate.day;
        int n4 = simpleDate2.day;
        if (n3 == 31 && n4 == 31) {
            n3 = 30;
            n4 = 30;
        } else if (n3 == 31) {
            n3 = 30;
        } else if (n3 == 30 && n4 == 31) {
            n4 = 30;
        } else if (simpleDate.month == 2 && YearFracCalculator.isLastDayOfMonth(simpleDate)) {
            n3 = 30;
            if (simpleDate2.month == 2 && YearFracCalculator.isLastDayOfMonth(simpleDate2)) {
                n4 = 30;
            }
        }
        return YearFracCalculator.calculateAdjusted(simpleDate, simpleDate2, n3, n4);
    }

    public static double basis1(int n, int n2) {
        SimpleDate simpleDate;
        SimpleDate simpleDate2 = YearFracCalculator.createDate(n);
        double d = YearFracCalculator.isGreaterThanOneYear(simpleDate2, simpleDate = YearFracCalculator.createDate(n2)) ? YearFracCalculator.averageYearLength(simpleDate2.year, simpleDate.year) : (YearFracCalculator.shouldCountFeb29(simpleDate2, simpleDate) ? 366.0 : 365.0);
        return (double)YearFracCalculator.dateDiff(simpleDate2.tsMilliseconds, simpleDate.tsMilliseconds) / d;
    }

    public static double basis2(int n, int n2) {
        return (double)(n2 - n) / 360.0;
    }

    public static double basis3(double d, double d2) {
        return (d2 - d) / 365.0;
    }

    public static double basis4(int n, int n2) {
        SimpleDate simpleDate = YearFracCalculator.createDate(n);
        SimpleDate simpleDate2 = YearFracCalculator.createDate(n2);
        int n3 = simpleDate.day;
        int n4 = simpleDate2.day;
        if (n3 == 31) {
            n3 = 30;
        }
        if (n4 == 31) {
            n4 = 30;
        }
        return YearFracCalculator.calculateAdjusted(simpleDate, simpleDate2, n3, n4);
    }

    private static double calculateAdjusted(SimpleDate simpleDate, SimpleDate simpleDate2, int n, int n2) {
        double d = (simpleDate2.year - simpleDate.year) * 360 + (simpleDate2.month - simpleDate.month) * 30 + (n2 - n) * 1;
        return d / 360.0;
    }

    private static boolean isLastDayOfMonth(SimpleDate simpleDate) {
        if (simpleDate.day < 28) {
            return false;
        }
        return simpleDate.day == YearFracCalculator.getLastDayOfMonth(simpleDate);
    }

    private static int getLastDayOfMonth(SimpleDate simpleDate) {
        switch (simpleDate.month) {
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 12: {
                return 31;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: {
                return 30;
            }
        }
        if (YearFracCalculator.isLeapYear(simpleDate.year)) {
            return 29;
        }
        return 28;
    }

    private static boolean shouldCountFeb29(SimpleDate simpleDate, SimpleDate simpleDate2) {
        boolean bl = YearFracCalculator.isLeapYear(simpleDate.year);
        if (bl && simpleDate.year == simpleDate2.year) {
            return true;
        }
        boolean bl2 = YearFracCalculator.isLeapYear(simpleDate2.year);
        if (!bl && !bl2) {
            return false;
        }
        if (bl) {
            switch (simpleDate.month) {
                case 1: 
                case 2: {
                    return true;
                }
            }
            return false;
        }
        if (bl2) {
            switch (simpleDate2.month) {
                case 1: {
                    return false;
                }
                case 2: {
                    break;
                }
                default: {
                    return true;
                }
            }
            return simpleDate2.day == 29;
        }
        return false;
    }

    private static int dateDiff(long l, long l2) {
        long l3 = l2 - l;
        int n = (int)(l3 % 86400000L / 3600000L);
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw new RuntimeException("Unexpected date diff between " + l + " and " + l2);
            }
        }
        return (int)(0.5 + (double)l3 / 8.64E7);
    }

    private static double averageYearLength(int n, int n2) {
        int n3 = 0;
        for (int i = n; i <= n2; ++i) {
            n3 += 365;
            if (!YearFracCalculator.isLeapYear(i)) continue;
            ++n3;
        }
        double d = n2 - n + 1;
        return (double)n3 / d;
    }

    private static boolean isLeapYear(int n) {
        if (n % 4 != 0) {
            return false;
        }
        if (n % 400 == 0) {
            return true;
        }
        return n % 100 != 0;
    }

    private static boolean isGreaterThanOneYear(SimpleDate simpleDate, SimpleDate simpleDate2) {
        if (simpleDate.year == simpleDate2.year) {
            return false;
        }
        if (simpleDate.year + 1 != simpleDate2.year) {
            return true;
        }
        if (simpleDate.month > simpleDate2.month) {
            return false;
        }
        if (simpleDate.month < simpleDate2.month) {
            return true;
        }
        return simpleDate.day < simpleDate2.day;
    }

    private static SimpleDate createDate(int n) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(UTC_TIME_ZONE);
        DateUtil.setCalendar(gregorianCalendar, n, 0, false, false);
        return new SimpleDate(gregorianCalendar);
    }

    private static final class SimpleDate {
        public static final int JANUARY = 1;
        public static final int FEBRUARY = 2;
        public final int year;
        public final int month;
        public final int day;
        public long tsMilliseconds;

        public SimpleDate(Calendar calendar) {
            this.year = calendar.get(1);
            this.month = calendar.get(2) + 1;
            this.day = calendar.get(5);
            this.tsMilliseconds = calendar.getTimeInMillis();
        }
    }
}

