/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.ss.formula.atp;

import ai.org.apache.poi.ss.formula.OperationEvaluationContext;
import ai.org.apache.poi.ss.formula.eval.ErrorEval;
import ai.org.apache.poi.ss.formula.eval.EvaluationException;
import ai.org.apache.poi.ss.formula.eval.NumberEval;
import ai.org.apache.poi.ss.formula.eval.OperandResolver;
import ai.org.apache.poi.ss.formula.eval.ValueEval;
import ai.org.apache.poi.ss.formula.functions.FreeRefFunction;

final class RandBetween
implements FreeRefFunction {
    public static final FreeRefFunction instance = new RandBetween();

    private RandBetween() {
    }

    public ValueEval evaluate(ValueEval[] valueEvalArray, OperationEvaluationContext operationEvaluationContext) {
        double d;
        double d2;
        if (valueEvalArray.length != 2) {
            return ErrorEval.VALUE_INVALID;
        }
        try {
            d2 = OperandResolver.coerceValueToDouble(OperandResolver.getSingleValue(valueEvalArray[0], operationEvaluationContext.getRowIndex(), operationEvaluationContext.getColumnIndex()));
            d = OperandResolver.coerceValueToDouble(OperandResolver.getSingleValue(valueEvalArray[1], operationEvaluationContext.getRowIndex(), operationEvaluationContext.getColumnIndex()));
            if (d2 > d) {
                return ErrorEval.NUM_ERROR;
            }
        }
        catch (EvaluationException evaluationException) {
            return ErrorEval.VALUE_INVALID;
        }
        d2 = Math.ceil(d2);
        d = Math.floor(d);
        if (d2 > d) {
            d = d2;
        }
        return new NumberEval(d2 + (double)((int)(Math.random() * (d - d2 + 1.0))));
    }
}

