/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.ss.formula.atp;

import ai.org.apache.poi.ss.formula.OperationEvaluationContext;
import ai.org.apache.poi.ss.formula.atp.ArgumentsEvaluator;
import ai.org.apache.poi.ss.formula.atp.WorkdayCalculator;
import ai.org.apache.poi.ss.formula.eval.ErrorEval;
import ai.org.apache.poi.ss.formula.eval.EvaluationException;
import ai.org.apache.poi.ss.formula.eval.NumberEval;
import ai.org.apache.poi.ss.formula.eval.ValueEval;
import ai.org.apache.poi.ss.formula.functions.FreeRefFunction;

final class NetworkdaysFunction
implements FreeRefFunction {
    public static final FreeRefFunction instance = new NetworkdaysFunction(ArgumentsEvaluator.instance);
    private ArgumentsEvaluator evaluator;

    private NetworkdaysFunction(ArgumentsEvaluator argumentsEvaluator) {
        this.evaluator = argumentsEvaluator;
    }

    public ValueEval evaluate(ValueEval[] valueEvalArray, OperationEvaluationContext operationEvaluationContext) {
        if (valueEvalArray.length < 2 || valueEvalArray.length > 3) {
            return ErrorEval.VALUE_INVALID;
        }
        int n = operationEvaluationContext.getRowIndex();
        int n2 = operationEvaluationContext.getColumnIndex();
        try {
            double d = this.evaluator.evaluateDateArg(valueEvalArray[0], n, n2);
            double d2 = this.evaluator.evaluateDateArg(valueEvalArray[1], n, n2);
            if (d > d2) {
                return ErrorEval.NAME_INVALID;
            }
            ValueEval valueEval = valueEvalArray.length == 3 ? valueEvalArray[2] : null;
            double[] dArray = this.evaluator.evaluateDatesArg(valueEval, n, n2);
            return new NumberEval(WorkdayCalculator.instance.calculateWorkdays(d, d2, dArray));
        }
        catch (EvaluationException evaluationException) {
            return ErrorEval.VALUE_INVALID;
        }
    }
}

