/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.ss.formula.atp;

import ai.org.apache.poi.ss.formula.eval.ErrorEval;
import ai.org.apache.poi.ss.formula.eval.EvaluationException;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.regex.Pattern;

public class DateParser {
    public DateParser instance = new DateParser();

    private DateParser() {
    }

    public static Calendar parseDate(String string) throws EvaluationException {
        int n;
        int n2;
        int n3;
        String[] stringArray = Pattern.compile("/").split(string);
        if (stringArray.length != 3) {
            throw new EvaluationException(ErrorEval.VALUE_INVALID);
        }
        String string2 = stringArray[2];
        int n4 = string2.indexOf(32);
        if (n4 > 0) {
            string2 = string2.substring(0, n4);
        }
        try {
            n3 = Integer.parseInt(stringArray[0]);
            n2 = Integer.parseInt(stringArray[1]);
            n = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new EvaluationException(ErrorEval.VALUE_INVALID);
        }
        if (n3 < 0 || n2 < 0 || n < 0 || n3 > 12 && n2 > 12 && n > 12) {
            throw new EvaluationException(ErrorEval.VALUE_INVALID);
        }
        if (n3 >= 1900 && n3 < 9999) {
            return DateParser.makeDate(n3, n2, n);
        }
        throw new RuntimeException("Unable to determine date format for text '" + string + "'");
    }

    private static Calendar makeDate(int n, int n2, int n3) throws EvaluationException {
        if (n2 < 1 || n2 > 12) {
            throw new EvaluationException(ErrorEval.VALUE_INVALID);
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar(n, n2 - 1, 1, 0, 0, 0);
        gregorianCalendar.set(14, 0);
        if (n3 < 1 || n3 > ((Calendar)gregorianCalendar).getActualMaximum(5)) {
            throw new EvaluationException(ErrorEval.VALUE_INVALID);
        }
        gregorianCalendar.set(5, n3);
        return gregorianCalendar;
    }
}

