/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.ss.formula.atp;

import ai.org.apache.poi.ss.formula.OperationEvaluationContext;
import ai.org.apache.poi.ss.formula.atp.IfError;
import ai.org.apache.poi.ss.formula.atp.MRound;
import ai.org.apache.poi.ss.formula.atp.NetworkdaysFunction;
import ai.org.apache.poi.ss.formula.atp.ParityFunction;
import ai.org.apache.poi.ss.formula.atp.RandBetween;
import ai.org.apache.poi.ss.formula.atp.WorkdayFunction;
import ai.org.apache.poi.ss.formula.atp.YearFrac;
import ai.org.apache.poi.ss.formula.eval.NotImplementedFunctionException;
import ai.org.apache.poi.ss.formula.eval.ValueEval;
import ai.org.apache.poi.ss.formula.function.FunctionMetadata;
import ai.org.apache.poi.ss.formula.function.FunctionMetadataRegistry;
import ai.org.apache.poi.ss.formula.functions.Bin2Dec;
import ai.org.apache.poi.ss.formula.functions.Complex;
import ai.org.apache.poi.ss.formula.functions.Countifs;
import ai.org.apache.poi.ss.formula.functions.Dec2Bin;
import ai.org.apache.poi.ss.formula.functions.Dec2Hex;
import ai.org.apache.poi.ss.formula.functions.Delta;
import ai.org.apache.poi.ss.formula.functions.EDate;
import ai.org.apache.poi.ss.formula.functions.EOMonth;
import ai.org.apache.poi.ss.formula.functions.FactDouble;
import ai.org.apache.poi.ss.formula.functions.FreeRefFunction;
import ai.org.apache.poi.ss.formula.functions.Hex2Dec;
import ai.org.apache.poi.ss.formula.functions.ImReal;
import ai.org.apache.poi.ss.formula.functions.Imaginary;
import ai.org.apache.poi.ss.formula.functions.Oct2Dec;
import ai.org.apache.poi.ss.formula.functions.Quotient;
import ai.org.apache.poi.ss.formula.functions.Sumifs;
import ai.org.apache.poi.ss.formula.functions.WeekNum;
import ai.org.apache.poi.ss.formula.udf.UDFFinder;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AnalysisToolPak
implements UDFFinder {
    public static final UDFFinder instance = new AnalysisToolPak();
    private final Map<String, FreeRefFunction> _functionsByName = this.createFunctionsMap();

    private AnalysisToolPak() {
    }

    @Override
    public FreeRefFunction findFunction(String string) {
        if (string.startsWith("_xlfn.")) {
            string = string.substring(6);
        }
        return this._functionsByName.get(string.toUpperCase());
    }

    private Map<String, FreeRefFunction> createFunctionsMap() {
        HashMap<String, FreeRefFunction> hashMap = new HashMap<String, FreeRefFunction>(108);
        AnalysisToolPak.r(hashMap, "ACCRINT", null);
        AnalysisToolPak.r(hashMap, "ACCRINTM", null);
        AnalysisToolPak.r(hashMap, "AMORDEGRC", null);
        AnalysisToolPak.r(hashMap, "AMORLINC", null);
        AnalysisToolPak.r(hashMap, "AVERAGEIF", null);
        AnalysisToolPak.r(hashMap, "AVERAGEIFS", null);
        AnalysisToolPak.r(hashMap, "BAHTTEXT", null);
        AnalysisToolPak.r(hashMap, "BESSELI", null);
        AnalysisToolPak.r(hashMap, "BESSELJ", null);
        AnalysisToolPak.r(hashMap, "BESSELK", null);
        AnalysisToolPak.r(hashMap, "BESSELY", null);
        AnalysisToolPak.r(hashMap, "BIN2DEC", Bin2Dec.instance);
        AnalysisToolPak.r(hashMap, "BIN2HEX", null);
        AnalysisToolPak.r(hashMap, "BIN2OCT", null);
        AnalysisToolPak.r(hashMap, "COMPLEX", Complex.instance);
        AnalysisToolPak.r(hashMap, "CONVERT", null);
        AnalysisToolPak.r(hashMap, "COUNTIFS", null);
        AnalysisToolPak.r(hashMap, "COUPDAYBS", null);
        AnalysisToolPak.r(hashMap, "COUPDAYS", null);
        AnalysisToolPak.r(hashMap, "COUPDAYSNC", null);
        AnalysisToolPak.r(hashMap, "COUPNCD", null);
        AnalysisToolPak.r(hashMap, "COUPNUM", null);
        AnalysisToolPak.r(hashMap, "COUPPCD", null);
        AnalysisToolPak.r(hashMap, "CUBEKPIMEMBER", null);
        AnalysisToolPak.r(hashMap, "CUBEMEMBER", null);
        AnalysisToolPak.r(hashMap, "CUBEMEMBERPROPERTY", null);
        AnalysisToolPak.r(hashMap, "CUBERANKEDMEMBER", null);
        AnalysisToolPak.r(hashMap, "CUBESET", null);
        AnalysisToolPak.r(hashMap, "CUBESETCOUNT", null);
        AnalysisToolPak.r(hashMap, "CUBEVALUE", null);
        AnalysisToolPak.r(hashMap, "CUMIPMT", null);
        AnalysisToolPak.r(hashMap, "CUMPRINC", null);
        AnalysisToolPak.r(hashMap, "DEC2BIN", Dec2Bin.instance);
        AnalysisToolPak.r(hashMap, "DEC2HEX", Dec2Hex.instance);
        AnalysisToolPak.r(hashMap, "DEC2OCT", null);
        AnalysisToolPak.r(hashMap, "DELTA", Delta.instance);
        AnalysisToolPak.r(hashMap, "DISC", null);
        AnalysisToolPak.r(hashMap, "DOLLARDE", null);
        AnalysisToolPak.r(hashMap, "DOLLARFR", null);
        AnalysisToolPak.r(hashMap, "DURATION", null);
        AnalysisToolPak.r(hashMap, "EDATE", EDate.instance);
        AnalysisToolPak.r(hashMap, "EFFECT", null);
        AnalysisToolPak.r(hashMap, "EOMONTH", EOMonth.instance);
        AnalysisToolPak.r(hashMap, "ERF", null);
        AnalysisToolPak.r(hashMap, "ERFC", null);
        AnalysisToolPak.r(hashMap, "FACTDOUBLE", FactDouble.instance);
        AnalysisToolPak.r(hashMap, "FVSCHEDULE", null);
        AnalysisToolPak.r(hashMap, "GCD", null);
        AnalysisToolPak.r(hashMap, "GESTEP", null);
        AnalysisToolPak.r(hashMap, "HEX2BIN", null);
        AnalysisToolPak.r(hashMap, "HEX2DEC", Hex2Dec.instance);
        AnalysisToolPak.r(hashMap, "HEX2OCT", null);
        AnalysisToolPak.r(hashMap, "IFERROR", IfError.instance);
        AnalysisToolPak.r(hashMap, "IMABS", null);
        AnalysisToolPak.r(hashMap, "IMAGINARY", Imaginary.instance);
        AnalysisToolPak.r(hashMap, "IMARGUMENT", null);
        AnalysisToolPak.r(hashMap, "IMCONJUGATE", null);
        AnalysisToolPak.r(hashMap, "IMCOS", null);
        AnalysisToolPak.r(hashMap, "IMDIV", null);
        AnalysisToolPak.r(hashMap, "IMEXP", null);
        AnalysisToolPak.r(hashMap, "IMLN", null);
        AnalysisToolPak.r(hashMap, "IMLOG10", null);
        AnalysisToolPak.r(hashMap, "IMLOG2", null);
        AnalysisToolPak.r(hashMap, "IMPOWER", null);
        AnalysisToolPak.r(hashMap, "IMPRODUCT", null);
        AnalysisToolPak.r(hashMap, "IMREAL", ImReal.instance);
        AnalysisToolPak.r(hashMap, "IMSIN", null);
        AnalysisToolPak.r(hashMap, "IMSQRT", null);
        AnalysisToolPak.r(hashMap, "IMSUB", null);
        AnalysisToolPak.r(hashMap, "IMSUM", null);
        AnalysisToolPak.r(hashMap, "INTRATE", null);
        AnalysisToolPak.r(hashMap, "ISEVEN", ParityFunction.IS_EVEN);
        AnalysisToolPak.r(hashMap, "ISODD", ParityFunction.IS_ODD);
        AnalysisToolPak.r(hashMap, "JIS", null);
        AnalysisToolPak.r(hashMap, "LCM", null);
        AnalysisToolPak.r(hashMap, "MDURATION", null);
        AnalysisToolPak.r(hashMap, "MROUND", MRound.instance);
        AnalysisToolPak.r(hashMap, "MULTINOMIAL", null);
        AnalysisToolPak.r(hashMap, "NETWORKDAYS", NetworkdaysFunction.instance);
        AnalysisToolPak.r(hashMap, "NOMINAL", null);
        AnalysisToolPak.r(hashMap, "OCT2BIN", null);
        AnalysisToolPak.r(hashMap, "OCT2DEC", Oct2Dec.instance);
        AnalysisToolPak.r(hashMap, "OCT2HEX", null);
        AnalysisToolPak.r(hashMap, "ODDFPRICE", null);
        AnalysisToolPak.r(hashMap, "ODDFYIELD", null);
        AnalysisToolPak.r(hashMap, "ODDLPRICE", null);
        AnalysisToolPak.r(hashMap, "ODDLYIELD", null);
        AnalysisToolPak.r(hashMap, "PRICE", null);
        AnalysisToolPak.r(hashMap, "PRICEDISC", null);
        AnalysisToolPak.r(hashMap, "PRICEMAT", null);
        AnalysisToolPak.r(hashMap, "QUOTIENT", Quotient.instance);
        AnalysisToolPak.r(hashMap, "RANDBETWEEN", RandBetween.instance);
        AnalysisToolPak.r(hashMap, "RECEIVED", null);
        AnalysisToolPak.r(hashMap, "RTD", null);
        AnalysisToolPak.r(hashMap, "SERIESSUM", null);
        AnalysisToolPak.r(hashMap, "SQRTPI", null);
        AnalysisToolPak.r(hashMap, "SUMIFS", Sumifs.instance);
        AnalysisToolPak.r(hashMap, "TBILLEQ", null);
        AnalysisToolPak.r(hashMap, "TBILLPRICE", null);
        AnalysisToolPak.r(hashMap, "TBILLYIELD", null);
        AnalysisToolPak.r(hashMap, "WEEKNUM", WeekNum.instance);
        AnalysisToolPak.r(hashMap, "WORKDAY", WorkdayFunction.instance);
        AnalysisToolPak.r(hashMap, "XIRR", null);
        AnalysisToolPak.r(hashMap, "XNPV", null);
        AnalysisToolPak.r(hashMap, "YEARFRAC", YearFrac.instance);
        AnalysisToolPak.r(hashMap, "YIELD", null);
        AnalysisToolPak.r(hashMap, "YIELDDISC", null);
        AnalysisToolPak.r(hashMap, "YIELDMAT", null);
        AnalysisToolPak.r(hashMap, "COUNTIFS", Countifs.instance);
        return hashMap;
    }

    private static void r(Map<String, FreeRefFunction> map, String string, FreeRefFunction freeRefFunction) {
        FreeRefFunction freeRefFunction2 = freeRefFunction == null ? new NotImplemented(string) : freeRefFunction;
        map.put(string, freeRefFunction2);
    }

    public static boolean isATPFunction(String string) {
        AnalysisToolPak analysisToolPak = (AnalysisToolPak)instance;
        return analysisToolPak._functionsByName.containsKey(string);
    }

    public static Collection<String> getSupportedFunctionNames() {
        AnalysisToolPak analysisToolPak = (AnalysisToolPak)instance;
        TreeSet<String> treeSet = new TreeSet<String>();
        for (String string : analysisToolPak._functionsByName.keySet()) {
            FreeRefFunction freeRefFunction = analysisToolPak._functionsByName.get(string);
            if (freeRefFunction == null || freeRefFunction instanceof NotImplemented) continue;
            treeSet.add(string);
        }
        return Collections.unmodifiableCollection(treeSet);
    }

    public static Collection<String> getNotSupportedFunctionNames() {
        AnalysisToolPak analysisToolPak = (AnalysisToolPak)instance;
        TreeSet<String> treeSet = new TreeSet<String>();
        for (String string : analysisToolPak._functionsByName.keySet()) {
            FreeRefFunction freeRefFunction = analysisToolPak._functionsByName.get(string);
            if (freeRefFunction == null || !(freeRefFunction instanceof NotImplemented)) continue;
            treeSet.add(string);
        }
        return Collections.unmodifiableCollection(treeSet);
    }

    public static void registerFunction(String string, FreeRefFunction freeRefFunction) {
        AnalysisToolPak analysisToolPak = (AnalysisToolPak)instance;
        if (!AnalysisToolPak.isATPFunction(string)) {
            FunctionMetadata functionMetadata = FunctionMetadataRegistry.getFunctionByName(string);
            if (functionMetadata != null) {
                throw new IllegalArgumentException(string + " is a built-in Excel function. " + "Use FunctoinEval.registerFunction(String name, Function func) instead.");
            }
            throw new IllegalArgumentException(string + " is not a function from the Excel Analysis Toolpack.");
        }
        FreeRefFunction freeRefFunction2 = analysisToolPak.findFunction(string);
        if (freeRefFunction2 != null && !(freeRefFunction2 instanceof NotImplemented)) {
            throw new IllegalArgumentException("POI already implememts " + string + ". You cannot override POI's implementations of Excel functions");
        }
        analysisToolPak._functionsByName.put(string, freeRefFunction);
    }

    private static final class NotImplemented
    implements FreeRefFunction {
        private final String _functionName;

        public NotImplemented(String string) {
            this._functionName = string;
        }

        public ValueEval evaluate(ValueEval[] valueEvalArray, OperationEvaluationContext operationEvaluationContext) {
            throw new NotImplementedFunctionException(this._functionName);
        }
    }
}

