/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.ss.formula;

import ai.org.apache.poi.ss.formula.ParseNode;
import ai.org.apache.poi.ss.formula.ptg.AbstractFunctionPtg;
import ai.org.apache.poi.ss.formula.ptg.AttrPtg;
import ai.org.apache.poi.ss.formula.ptg.ControlPtg;
import ai.org.apache.poi.ss.formula.ptg.FuncVarPtg;
import ai.org.apache.poi.ss.formula.ptg.MemAreaPtg;
import ai.org.apache.poi.ss.formula.ptg.MemFuncPtg;
import ai.org.apache.poi.ss.formula.ptg.Ptg;
import ai.org.apache.poi.ss.formula.ptg.RangePtg;
import ai.org.apache.poi.ss.formula.ptg.UnionPtg;
import ai.org.apache.poi.ss.formula.ptg.ValueOperatorPtg;

final class OperandClassTransformer {
    private final int _formulaType;

    public OperandClassTransformer(int n) {
        this._formulaType = n;
    }

    public void transformFormula(ParseNode parseNode) {
        byte by;
        switch (this._formulaType) {
            case 0: {
                by = 32;
                break;
            }
            case 2: {
                by = 64;
                break;
            }
            case 4: 
            case 5: {
                by = 0;
                break;
            }
            default: {
                throw new RuntimeException("Incomplete code - formula type (" + this._formulaType + ") not supported yet");
            }
        }
        this.transformNode(parseNode, by, false);
    }

    private void transformNode(ParseNode parseNode, byte by, boolean bl) {
        Ptg ptg = parseNode.getToken();
        ParseNode[] parseNodeArray = parseNode.getChildren();
        boolean bl2 = OperandClassTransformer.isSimpleValueFunction(ptg);
        if (bl2) {
            boolean bl3 = by == 64;
            for (int i = 0; i < parseNodeArray.length; ++i) {
                this.transformNode(parseNodeArray[i], by, bl3);
            }
            this.setSimpleValueFuncClass((AbstractFunctionPtg)ptg, by, bl);
            return;
        }
        if (OperandClassTransformer.isSingleArgSum(ptg)) {
            ptg = FuncVarPtg.SUM;
        }
        if (ptg instanceof ValueOperatorPtg || ptg instanceof ControlPtg || ptg instanceof MemFuncPtg || ptg instanceof MemAreaPtg || ptg instanceof UnionPtg) {
            byte by2 = by == 0 ? (byte)32 : (byte)by;
            for (int i = 0; i < parseNodeArray.length; ++i) {
                this.transformNode(parseNodeArray[i], by2, bl);
            }
            return;
        }
        if (ptg instanceof AbstractFunctionPtg) {
            this.transformFunctionNode((AbstractFunctionPtg)ptg, parseNodeArray, by, bl);
            return;
        }
        if (parseNodeArray.length > 0) {
            if (ptg == RangePtg.instance) {
                return;
            }
            throw new IllegalStateException("Node should not have any children");
        }
        if (ptg.isBaseToken()) {
            return;
        }
        ptg.setClass(this.transformClass(ptg.getPtgClass(), by, bl));
    }

    private static boolean isSingleArgSum(Ptg ptg) {
        if (ptg instanceof AttrPtg) {
            AttrPtg attrPtg = (AttrPtg)ptg;
            return attrPtg.isSum();
        }
        return false;
    }

    private static boolean isSimpleValueFunction(Ptg ptg) {
        if (ptg instanceof AbstractFunctionPtg) {
            AbstractFunctionPtg abstractFunctionPtg = (AbstractFunctionPtg)ptg;
            if (abstractFunctionPtg.getDefaultOperandClass() != 32) {
                return false;
            }
            int n = abstractFunctionPtg.getNumberOfOperands();
            for (int i = n - 1; i >= 0; --i) {
                if (abstractFunctionPtg.getParameterClass(i) == 32) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private byte transformClass(byte by, byte by2, boolean bl) {
        switch (by2) {
            case 32: {
                if (!bl) {
                    return 32;
                }
            }
            case 64: {
                return 64;
            }
            case 0: {
                if (!bl) {
                    return by;
                }
                return 0;
            }
        }
        throw new IllegalStateException("Unexpected operand class (" + by2 + ")");
    }

    private void transformFunctionNode(AbstractFunctionPtg abstractFunctionPtg, ParseNode[] parseNodeArray, byte by, boolean bl) {
        boolean bl2;
        block24: {
            byte by2;
            block23: {
                by2 = abstractFunctionPtg.getDefaultOperandClass();
                if (!bl) break block23;
                switch (by2) {
                    case 0: {
                        if (by == 0) {
                            abstractFunctionPtg.setClass((byte)0);
                        } else {
                            abstractFunctionPtg.setClass((byte)64);
                        }
                        bl2 = false;
                        break block24;
                    }
                    case 64: {
                        abstractFunctionPtg.setClass((byte)64);
                        bl2 = false;
                        break block24;
                    }
                    case 32: {
                        abstractFunctionPtg.setClass((byte)64);
                        bl2 = true;
                        break block24;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected operand class (" + by2 + ")");
                    }
                }
            }
            if (by2 == by) {
                bl2 = false;
                abstractFunctionPtg.setClass(by2);
            } else {
                switch (by) {
                    case 32: {
                        abstractFunctionPtg.setClass((byte)32);
                        bl2 = false;
                        break;
                    }
                    case 64: {
                        switch (by2) {
                            case 0: {
                                abstractFunctionPtg.setClass((byte)0);
                                break;
                            }
                            case 32: {
                                abstractFunctionPtg.setClass((byte)64);
                                break;
                            }
                            default: {
                                throw new IllegalStateException("Unexpected operand class (" + by2 + ")");
                            }
                        }
                        bl2 = by2 == 32;
                        break;
                    }
                    case 0: {
                        switch (by2) {
                            case 64: {
                                abstractFunctionPtg.setClass((byte)64);
                                break;
                            }
                            case 32: {
                                abstractFunctionPtg.setClass((byte)32);
                                break;
                            }
                            default: {
                                throw new IllegalStateException("Unexpected operand class (" + by2 + ")");
                            }
                        }
                        bl2 = false;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected operand class (" + by + ")");
                    }
                }
            }
        }
        for (int i = 0; i < parseNodeArray.length; ++i) {
            ParseNode parseNode = parseNodeArray[i];
            byte by3 = abstractFunctionPtg.getParameterClass(i);
            this.transformNode(parseNode, by3, bl2);
        }
    }

    private void setSimpleValueFuncClass(AbstractFunctionPtg abstractFunctionPtg, byte by, boolean bl) {
        if (bl || by == 64) {
            abstractFunctionPtg.setClass((byte)64);
        } else {
            abstractFunctionPtg.setClass((byte)32);
        }
    }
}

