/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.ss.formula;

import ai.org.apache.poi.ss.formula.SheetRangeEvaluator;
import ai.org.apache.poi.ss.formula.SheetRefEvaluator;
import ai.org.apache.poi.ss.formula.eval.AreaEval;
import ai.org.apache.poi.ss.formula.eval.AreaEvalBase;
import ai.org.apache.poi.ss.formula.eval.ValueEval;
import ai.org.apache.poi.ss.formula.ptg.AreaI;
import ai.org.apache.poi.ss.util.CellReference;

final class LazyAreaEval
extends AreaEvalBase {
    private final SheetRangeEvaluator _evaluator;

    LazyAreaEval(AreaI areaI, SheetRangeEvaluator sheetRangeEvaluator) {
        super(areaI, sheetRangeEvaluator);
        this._evaluator = sheetRangeEvaluator;
    }

    public LazyAreaEval(int n, int n2, int n3, int n4, SheetRangeEvaluator sheetRangeEvaluator) {
        super(sheetRangeEvaluator, n, n2, n3, n4);
        this._evaluator = sheetRangeEvaluator;
    }

    public ValueEval getRelativeValue(int n, int n2) {
        return this.getRelativeValue(this.getFirstSheetIndex(), n, n2);
    }

    public ValueEval getRelativeValue(int n, int n2, int n3) {
        int n4 = n2 + this.getFirstRow();
        int n5 = n3 + this.getFirstColumn();
        return this._evaluator.getEvalForCell(n, n4, n5);
    }

    public AreaEval offset(int n, int n2, int n3, int n4) {
        AreaI.OffsetArea offsetArea = new AreaI.OffsetArea(this.getFirstRow(), this.getFirstColumn(), n, n2, n3, n4);
        return new LazyAreaEval((AreaI)offsetArea, this._evaluator);
    }

    public LazyAreaEval getRow(int n) {
        if (n >= this.getHeight()) {
            throw new IllegalArgumentException("Invalid rowIndex " + n + ".  Allowable range is (0.." + this.getHeight() + ").");
        }
        int n2 = this.getFirstRow() + n;
        return new LazyAreaEval(n2, this.getFirstColumn(), n2, this.getLastColumn(), this._evaluator);
    }

    public LazyAreaEval getColumn(int n) {
        if (n >= this.getWidth()) {
            throw new IllegalArgumentException("Invalid columnIndex " + n + ".  Allowable range is (0.." + this.getWidth() + ").");
        }
        int n2 = this.getFirstColumn() + n;
        return new LazyAreaEval(this.getFirstRow(), n2, this.getLastRow(), n2, this._evaluator);
    }

    public String toString() {
        CellReference cellReference = new CellReference(this.getFirstRow(), this.getFirstColumn());
        CellReference cellReference2 = new CellReference(this.getLastRow(), this.getLastColumn());
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName()).append("[");
        stringBuffer.append(this._evaluator.getSheetNameRange());
        stringBuffer.append('!');
        stringBuffer.append(cellReference.formatAsString());
        stringBuffer.append(':');
        stringBuffer.append(cellReference2.formatAsString());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public boolean isSubTotal(int n, int n2) {
        SheetRefEvaluator sheetRefEvaluator = this._evaluator.getSheetEvaluator(this._evaluator.getFirstSheetIndex());
        return sheetRefEvaluator.isSubTotal(this.getFirstRow() + n, this.getFirstColumn() + n2);
    }
}

