/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.ss.formula;

import ai.org.apache.poi.ss.formula.ptg.Area2DPtgBase;
import ai.org.apache.poi.ss.formula.ptg.Area3DPtg;
import ai.org.apache.poi.ss.formula.ptg.Area3DPxg;
import ai.org.apache.poi.ss.formula.ptg.AreaErrPtg;
import ai.org.apache.poi.ss.formula.ptg.AreaPtg;
import ai.org.apache.poi.ss.formula.ptg.AreaPtgBase;
import ai.org.apache.poi.ss.formula.ptg.Deleted3DPxg;
import ai.org.apache.poi.ss.formula.ptg.DeletedArea3DPtg;
import ai.org.apache.poi.ss.formula.ptg.DeletedRef3DPtg;
import ai.org.apache.poi.ss.formula.ptg.Ptg;
import ai.org.apache.poi.ss.formula.ptg.Ref3DPtg;
import ai.org.apache.poi.ss.formula.ptg.Ref3DPxg;
import ai.org.apache.poi.ss.formula.ptg.RefErrorPtg;
import ai.org.apache.poi.ss.formula.ptg.RefPtg;
import ai.org.apache.poi.ss.formula.ptg.RefPtgBase;

public final class FormulaShifter {
    private final int _externSheetIndex;
    private final String _sheetName;
    private final int _firstMovedIndex;
    private final int _lastMovedIndex;
    private final int _amountToMove;
    private final int _srcSheetIndex;
    private final int _dstSheetIndex;
    private final ShiftMode _mode;

    private FormulaShifter(int n, String string, int n2, int n3, int n4) {
        if (n4 == 0) {
            throw new IllegalArgumentException("amountToMove must not be zero");
        }
        if (n2 > n3) {
            throw new IllegalArgumentException("firstMovedIndex, lastMovedIndex out of order");
        }
        this._externSheetIndex = n;
        this._sheetName = string;
        this._firstMovedIndex = n2;
        this._lastMovedIndex = n3;
        this._amountToMove = n4;
        this._mode = ShiftMode.Row;
        this._dstSheetIndex = -1;
        this._srcSheetIndex = -1;
    }

    private FormulaShifter(int n, int n2) {
        this._amountToMove = -1;
        this._lastMovedIndex = -1;
        this._firstMovedIndex = -1;
        this._externSheetIndex = -1;
        this._sheetName = null;
        this._srcSheetIndex = n;
        this._dstSheetIndex = n2;
        this._mode = ShiftMode.Sheet;
    }

    public static FormulaShifter createForRowShift(int n, String string, int n2, int n3, int n4) {
        return new FormulaShifter(n, string, n2, n3, n4);
    }

    public static FormulaShifter createForSheetShift(int n, int n2) {
        return new FormulaShifter(n, n2);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append(" [");
        stringBuffer.append(this._firstMovedIndex);
        stringBuffer.append(this._lastMovedIndex);
        stringBuffer.append(this._amountToMove);
        return stringBuffer.toString();
    }

    public boolean adjustFormula(Ptg[] ptgArray, int n) {
        boolean bl = false;
        for (int i = 0; i < ptgArray.length; ++i) {
            Ptg ptg = this.adjustPtg(ptgArray[i], n);
            if (ptg == null) continue;
            bl = true;
            ptgArray[i] = ptg;
        }
        return bl;
    }

    private Ptg adjustPtg(Ptg ptg, int n) {
        switch (this._mode) {
            case Row: {
                return this.adjustPtgDueToRowMove(ptg, n);
            }
            case Sheet: {
                return this.adjustPtgDueToShiftMove(ptg);
            }
        }
        throw new IllegalStateException("Unsupported shift mode: " + (Object)((Object)this._mode));
    }

    private Ptg adjustPtgDueToRowMove(Ptg ptg, int n) {
        if (ptg instanceof RefPtg) {
            if (n != this._externSheetIndex) {
                return null;
            }
            RefPtg refPtg = (RefPtg)ptg;
            return this.rowMoveRefPtg(refPtg);
        }
        if (ptg instanceof Ref3DPtg) {
            Ref3DPtg ref3DPtg = (Ref3DPtg)ptg;
            if (this._externSheetIndex != ref3DPtg.getExternSheetIndex()) {
                return null;
            }
            return this.rowMoveRefPtg(ref3DPtg);
        }
        if (ptg instanceof Ref3DPxg) {
            Ref3DPxg ref3DPxg = (Ref3DPxg)ptg;
            if (ref3DPxg.getExternalWorkbookNumber() > 0 || !this._sheetName.equals(ref3DPxg.getSheetName())) {
                return null;
            }
            return this.rowMoveRefPtg(ref3DPxg);
        }
        if (ptg instanceof Area2DPtgBase) {
            if (n != this._externSheetIndex) {
                return ptg;
            }
            return this.rowMoveAreaPtg((Area2DPtgBase)ptg);
        }
        if (ptg instanceof Area3DPtg) {
            Area3DPtg area3DPtg = (Area3DPtg)ptg;
            if (this._externSheetIndex != area3DPtg.getExternSheetIndex()) {
                return null;
            }
            return this.rowMoveAreaPtg(area3DPtg);
        }
        if (ptg instanceof Area3DPxg) {
            Area3DPxg area3DPxg = (Area3DPxg)ptg;
            if (area3DPxg.getExternalWorkbookNumber() > 0 || !this._sheetName.equals(area3DPxg.getSheetName())) {
                return null;
            }
            return this.rowMoveAreaPtg(area3DPxg);
        }
        return null;
    }

    private Ptg adjustPtgDueToShiftMove(Ptg ptg) {
        Ref3DPtg ref3DPtg = null;
        if (ptg instanceof Ref3DPtg) {
            Ref3DPtg ref3DPtg2 = (Ref3DPtg)ptg;
            if (ref3DPtg2.getExternSheetIndex() == this._srcSheetIndex) {
                ref3DPtg2.setExternSheetIndex(this._dstSheetIndex);
                ref3DPtg = ref3DPtg2;
            } else if (ref3DPtg2.getExternSheetIndex() == this._dstSheetIndex) {
                ref3DPtg2.setExternSheetIndex(this._srcSheetIndex);
                ref3DPtg = ref3DPtg2;
            }
        }
        return ref3DPtg;
    }

    private Ptg rowMoveRefPtg(RefPtgBase refPtgBase) {
        int n = refPtgBase.getRow();
        if (this._firstMovedIndex <= n && n <= this._lastMovedIndex) {
            refPtgBase.setRow(n + this._amountToMove);
            return refPtgBase;
        }
        int n2 = this._firstMovedIndex + this._amountToMove;
        int n3 = this._lastMovedIndex + this._amountToMove;
        if (n3 < n || n < n2) {
            return null;
        }
        if (n2 <= n && n <= n3) {
            return FormulaShifter.createDeletedRef(refPtgBase);
        }
        throw new IllegalStateException("Situation not covered: (" + this._firstMovedIndex + ", " + this._lastMovedIndex + ", " + this._amountToMove + ", " + n + ", " + n + ")");
    }

    private Ptg rowMoveAreaPtg(AreaPtgBase areaPtgBase) {
        int n = areaPtgBase.getFirstRow();
        int n2 = areaPtgBase.getLastRow();
        if (this._firstMovedIndex <= n && n2 <= this._lastMovedIndex) {
            areaPtgBase.setFirstRow(n + this._amountToMove);
            areaPtgBase.setLastRow(n2 + this._amountToMove);
            return areaPtgBase;
        }
        int n3 = this._firstMovedIndex + this._amountToMove;
        int n4 = this._lastMovedIndex + this._amountToMove;
        if (n < this._firstMovedIndex && this._lastMovedIndex < n2) {
            if (n3 < n && n <= n4) {
                areaPtgBase.setFirstRow(n4 + 1);
                return areaPtgBase;
            }
            if (n3 <= n2 && n2 < n4) {
                areaPtgBase.setLastRow(n3 - 1);
                return areaPtgBase;
            }
            return null;
        }
        if (this._firstMovedIndex <= n && n <= this._lastMovedIndex) {
            if (this._amountToMove < 0) {
                areaPtgBase.setFirstRow(n + this._amountToMove);
                return areaPtgBase;
            }
            if (n3 > n2) {
                return null;
            }
            int n5 = n + this._amountToMove;
            if (n4 < n2) {
                areaPtgBase.setFirstRow(n5);
                return areaPtgBase;
            }
            int n6 = this._lastMovedIndex + 1;
            if (n3 > n6) {
                n5 = n6;
            }
            areaPtgBase.setFirstRow(n5);
            areaPtgBase.setLastRow(Math.max(n2, n4));
            return areaPtgBase;
        }
        if (this._firstMovedIndex <= n2 && n2 <= this._lastMovedIndex) {
            if (this._amountToMove > 0) {
                areaPtgBase.setLastRow(n2 + this._amountToMove);
                return areaPtgBase;
            }
            if (n4 < n) {
                return null;
            }
            int n7 = n2 + this._amountToMove;
            if (n3 > n) {
                areaPtgBase.setLastRow(n7);
                return areaPtgBase;
            }
            int n8 = this._firstMovedIndex - 1;
            if (n4 < n8) {
                n7 = n8;
            }
            areaPtgBase.setFirstRow(Math.min(n, n3));
            areaPtgBase.setLastRow(n7);
            return areaPtgBase;
        }
        if (n4 < n || n2 < n3) {
            return null;
        }
        if (n3 <= n && n2 <= n4) {
            return FormulaShifter.createDeletedRef(areaPtgBase);
        }
        if (n <= n3 && n4 <= n2) {
            return null;
        }
        if (n3 < n && n <= n4) {
            areaPtgBase.setFirstRow(n4 + 1);
            return areaPtgBase;
        }
        if (n3 <= n2 && n2 < n4) {
            areaPtgBase.setLastRow(n3 - 1);
            return areaPtgBase;
        }
        throw new IllegalStateException("Situation not covered: (" + this._firstMovedIndex + ", " + this._lastMovedIndex + ", " + this._amountToMove + ", " + n + ", " + n2 + ")");
    }

    private static Ptg createDeletedRef(Ptg ptg) {
        if (ptg instanceof RefPtg) {
            return new RefErrorPtg();
        }
        if (ptg instanceof Ref3DPtg) {
            Ref3DPtg ref3DPtg = (Ref3DPtg)ptg;
            return new DeletedRef3DPtg(ref3DPtg.getExternSheetIndex());
        }
        if (ptg instanceof AreaPtg) {
            return new AreaErrPtg();
        }
        if (ptg instanceof Area3DPtg) {
            Area3DPtg area3DPtg = (Area3DPtg)ptg;
            return new DeletedArea3DPtg(area3DPtg.getExternSheetIndex());
        }
        if (ptg instanceof Ref3DPxg) {
            Ref3DPxg ref3DPxg = (Ref3DPxg)ptg;
            return new Deleted3DPxg(ref3DPxg.getExternalWorkbookNumber(), ref3DPxg.getSheetName());
        }
        if (ptg instanceof Area3DPxg) {
            Area3DPxg area3DPxg = (Area3DPxg)ptg;
            return new Deleted3DPxg(area3DPxg.getExternalWorkbookNumber(), area3DPxg.getSheetName());
        }
        throw new IllegalArgumentException("Unexpected ref ptg class (" + ptg.getClass().getName() + ")");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ShiftMode {
        Row,
        Sheet;

    }
}

