/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.ss.formula;

import ai.org.apache.poi.ss.formula.FormulaRenderingWorkbook;
import ai.org.apache.poi.ss.formula.WorkbookDependentFormula;
import ai.org.apache.poi.ss.formula.ptg.AttrPtg;
import ai.org.apache.poi.ss.formula.ptg.MemAreaPtg;
import ai.org.apache.poi.ss.formula.ptg.MemErrPtg;
import ai.org.apache.poi.ss.formula.ptg.MemFuncPtg;
import ai.org.apache.poi.ss.formula.ptg.OperationPtg;
import ai.org.apache.poi.ss.formula.ptg.ParenthesisPtg;
import ai.org.apache.poi.ss.formula.ptg.Ptg;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormulaRenderer {
    public static String toFormulaString(FormulaRenderingWorkbook formulaRenderingWorkbook, Ptg[] ptgArray) {
        if (ptgArray == null || ptgArray.length == 0) {
            throw new IllegalArgumentException("ptgs must not be null");
        }
        Stack<String> stack = new Stack<String>();
        for (Ptg ptg : ptgArray) {
            String[] stringArray;
            Object object;
            if (ptg instanceof MemAreaPtg || ptg instanceof MemFuncPtg || ptg instanceof MemErrPtg) continue;
            if (ptg instanceof ParenthesisPtg) {
                object = (String)stack.pop();
                stack.push("(" + (String)object + ")");
                continue;
            }
            if (ptg instanceof AttrPtg) {
                object = (AttrPtg)ptg;
                if (((AttrPtg)object).isOptimizedIf() || ((AttrPtg)object).isOptimizedChoose() || ((AttrPtg)object).isSkip() || ((AttrPtg)object).isSpace() || ((AttrPtg)object).isSemiVolatile()) continue;
                if (((AttrPtg)object).isSum()) {
                    stringArray = FormulaRenderer.getOperands(stack, ((AttrPtg)object).getNumberOfOperands());
                    stack.push(((AttrPtg)object).toFormulaString(stringArray));
                    continue;
                }
                throw new RuntimeException("Unexpected tAttr: " + ((AttrPtg)object).toString());
            }
            if (ptg instanceof WorkbookDependentFormula) {
                object = (WorkbookDependentFormula)((Object)ptg);
                stack.push(object.toFormulaString(formulaRenderingWorkbook));
                continue;
            }
            if (!(ptg instanceof OperationPtg)) {
                stack.push(ptg.toFormulaString());
                continue;
            }
            object = (OperationPtg)ptg;
            stringArray = FormulaRenderer.getOperands(stack, ((OperationPtg)object).getNumberOfOperands());
            stack.push(((OperationPtg)object).toFormulaString(stringArray));
        }
        if (stack.isEmpty()) {
            throw new IllegalStateException("Stack underflow");
        }
        String string = (String)stack.pop();
        if (!stack.isEmpty()) {
            throw new IllegalStateException("too much stuff left on the stack");
        }
        return string;
    }

    private static String[] getOperands(Stack<String> stack, int n) {
        String[] stringArray = new String[n];
        for (int i = n - 1; i >= 0; --i) {
            if (stack.isEmpty()) {
                String string = "Too few arguments supplied to operation. Expected (" + n + ") operands but got (" + (n - i - 1) + ")";
                throw new IllegalStateException(string);
            }
            stringArray[i] = stack.pop();
        }
        return stringArray;
    }
}

