/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.ss.formula;

import ai.org.apache.poi.ss.formula.CellCacheEntry;
import ai.org.apache.poi.ss.formula.FormulaCellCacheEntry;

final class FormulaCellCacheEntrySet {
    private static final FormulaCellCacheEntry[] EMPTY_ARRAY = new FormulaCellCacheEntry[0];
    private int _size;
    private FormulaCellCacheEntry[] _arr = EMPTY_ARRAY;

    public FormulaCellCacheEntry[] toArray() {
        int n = this._size;
        if (n < 1) {
            return EMPTY_ARRAY;
        }
        FormulaCellCacheEntry[] formulaCellCacheEntryArray = new FormulaCellCacheEntry[n];
        int n2 = 0;
        for (int i = 0; i < this._arr.length; ++i) {
            FormulaCellCacheEntry formulaCellCacheEntry = this._arr[i];
            if (formulaCellCacheEntry == null) continue;
            formulaCellCacheEntryArray[n2++] = formulaCellCacheEntry;
        }
        if (n2 != n) {
            throw new IllegalStateException("size mismatch");
        }
        return formulaCellCacheEntryArray;
    }

    public void add(CellCacheEntry cellCacheEntry) {
        if (this._size * 3 >= this._arr.length * 2) {
            FormulaCellCacheEntry[] formulaCellCacheEntryArray = this._arr;
            CellCacheEntry[] cellCacheEntryArray = new FormulaCellCacheEntry[4 + this._arr.length * 3 / 2];
            for (int i = 0; i < formulaCellCacheEntryArray.length; ++i) {
                FormulaCellCacheEntry formulaCellCacheEntry = this._arr[i];
                if (formulaCellCacheEntry == null) continue;
                FormulaCellCacheEntrySet.addInternal(cellCacheEntryArray, formulaCellCacheEntry);
            }
            this._arr = cellCacheEntryArray;
        }
        if (FormulaCellCacheEntrySet.addInternal(this._arr, cellCacheEntry)) {
            ++this._size;
        }
    }

    private static boolean addInternal(CellCacheEntry[] cellCacheEntryArray, CellCacheEntry cellCacheEntry) {
        CellCacheEntry cellCacheEntry2;
        int n;
        int n2;
        for (n2 = n = Math.abs(cellCacheEntry.hashCode() % cellCacheEntryArray.length); n2 < cellCacheEntryArray.length; ++n2) {
            cellCacheEntry2 = cellCacheEntryArray[n2];
            if (cellCacheEntry2 == cellCacheEntry) {
                return false;
            }
            if (cellCacheEntry2 != null) continue;
            cellCacheEntryArray[n2] = cellCacheEntry;
            return true;
        }
        for (n2 = 0; n2 < n; ++n2) {
            cellCacheEntry2 = cellCacheEntryArray[n2];
            if (cellCacheEntry2 == cellCacheEntry) {
                return false;
            }
            if (cellCacheEntry2 != null) continue;
            cellCacheEntryArray[n2] = cellCacheEntry;
            return true;
        }
        throw new IllegalStateException("No empty space found");
    }

    public boolean remove(CellCacheEntry cellCacheEntry) {
        FormulaCellCacheEntry formulaCellCacheEntry;
        int n;
        int n2;
        FormulaCellCacheEntry[] formulaCellCacheEntryArray = this._arr;
        if (this._size * 3 < this._arr.length && this._arr.length > 8) {
            boolean bl = false;
            FormulaCellCacheEntry[] formulaCellCacheEntryArray2 = this._arr;
            CellCacheEntry[] cellCacheEntryArray = new FormulaCellCacheEntry[this._arr.length / 2];
            for (int i = 0; i < formulaCellCacheEntryArray2.length; ++i) {
                FormulaCellCacheEntry formulaCellCacheEntry2 = this._arr[i];
                if (formulaCellCacheEntry2 == null) continue;
                if (formulaCellCacheEntry2 == cellCacheEntry) {
                    bl = true;
                    --this._size;
                    continue;
                }
                FormulaCellCacheEntrySet.addInternal(cellCacheEntryArray, formulaCellCacheEntry2);
            }
            this._arr = cellCacheEntryArray;
            return bl;
        }
        for (n2 = n = Math.abs(cellCacheEntry.hashCode() % formulaCellCacheEntryArray.length); n2 < formulaCellCacheEntryArray.length; ++n2) {
            formulaCellCacheEntry = formulaCellCacheEntryArray[n2];
            if (formulaCellCacheEntry != cellCacheEntry) continue;
            formulaCellCacheEntryArray[n2] = null;
            --this._size;
            return true;
        }
        for (n2 = 0; n2 < n; ++n2) {
            formulaCellCacheEntry = formulaCellCacheEntryArray[n2];
            if (formulaCellCacheEntry != cellCacheEntry) continue;
            formulaCellCacheEntryArray[n2] = null;
            --this._size;
            return true;
        }
        return false;
    }
}

