/*
 * Decompiled with CFR 0.152.
 */
package ai.org.apache.poi.ss.formula;

import ai.org.apache.poi.ss.formula.CellCacheEntry;
import ai.org.apache.poi.ss.formula.EvaluationCell;
import ai.org.apache.poi.ss.formula.FormulaCellCacheEntry;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

final class FormulaCellCache {
    private final Map<Object, FormulaCellCacheEntry> _formulaEntriesByCell = new HashMap<Object, FormulaCellCacheEntry>();

    public CellCacheEntry[] getCacheEntries() {
        CellCacheEntry[] cellCacheEntryArray = new FormulaCellCacheEntry[this._formulaEntriesByCell.size()];
        this._formulaEntriesByCell.values().toArray(cellCacheEntryArray);
        return cellCacheEntryArray;
    }

    public void clear() {
        this._formulaEntriesByCell.clear();
    }

    public FormulaCellCacheEntry get(EvaluationCell evaluationCell) {
        return this._formulaEntriesByCell.get(evaluationCell.getIdentityKey());
    }

    public void put(EvaluationCell evaluationCell, FormulaCellCacheEntry formulaCellCacheEntry) {
        this._formulaEntriesByCell.put(evaluationCell.getIdentityKey(), formulaCellCacheEntry);
    }

    public FormulaCellCacheEntry remove(EvaluationCell evaluationCell) {
        return this._formulaEntriesByCell.remove(evaluationCell.getIdentityKey());
    }

    public void applyOperation(IEntryOperation iEntryOperation) {
        Iterator<FormulaCellCacheEntry> iterator = this._formulaEntriesByCell.values().iterator();
        while (iterator.hasNext()) {
            iEntryOperation.processEntry(iterator.next());
        }
    }

    static interface IEntryOperation {
        public void processEntry(FormulaCellCacheEntry var1);
    }
}

